/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class DateColumn
extends AbstractColumn {
    private static final long DATE_EPOCH = 315446400000L;

    DateColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 0;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        offset += 6;
        offset += 4;
        offset = FastTrackUtility.skipToNextMatchingShort(buffer, offset, 10) - 2;
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        Calendar cal = Calendar.getInstance();
        byte[][] rawData = data.getData();
        this.m_data = new Date[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            int value;
            byte[] rawValue = rawData[index];
            if (rawValue == null || rawValue.length < 4 || (value = FastTrackUtility.getInt(rawValue, 0)) <= 0) continue;
            cal.setTimeInMillis(315446400000L);
            cal.add(6, value);
            this.m_data[index] = cal.getTime();
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        pw.println("  [Data");
        for (Object item : this.m_data) {
            String value = item == null ? "" : df.format((Date)item);
            pw.println("    " + value);
        }
        pw.println("  ]");
    }
}

