/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.UnexpectedStructureException;

class BlockHeader {
    private byte[] m_header = new byte[8];
    private byte[] m_skip;
    private int m_offset;
    private String m_name;
    private int m_columnType;
    private int m_flags;

    BlockHeader() {
    }

    public BlockHeader read(byte[] buffer, int offset, int postHeaderSkipBytes) {
        this.m_offset = offset;
        System.arraycopy(buffer, this.m_offset, this.m_header, 0, 8);
        this.m_offset += 8;
        int nameLength = FastTrackUtility.getInt(buffer, this.m_offset);
        this.m_offset += 4;
        if (nameLength < 1 || nameLength > 255) {
            throw new UnexpectedStructureException();
        }
        this.m_name = new String(buffer, this.m_offset, nameLength, CharsetHelper.UTF16LE);
        this.m_offset += nameLength;
        this.m_columnType = FastTrackUtility.getShort(buffer, this.m_offset);
        this.m_offset += 2;
        this.m_flags = FastTrackUtility.getShort(buffer, this.m_offset);
        this.m_offset += 2;
        this.m_skip = new byte[postHeaderSkipBytes];
        System.arraycopy(buffer, this.m_offset, this.m_skip, 0, postHeaderSkipBytes);
        this.m_offset += postHeaderSkipBytes;
        return this;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public String getName() {
        return this.m_name;
    }

    public int getColumnType() {
        return this.m_columnType;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("  [BlockHeader");
        pw.print("    Header: " + FastTrackUtility.hexdump(this.m_header, 0, this.m_header.length, false, 16, ""));
        pw.println("    Name: " + this.m_name);
        pw.println("    Type: " + this.m_columnType);
        pw.println("    Flags: " + this.m_flags);
        pw.print("    Skip:\n" + FastTrackUtility.hexdump(this.m_skip, 0, this.m_skip.length, false, 16, "      "));
        pw.println("  ]");
        pw.flush();
        return os.toString();
    }
}

