/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.ActBarField;
import net.sf.mpxj.fasttrack.ActivityField;
import net.sf.mpxj.fasttrack.BlockHeader;
import net.sf.mpxj.fasttrack.FastTrackColumn;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.ResourceField;

abstract class AbstractColumn
implements FastTrackColumn {
    private BlockHeader m_header;
    private byte[] m_trailer;
    private FastTrackField m_type;
    protected Object[] m_data;

    AbstractColumn() {
    }

    @Override
    public void read(FastTrackTableType tableType, byte[] buffer, int startIndex, int length) {
        this.m_header = new BlockHeader().read(buffer, startIndex, this.postHeaderSkipBytes());
        this.setFieldType(tableType);
        int offset = this.readData(buffer, this.m_header.getOffset());
        if (length > offset) {
            this.m_trailer = new byte[length - offset];
            System.arraycopy(buffer, startIndex + offset, this.m_trailer, 0, this.m_trailer.length);
        } else {
            this.m_trailer = new byte[0];
        }
    }

    protected abstract int postHeaderSkipBytes();

    protected abstract int readData(byte[] var1, int var2);

    protected abstract void dumpData(PrintWriter var1);

    @Override
    public String getName() {
        return this.m_header == null ? "<unknown>" : this.m_header.getName();
    }

    @Override
    public FastTrackField getType() {
        return this.m_type;
    }

    @Override
    public Object[] getData() {
        return this.m_data;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[" + this.getClass().getSimpleName());
        pw.println(this.m_header.toString());
        this.dumpData(pw);
        pw.print("  Trailer: " + FastTrackUtility.hexdump(this.m_trailer, 0, this.m_trailer.length, false, 16, ""));
        pw.println("]");
        pw.flush();
        return os.toString();
    }

    private void setFieldType(FastTrackTableType tableType) {
        switch (tableType) {
            case ACTBARS: {
                this.m_type = ActBarField.getInstance(this.m_header.getColumnType());
                break;
            }
            case ACTIVITIES: {
                this.m_type = ActivityField.getInstance(this.m_header.getColumnType());
                break;
            }
            case RESOURCES: {
                this.m_type = ResourceField.getInstance(this.m_header.getColumnType());
            }
        }
    }
}

