/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TimephasedWorkNormaliser;

public abstract class AbstractTimephasedWorkNormaliser
implements TimephasedWorkNormaliser {
    @Override
    public abstract void normalise(ProjectCalendar var1, LinkedList<TimephasedWork> var2);

    protected void mergeSameWork(LinkedList<TimephasedWork> list) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        TimephasedItem previousAssignment = null;
        for (TimephasedWork assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Duration previousAssignmentWork = (Duration)previousAssignment.getAmountPerDay();
                Duration assignmentWork = (Duration)assignment.getTotalAmount();
                if (NumberHelper.equals(previousAssignmentWork.getDuration(), assignmentWork.getDuration(), 0.01)) {
                    Date assignmentStart = previousAssignment.getStart();
                    Date assignmentFinish = assignment.getFinish();
                    double total = ((Duration)previousAssignment.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(total += assignmentWork.getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(assignmentStart);
                    merged.setFinish(assignmentFinish);
                    merged.setAmountPerDay(assignmentWork);
                    merged.setTotalAmount(totalWork);
                    result.removeLast();
                    assignment = merged;
                } else {
                    assignment.setAmountPerDay(assignment.getTotalAmount());
                }
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    protected void convertToHours(LinkedList<TimephasedWork> list) {
        for (TimephasedWork assignment : list) {
            Duration totalWork = (Duration)assignment.getTotalAmount();
            Duration workPerDay = (Duration)assignment.getAmountPerDay();
            totalWork = Duration.getInstance(totalWork.getDuration() / 60.0, TimeUnit.HOURS);
            workPerDay = Duration.getInstance(workPerDay.getDuration() / 60.0, TimeUnit.HOURS);
            assignment.setTotalAmount(totalWork);
            assignment.setAmountPerDay(workPerDay);
        }
    }
}

