/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.AstaDataType;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.common.NumberHelper;

final class SqliteResultSetRow
extends MapRow {
    public SqliteResultSetRow(ResultSet rs, Map<String, Integer> meta) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : meta.entrySet()) {
            Object value;
            String name = entry.getKey().toUpperCase();
            int type = entry.getValue();
            switch (type) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(name);
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    value = rs.getString(name);
                    break;
                }
                case 91: {
                    String stringValue = rs.getString(name);
                    if (stringValue == null || stringValue.isEmpty()) {
                        value = null;
                        break;
                    }
                    value = rs.getDate(name);
                    break;
                }
                case 93: {
                    Timestamp ts = rs.getTimestamp(name);
                    if (ts != null) {
                        value = new Date(ts.getTime());
                        break;
                    }
                    value = null;
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    value = NumberHelper.getDouble(rs.getDouble(name));
                    break;
                }
                case 4: 
                case 5: {
                    value = rs.getInt(name);
                    break;
                }
                case -5: {
                    value = rs.getLong(name);
                    break;
                }
                case -4: 
                case -3: {
                    value = rs.getBytes(name);
                    break;
                }
                case 1111: {
                    value = rs.getObject(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type + " for column " + name);
                }
            }
            if (rs.wasNull()) {
                value = null;
            }
            this.m_map.put(name, value);
        }
    }

    @Override
    public Duration getDuration(String name) {
        Number durationValue;
        String value = this.getString(name);
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Unexpected duration value");
        }
        String[] items = value.split(",");
        if (items.length != 3) {
            throw new IllegalArgumentException("Unexpected duration value: " + value);
        }
        String item = AstaDataType.parseString(items[2]);
        try {
            durationValue = AstaDataType.parseDouble(item);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Unexpected duration value", ex);
        }
        return Duration.getInstance(NumberHelper.getDouble(durationValue), TimeUnit.HOURS);
    }
}

