/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AbstractFileFormat;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.FileFormat10008;
import net.sf.mpxj.asta.FileFormat11004;
import net.sf.mpxj.asta.FileFormat12002;
import net.sf.mpxj.asta.FileFormat12005;
import net.sf.mpxj.asta.FileFormat13004;
import net.sf.mpxj.asta.FileFormat8020;
import net.sf.mpxj.asta.FileFormat9006;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.asta.RowHeader;
import net.sf.mpxj.asta.TableDefinition;
import net.sf.mpxj.asta.TextFileRow;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.ReaderTokenizer;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class AstaTextFileReader
extends AbstractProjectReader {
    private AstaReader m_reader;
    private List<ProjectListener> m_projectListeners;
    private Map<String, List<Row>> m_tables;
    private Map<Integer, TableDefinition> m_tableDefinitions;
    private boolean m_epochDateFormat;
    private static final char DELIMITER = ',';
    private static final RowComparator CALENDAR_COMPARATOR = new RowComparator("CALENDARID");
    private static final RowComparator PERMANENT_RESOURCE_COMPARATOR = new RowComparator("PERMANENT_RESOURCEID");
    private static final RowComparator CONSUMABLE_RESOURCE_COMPARATOR = new RowComparator("CONSUMABLE_RESOURCEID");
    private static final RowComparator LINK_COMPARATOR = new RowComparator("LINKID");
    private static final RowComparator ALLOCATION_COMPARATOR = new RowComparator("PERMANENT_SCHEDUL_ALLOCATIONID");
    private static final Map<Integer, Class<? extends AbstractFileFormat>> FILE_VERSION_MAP = new HashMap<Integer, Class<? extends AbstractFileFormat>>();

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            project.getEventManager().addProjectListeners(this.m_projectListeners);
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.m_reader = null;
        }
    }

    private void processFile(InputStream is) throws MPXJException {
        try {
            InputStreamReader reader = new InputStreamReader(is, CharsetHelper.UTF8);
            ReaderTokenizer tk = new ReaderTokenizer(reader){

                @Override
                protected boolean startQuotedIsValid(StringBuilder buffer) {
                    return buffer.length() == 1 && buffer.charAt(0) == '<';
                }
            };
            tk.setDelimiter(',');
            ArrayList<String> columns = new ArrayList<String>();
            String nextTokenPrefix = null;
            while (tk.getType() != -1) {
                columns.clear();
                TableDefinition table = null;
                while (tk.nextToken() == -3) {
                    String token = tk.getToken();
                    if (columns.size() == 0) {
                        if (token.charAt(0) == '#') {
                            int index = token.lastIndexOf(58);
                            if (index != -1) {
                                String headerToken;
                                if (token.endsWith("-") || token.endsWith("=")) {
                                    headerToken = token;
                                    token = null;
                                } else {
                                    headerToken = token.substring(0, index);
                                    token = token.substring(index + 1);
                                }
                                RowHeader header = new RowHeader(headerToken);
                                table = this.m_tableDefinitions.get(header.getType());
                                columns.add(header.getID());
                            }
                        } else if (token.charAt(0) == '\u0000') {
                            this.processFileType(token);
                        }
                    }
                    if (table == null || token == null) continue;
                    if (token.startsWith("<\"") && !token.endsWith("\">")) {
                        nextTokenPrefix = token;
                        continue;
                    }
                    if (nextTokenPrefix != null) {
                        token = nextTokenPrefix + ',' + token;
                        nextTokenPrefix = null;
                    }
                    columns.add(token);
                }
                if (table == null || columns.size() <= 1) continue;
                TextFileRow row = new TextFileRow(table, columns, this.m_epochDateFormat);
                List<Row> rows = this.m_tables.get(table.getName());
                if (rows == null) {
                    rows = new LinkedList<Row>();
                    this.m_tables.put(table.getName(), rows);
                }
                rows.add(row);
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void processFileType(String token) throws MPXJException {
        String version = token.substring(2).split(" ")[0];
        Class<? extends AbstractFileFormat> fileFormatClass = FILE_VERSION_MAP.get(Integer.valueOf(version));
        if (fileFormatClass == null) {
            throw new MPXJException("Unsupported PP file format version " + version);
        }
        try {
            AbstractFileFormat format = fileFormatClass.newInstance();
            this.m_tableDefinitions = format.tableDefinitions();
            this.m_epochDateFormat = format.epochDateFormat();
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to configure file format", ex);
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> rows = this.getTable("PROJECT_SUMMARY");
        if (!rows.isEmpty()) {
            this.m_reader.processProjectProperties(rows.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getTable("EXCEPTIONN");
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getTable("WORK_PATTERN");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = new LinkedList<Row>();
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.getTable("EXCEPTION_ASSIGNMENT");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.getTable("TIME_ENTRY");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getTable("CALENDAR");
        Collections.sort(rows, CALENDAR_COMPARATOR);
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getTable("PERMANENT_RESOURCE");
        List<Row> consumableRows = this.getTable("CONSUMABLE_RESOURCE");
        Collections.sort(permanentRows, PERMANENT_RESOURCE_COMPARATOR);
        Collections.sort(consumableRows, CONSUMABLE_RESOURCE_COMPARATOR);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> bars = this.getTable("BAR");
        List<Row> expandedTasks = this.getTable("EXPANDED_TASK");
        List<Row> tasks = this.getTable("TASK");
        List<Row> milestones = this.getTable("MILESTONE");
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getTable("LINK");
        Collections.sort(rows, LINK_COMPARATOR);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> allocationRows = this.getTable("PERMANENT_SCHEDUL_ALLOCATION");
        List<Row> skillRows = this.getTable("PERM_RESOURCE_SKILL");
        List<Row> permanentAssignments = this.join(allocationRows, "ALLOCATIOP_OF", "PERM_RESOURCE_SKILL", skillRows, "PERM_RESOURCE_SKILLID");
        Collections.sort(permanentAssignments, ALLOCATION_COMPARATOR);
        this.m_reader.processAssignments(permanentAssignments);
    }

    private List<Row> join(List<Row> leftRows, String leftColumn, String rightTable, List<Row> rightRows, String rightColumn) {
        LinkedList<Row> result = new LinkedList<Row>();
        RowComparator leftComparator = new RowComparator(leftColumn);
        RowComparator rightComparator = new RowComparator(rightColumn);
        Collections.sort(leftRows, leftComparator);
        Collections.sort(rightRows, rightComparator);
        ListIterator<Row> rightIterator = rightRows.listIterator();
        Row rightRow = rightIterator.hasNext() ? rightIterator.next() : null;
        for (Row leftRow : leftRows) {
            Integer leftValue = leftRow.getInteger(leftColumn);
            boolean match = false;
            while (rightRow != null) {
                Integer rightValue = rightRow.getInteger(rightColumn);
                int comparison = leftValue.compareTo(rightValue);
                if (comparison == 0) {
                    match = true;
                    break;
                }
                if (comparison < 0) {
                    if (!rightIterator.hasPrevious()) break;
                    rightRow = rightIterator.previous();
                    break;
                }
                rightRow = rightIterator.next();
            }
            if (!match || rightRow == null) continue;
            HashMap<String, Object> newMap = new HashMap<String, Object>(((MapRow)leftRow).getMap());
            for (Map.Entry<String, Object> entry : ((MapRow)rightRow).getMap().entrySet()) {
                String key = entry.getKey();
                if (newMap.containsKey(key)) {
                    key = rightTable + "." + key;
                }
                newMap.put(key, entry.getValue());
            }
            result.add(new MapRow(newMap));
        }
        return result;
    }

    private List<Row> getTable(String name) {
        List<Row> result = this.m_tables.get(name);
        if (result == null) {
            result = new LinkedList<Row>();
        }
        return result;
    }

    static {
        FILE_VERSION_MAP.put(8020, FileFormat8020.class);
        FILE_VERSION_MAP.put(9006, FileFormat9006.class);
        FILE_VERSION_MAP.put(10008, FileFormat10008.class);
        FILE_VERSION_MAP.put(11004, FileFormat11004.class);
        FILE_VERSION_MAP.put(12002, FileFormat12002.class);
        FILE_VERSION_MAP.put(12005, FileFormat12005.class);
        FILE_VERSION_MAP.put(13004, FileFormat13004.class);
    }
}

