/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

final class AstaReader {
    private ProjectFile m_project = new ProjectFile();
    private EventManager m_eventManager = this.m_project.getEventManager();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final Duration ZERO_HOURS = Duration.getInstance(0, TimeUnit.HOURS);
    private static final String LINE_BREAK = "|@|||";
    private static final RowComparator LEAF_COMPARATOR = new RowComparator("NATURAL_ORDER", "NATURAO_ORDER");
    private static final RowComparator BAR_COMPARATOR = new RowComparator("EXPANDED_TASK", "NATURAL_ORDER");
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};

    public AstaReader() {
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoCalendarUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Asta");
        this.m_project.getProjectProperties().setFileType("PP");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(Row row) {
        ProjectProperties ph = this.m_project.getProjectProperties();
        ph.setDuration(row.getDuration("DURATIONHOURS"));
        ph.setStartDate(row.getDate("STARU"));
        ph.setFinishDate(row.getDate("ENE"));
        ph.setName(row.getString("SHORT_NAME"));
        ph.setAuthor(row.getString("PROJECT_BY"));
        ph.setLastSaved(row.getDate("LAST_EDITED_DATE"));
    }

    public void processResources(List<Row> permanentRows, List<Row> consumableRows) {
        Resource resource;
        for (Row row : permanentRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("PERMANENT_RESOURCEID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setMaxUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
        for (Row row : consumableRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("CONSUMABLE_RESOURCEID"));
            resource.setCostPerUse(row.getDouble("COST_PER_USEDEFAULTSAMOUNT"));
            resource.setPeakUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setAvailableFrom(row.getDate("AVAILABLE_FROM"));
            resource.setAvailableTo(row.getDate("AVAILABLE_TO"));
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setMaterialLabel(row.getString("MEASUREMENT"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
    }

    private ProjectCalendar deriveResourceCalendar(Integer parentCalendarID) {
        ProjectCalendar calendar = this.m_project.addDefaultDerivedCalendar();
        calendar.setUniqueID(this.m_project.getProjectConfig().getNextCalendarUniqueID());
        calendar.setParent(this.m_project.getCalendarByUniqueID(parentCalendarID));
        return calendar;
    }

    public void processTasks(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones) {
        List<Row> parentBars = this.buildRowHierarchy(bars, expandedTasks, tasks, milestones);
        this.createTasks(this.m_project, "", parentBars);
        this.deriveProjectCalendar();
        this.updateStructure();
    }

    private List<Row> buildRowHierarchy(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones) {
        Integer expandedTaskID;
        Row bar3;
        ArrayList<Row> leaves = new ArrayList<Row>();
        leaves.addAll(tasks);
        leaves.addAll(milestones);
        Collections.sort(bars, BAR_COMPARATOR);
        Collections.sort(leaves, LEAF_COMPARATOR);
        HashMap<Integer, Row> barIdToBarMap = new HashMap<Integer, Row>();
        for (Row bar2 : bars) {
            barIdToBarMap.put(bar2.getInteger("BARID"), bar2);
        }
        HashMap<Integer, Row> expandedTaskIdToBarMap = new HashMap<Integer, Row>();
        for (Row expandedTask : expandedTasks) {
            bar3 = (Row)barIdToBarMap.get(expandedTask.getInteger("BAR"));
            bar3.merge(expandedTask, "_");
            expandedTaskID = bar3.getInteger("_EXPANDED_TASKID");
            expandedTaskIdToBarMap.put(expandedTaskID, bar3);
        }
        List<Row> parentBars = new ArrayList<Row>();
        for (Row bar3 : bars) {
            expandedTaskID = bar3.getInteger("EXPANDED_TASK");
            Row parentBar = (Row)expandedTaskIdToBarMap.get(expandedTaskID);
            if (parentBar == null) {
                parentBars.add(bar3);
                continue;
            }
            parentBar.addChild(bar3);
        }
        for (Row leaf : leaves) {
            Integer barID = leaf.getInteger("BAR");
            Row bar4 = (Row)barIdToBarMap.get(barID);
            bar4.addChild(leaf);
        }
        Iterator iter = parentBars.iterator();
        while (iter.hasNext()) {
            bar3 = (Row)iter.next();
            String barName = bar3.getString("NAMH");
            if (barName != null && !barName.isEmpty() && !barName.equals("Displaced Items")) continue;
            iter.remove();
        }
        if (parentBars.size() == 1) {
            parentBars = ((Row)parentBars.get(0)).getChildRows();
        }
        return parentBars;
    }

    private void createTasks(ChildTaskContainer parent, String parentName, List<Row> rows) {
        for (Row row : rows) {
            Task task = parent.addTask();
            if (row.getInteger("BARID") != null) {
                if (this.skipBar(row)) {
                    this.populateLeaf(row.getString("NAMH"), row.getChildRows().get(0), task);
                } else {
                    this.populateBar(row, task);
                    this.createTasks(task, task.getName(), row.getChildRows());
                }
            } else {
                this.populateLeaf(parentName, row, task);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private boolean skipBar(Row row) {
        List<Row> childRows = row.getChildRows();
        return childRows.size() == 1 && childRows.get(0).getChildRows().isEmpty();
    }

    private void populateLeaf(String parentName, Row row, Task task) {
        if (row.getInteger("TASKID") != null) {
            this.populateTask(row, task);
        } else {
            this.populateMilestone(row, task);
        }
        String name = task.getName();
        if (name == null || name.isEmpty()) {
            task.setName(parentName);
        }
    }

    private void populateTask(Row row, Task task) {
        task.setUniqueID(row.getInteger("TASKID"));
        task.setDuration(row.getDuration("GIVEN_DURATIONHOURS"));
        task.setResume(row.getDate("RESUME"));
        task.setActualDuration(row.getDuration("ACTUAL_DURATIONHOURS"));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setPercentageComplete(row.getDouble("OVERALL_PERCENV_COMPLETE"));
        task.setName(row.getString("NARE"));
        task.setNotes(this.getNotes(row));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setStart(row.getDate("STARZ"));
        task.setFinish(row.getDate("ENJ"));
        this.processConstraints(row, task);
        if (NumberHelper.getInt(task.getPercentageComplete()) != 0) {
            task.setActualStart(task.getStart());
            if (task.getPercentageComplete().intValue() == 100) {
                task.setActualFinish(task.getFinish());
                task.setDuration(task.getActualDuration());
            }
        }
    }

    private void populateBar(Row row, Task task) {
        Integer calendarID = row.getInteger("CALENDAU");
        ProjectCalendar calendar = this.m_project.getCalendarByUniqueID(calendarID);
        task.setUniqueID(row.getInteger("BARID"));
        task.setStart(row.getDate("STARV"));
        task.setFinish(row.getDate("ENF"));
        task.setName(row.getString("NAMH"));
        task.setCalendar(calendar);
    }

    private void populateMilestone(Row row, Task task) {
        task.setMilestone(true);
        task.setUniqueID(row.getInteger("MILESTONEID"));
        task.setStart(row.getDate("GIVEN_DATE_TIME"));
        task.setFinish(row.getDate("GIVEN_DATE_TIME"));
        task.setPercentageComplete(row.getBoolean("COMPLETED") ? COMPLETE : INCOMPLETE);
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setName(row.getString("NARE"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setDuration(ZERO_HOURS);
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Task startTask = this.m_project.getTaskByUniqueID(row.getInteger("START_TASK"));
            Task endTask = this.m_project.getTaskByUniqueID(row.getInteger("END_TASK"));
            if (startTask == null || endTask == null) continue;
            RelationType type = this.getRelationType(row.getInt("TYPI"));
            Duration startLag = row.getDuration("START_LAG_TIMEHOURS");
            Duration endLag = row.getDuration("END_LAG_TIMEHOURS");
            Duration lag = null;
            if (startLag.getDuration() != 0.0) {
                lag = startLag;
            } else if (endLag.getDuration() != 0.0) {
                lag = endLag;
            }
            endTask.addPredecessor(startTask, type, lag);
        }
    }

    public void processAssignments(List<Row> permanentAssignments) {
        for (Row row : permanentAssignments) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ALLOCATEE_TO"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("PLAYER"));
            if (task == null || resource == null) continue;
            double percentComplete = row.getDouble("PERCENT_COMPLETE");
            Duration work = row.getWork("EFFORW");
            double actualWork = work.getDuration() * percentComplete;
            double remainingWork = work.getDuration() - actualWork;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getInteger("PERMANENT_SCHEDUL_ALLOCATIONID"));
            assignment.setStart(row.getDate("STARZ"));
            assignment.setFinish(row.getDate("ENJ"));
            assignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            assignment.setDelay(row.getDuration("DELAAHOURS"));
            assignment.setPercentageWorkComplete(percentComplete * 100.0);
            assignment.setWork(work);
            assignment.setActualWork(Duration.getInstance(actualWork, work.getUnits()));
            assignment.setRemainingWork(Duration.getInstance(remainingWork, work.getUnits()));
        }
    }

    private RelationType getRelationType(int index) {
        if (index < 0 || index > RELATION_TYPES.length) {
            index = 0;
        }
        return RELATION_TYPES[index];
    }

    private String getInitials(String name) {
        String result = null;
        if (name != null && name.length() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(name.charAt(0));
            int index = 1;
            while ((index = name.indexOf(32, index)) != -1) {
                if (++index < name.length() && name.charAt(index) != ' ') {
                    sb.append(name.charAt(index));
                }
                ++index;
            }
            result = sb.toString();
        }
        return result;
    }

    private void deriveProjectCalendar() {
        HashMap<ProjectCalendar, Integer> map = new HashMap<ProjectCalendar, Integer>();
        for (Task task : this.m_project.getTasks()) {
            ProjectCalendar calendar = task.getCalendar();
            Integer count = (Integer)map.get(calendar);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            map.put(calendar, count);
        }
        int maxCount = 0;
        ProjectCalendar defaultCalendar = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            defaultCalendar = (ProjectCalendar)entry.getKey();
        }
        if (defaultCalendar != null) {
            this.m_project.setDefaultCalendar(defaultCalendar);
            for (Task task : this.m_project.getTasks()) {
                if (task.getCalendar() != defaultCalendar) continue;
                task.setCalendar(null);
            }
        }
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Date constraintDate = null;
        switch (row.getInt("CONSTRAINU")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 0) {
                    constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                    break;
                }
                constraintType = ConstraintType.AS_LATE_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> rows) {
        HashMap<Integer, DayType> map = new HashMap<Integer, DayType>();
        for (Row row : rows) {
            DayType result;
            Integer id = row.getInteger("EXCEPTIONNID");
            switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8: 
                case 32: 
                case 128: {
                    result = DayType.WORKING;
                    break;
                }
                default: {
                    result = DayType.NON_WORKING;
                }
            }
            map.put(id, result);
        }
        return map;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> rows) {
        HashMap<Integer, Row> map = new HashMap<Integer, Row>();
        for (Row row : rows) {
            map.put(row.getInteger("WORK_PATTERNID"), row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(calendarID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(calendarID, list);
            }
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("EXCEPTION_ASSIGNMENTID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(calendarID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(calendarID, list);
            }
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer workPatternID = row.getInteger("TIME_ENTRYID");
            LinkedList<Row> list = (LinkedList<Row>)map.get(workPatternID);
            if (list == null) {
                list = new LinkedList<Row>();
                map.put(workPatternID, list);
            }
            list.add(row);
        }
        return map;
    }

    public void processCalendar(Row calendarRow, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> workPatternAssignmentMap, Map<Integer, List<Row>> exceptionAssignmentMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer dominantWorkPatternID = calendarRow.getInteger("DOMINANT_WORK_PATTERN");
        calendar.setUniqueID(calendarRow.getInteger("CALENDARID"));
        this.processWorkPattern(calendar, dominantWorkPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
        calendar.setName(calendarRow.getString("NAMK"));
        List<Row> rows = workPatternAssignmentMap.get(calendar.getUniqueID());
        if (rows != null) {
            for (Row row : rows) {
                Integer workPatternID = row.getInteger("WORK_PATTERN");
                if (workPatternID.equals(dominantWorkPatternID)) continue;
                ProjectCalendarWeek week = calendar.addWorkWeek();
                week.setDateRange(new DateRange(row.getDate("START_DATE"), row.getDate("END_DATE")));
                this.processWorkPattern(week, workPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
            }
        }
        if ((rows = exceptionAssignmentMap.get(calendar.getUniqueID())) != null) {
            for (Row row : rows) {
                Date startDate = row.getDate("STARU_DATE");
                Date endDate = row.getDate("ENE_DATE");
                calendar.addCalendarException(startDate, endDate);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void processWorkPattern(ProjectCalendarWeek week, Integer workPatternID, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        week.setName(workPatternMap.get(workPatternID).getString("NAMN"));
        List<Row> timeEntryRows = timeEntryMap.get(workPatternID);
        if (timeEntryRows != null) {
            long lastEndTime = Long.MIN_VALUE;
            Day currentDay = Day.SUNDAY;
            ProjectCalendarHours hours = week.addCalendarHours(currentDay);
            Arrays.fill(week.getDays(), DayType.NON_WORKING);
            for (Row row : timeEntryRows) {
                DayType type;
                Date startTime = row.getDate("START_TIME");
                Date endTime = row.getDate("END_TIME");
                if (startTime == null) {
                    startTime = DateHelper.getDayStartDate(new Date(0L));
                }
                if (endTime == null) {
                    endTime = DateHelper.getDayEndDate(new Date(0L));
                }
                if (startTime.getTime() > endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                if (startTime.getTime() < lastEndTime) {
                    currentDay = currentDay.getNextDay();
                    hours = week.addCalendarHours(currentDay);
                }
                if ((type = exceptionTypeMap.get(row.getInteger("EXCEPTIOP"))) == DayType.WORKING) {
                    hours.addRange(new DateRange(startTime, endTime));
                    week.setWorkingDay(currentDay, DayType.WORKING);
                }
                lastEndTime = endTime.getTime();
            }
        }
    }

    private String getNotes(Row row) {
        String notes = row.getString("NOTET");
        if (notes != null) {
            if (notes.isEmpty()) {
                notes = null;
            } else if (notes.indexOf(LINE_BREAK) != -1) {
                notes = notes.replace(LINE_BREAK, "\n");
            }
        }
        return notes;
    }
}

