/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

final class AstaDataType {
    private static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT1 = new ThreadLocal();
    private static final ThreadLocal<DateFormat> DATE_FORMAT2 = new ThreadLocal();
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal();
    private static final long JAVA_EPOCH = -2208988800000L;
    private static final long ASTA_EPOCH = 2415021L;
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = new ThreadLocal();

    AstaDataType() {
    }

    public static String parseString(String value) {
        if (value != null) {
            if (!value.isEmpty() && value.charAt(0) == '<') {
                value = value.substring(1, value.length() - 1);
            }
            if (!value.isEmpty() && value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public static Number parseDouble(String value) throws ParseException {
        Number result = null;
        if ((value = AstaDataType.parseString(value)) != null && !value.isEmpty() && !value.equals("-1 -1")) {
            int index = value.indexOf("E+");
            if (index != -1) {
                value = value.substring(0, index) + 'E' + value.substring(index + 2, value.length());
            }
            if (value.indexOf(69) != -1) {
                DecimalFormat df = DOUBLE_FORMAT.get();
                if (df == null) {
                    df = new DecimalFormat("#.#E0");
                    DOUBLE_FORMAT.set(df);
                }
                result = df.parse(value);
            } else {
                result = Double.valueOf(value);
            }
        }
        return result;
    }

    public static Boolean parseBoolean(String value) throws ParseException {
        Boolean result = null;
        Integer number = AstaDataType.parseInteger(value);
        if (number != null) {
            result = number == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return result;
    }

    public static Integer parseInteger(String value) throws ParseException {
        Integer result = null;
        if (value.length() > 0 && value.indexOf(32) == -1) {
            if (value.indexOf(46) == -1) {
                result = Integer.valueOf(value);
            } else {
                Number n = AstaDataType.parseDouble(value);
                result = n.intValue();
            }
        }
        return result;
    }

    public static Date parseEpochTimestamp(String value) {
        Date result = null;
        if (value.length() > 0 && !value.equals("-1 -1")) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(-2208988800000L);
            int index = value.indexOf(32);
            if (index == -1) {
                if (value.length() < 6) {
                    value = "000000" + value;
                    value = value.substring(value.length() - 6);
                }
                int hours = Integer.parseInt(value.substring(0, 2));
                int minutes = Integer.parseInt(value.substring(2, 4));
                int seconds = Integer.parseInt(value.substring(4));
                cal.set(10, hours);
                cal.set(12, minutes);
                cal.set(13, seconds);
            } else {
                long astaDays = Long.parseLong(value.substring(0, index));
                int astaSeconds = Integer.parseInt(value.substring(index + 1));
                cal.add(6, (int)(astaDays - 2415021L));
                cal.set(14, 0);
                cal.set(13, 0);
                cal.set(10, 0);
                cal.add(13, astaSeconds);
            }
            result = cal.getTime();
        }
        return result;
    }

    public static Date parseBasicTimestamp(String value) throws ParseException {
        Date result = null;
        if (value.length() > 0 && !value.equals("-1 -1") && !value.equals("0")) {
            DateFormat df;
            if (value.endsWith(" 0")) {
                df = DATE_FORMAT1.get();
                if (df == null) {
                    df = new SimpleDateFormat("yyyyMMdd 0");
                    DATE_FORMAT1.set(df);
                }
            } else if (value.indexOf(32) == -1) {
                df = DATE_FORMAT2.get();
                if (df == null) {
                    df = new SimpleDateFormat("yyyyMMdd");
                    DATE_FORMAT2.set(df);
                }
            } else {
                int timeIndex;
                df = TIMESTAMP_FORMAT.get();
                if (df == null) {
                    df = new SimpleDateFormat("yyyyMMdd HHmmss");
                    TIMESTAMP_FORMAT.set(df);
                }
                if ((timeIndex = value.indexOf(32) + 1) + 6 > value.length()) {
                    String time = value.substring(timeIndex);
                    value = value.substring(0, timeIndex) + "0" + time;
                }
            }
            result = df.parse(value);
        }
        return result;
    }

    public static Date parseBasicTime(String value) throws ParseException {
        Date result = null;
        if (value.length() > 0 && !value.equals("0")) {
            DateFormat df = TIME_FORMAT.get();
            if (df == null) {
                df = new SimpleDateFormat("HHmmss");
                TIME_FORMAT.set(df);
            }
            value = "000000" + value;
            value = value.substring(value.length() - 6);
            result = df.parse(value);
        }
        return result;
    }
}

