/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class Resource
extends ProjectEntity
implements Comparable<Resource>,
ProjectEntityWithID,
FieldContainer {
    private Object[] m_array = new Object[ResourceField.MAX_VALUE];
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private boolean m_generic;
    private boolean m_inactive;
    private String m_activeDirectoryGUID;
    private Duration m_actualOvertimeWorkProtected;
    private Duration m_actualWorkProtected;
    private BookingType m_bookingType;
    private boolean m_enterprise;
    private CostRateTable[] m_costRateTables = new CostRateTable[5];
    private AvailabilityTable m_availability = new AvailabilityTable();
    private List<FieldListener> m_listeners;

    Resource(ProjectFile file) {
        super(file);
        this.setType(ResourceType.WORK);
        ProjectConfig config = file.getProjectConfig();
        if (config.getAutoResourceUniqueID()) {
            this.setUniqueID(config.getNextResourceUniqueID());
        }
        if (config.getAutoResourceID()) {
            this.setID(config.getNextResourceID());
        }
    }

    public void setName(String val) {
        this.set((FieldType)ResourceField.NAME, val);
    }

    public String getName() {
        return (String)this.getCachedValue(ResourceField.NAME);
    }

    public void setType(ResourceType type) {
        this.set((FieldType)ResourceField.TYPE, type);
    }

    public ResourceType getType() {
        return (ResourceType)this.getCachedValue(ResourceField.TYPE);
    }

    public void setIsNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String val) {
        this.set((FieldType)ResourceField.INITIALS, val);
    }

    public String getInitials() {
        return (String)this.getCachedValue(ResourceField.INITIALS);
    }

    public void setPhonetics(String phonetics) {
        this.set((FieldType)ResourceField.PHONETICS, phonetics);
    }

    public String getPhonetics() {
        return (String)this.getCachedValue(ResourceField.PHONETICS);
    }

    public void setNtAccount(String ntAccount) {
        this.set((FieldType)ResourceField.WINDOWS_USER_ACCOUNT, ntAccount);
    }

    public String getNtAccount() {
        return (String)this.getCachedValue(ResourceField.WINDOWS_USER_ACCOUNT);
    }

    public void setMaterialLabel(String materialLabel) {
        this.set((FieldType)ResourceField.MATERIAL_LABEL, materialLabel);
    }

    public String getMaterialLabel() {
        return (String)this.getCachedValue(ResourceField.MATERIAL_LABEL);
    }

    public void setCode(String val) {
        this.set((FieldType)ResourceField.CODE, val);
    }

    public String getCode() {
        return (String)this.getCachedValue(ResourceField.CODE);
    }

    public void setGroup(String val) {
        this.set((FieldType)ResourceField.GROUP, val);
    }

    public String getGroup() {
        return (String)this.getCachedValue(ResourceField.GROUP);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.set((FieldType)ResourceField.WORKGROUP, workGroup);
    }

    public WorkGroup getWorkGroup() {
        return (WorkGroup)this.getCachedValue(ResourceField.WORKGROUP);
    }

    public void setEmailAddress(String emailAddress) {
        this.set((FieldType)ResourceField.EMAIL_ADDRESS, emailAddress);
    }

    public String getEmailAddress() {
        return (String)this.getCachedValue(ResourceField.EMAIL_ADDRESS);
    }

    public void setHyperlink(String hyperlink) {
        this.set((FieldType)ResourceField.HYPERLINK, hyperlink);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK);
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_ADDRESS, hyperlinkAddress);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_ADDRESS);
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_SUBADDRESS, hyperlinkSubAddress);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_SUBADDRESS);
    }

    public void setMaxUnits(Number maxUnits) {
        this.set((FieldType)ResourceField.MAX_UNITS, maxUnits);
    }

    public Number getMaxUnits() {
        return (Number)this.getCachedValue(ResourceField.MAX_UNITS);
    }

    public void setPeakUnits(Number peakUnits) {
        this.set((FieldType)ResourceField.PEAK, peakUnits);
    }

    public Number getPeakUnits() {
        return (Number)this.getCachedValue(ResourceField.PEAK);
    }

    public void setOverAllocated(boolean overallocated) {
        this.set((FieldType)ResourceField.OVERALLOCATED, overallocated);
    }

    public boolean getOverAllocated() {
        Boolean overallocated = (Boolean)this.getCachedValue(ResourceField.OVERALLOCATED);
        if (overallocated == null) {
            Number peakUnits = this.getPeakUnits();
            Number maxUnits = this.getMaxUnits();
            overallocated = NumberHelper.getDouble(peakUnits) > NumberHelper.getDouble(maxUnits);
            this.set((FieldType)ResourceField.OVERALLOCATED, overallocated);
        }
        return overallocated;
    }

    public Date getAvailableFrom() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_FROM);
    }

    public void setAvailableFrom(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_FROM, date);
    }

    public Date getAvailableTo() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_TO);
    }

    public void setAvailableTo(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_TO, date);
    }

    public Date getStart() {
        Date result = null;
        for (ResourceAssignment assignment : this.m_assignments) {
            if (result != null && DateHelper.compare(result, assignment.getStart()) <= 0) continue;
            result = assignment.getStart();
        }
        return result;
    }

    public Date getFinish() {
        Date result = null;
        for (ResourceAssignment assignment : this.m_assignments) {
            if (result != null && DateHelper.compare(result, assignment.getFinish()) >= 0) continue;
            result = assignment.getFinish();
        }
        return result;
    }

    public void setCanLevel(boolean canLevel) {
        this.set((FieldType)ResourceField.CAN_LEVEL, canLevel);
    }

    public boolean getCanLevel() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.CAN_LEVEL));
    }

    public void setAccrueAt(AccrueType type) {
        this.set((FieldType)ResourceField.ACCRUE_AT, type);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.getCachedValue(ResourceField.ACCRUE_AT);
    }

    public void setWork(Duration val) {
        this.set((FieldType)ResourceField.WORK, val);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(ResourceField.WORK);
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(ResourceField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)ResourceField.REGULAR_WORK, duration);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)ResourceField.ACTUAL_WORK, val);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_WORK);
    }

    public void setOvertimeWork(Duration overtimeWork) {
        this.set((FieldType)ResourceField.OVERTIME_WORK, overtimeWork);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.OVERTIME_WORK);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)ResourceField.REMAINING_WORK, val);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_WORK);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_WORK, duration);
    }

    public void setPercentWorkComplete(Number percentWorkComplete) {
        this.set((FieldType)ResourceField.PERCENT_WORK_COMPLETE, percentWorkComplete);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.getCachedValue(ResourceField.PERCENT_WORK_COMPLETE);
    }

    public void setStandardRate(Rate val) {
        this.set((FieldType)ResourceField.STANDARD_RATE, val);
    }

    public Rate getStandardRate() {
        return (Rate)this.getCachedValue(ResourceField.STANDARD_RATE);
    }

    public void setStandardRateUnits(TimeUnit units) {
        this.set((FieldType)ResourceField.STANDARD_RATE_UNITS, units);
    }

    public TimeUnit getStandardRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.STANDARD_RATE_UNITS);
    }

    public void setCost(Number cost) {
        this.set((FieldType)ResourceField.COST, cost);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(ResourceField.COST);
    }

    public void setOvertimeRate(Rate overtimeRate) {
        this.set((FieldType)ResourceField.OVERTIME_RATE, overtimeRate);
    }

    public Rate getOvertimeRate() {
        return (Rate)this.getCachedValue(ResourceField.OVERTIME_RATE);
    }

    public void setOvertimeRateUnits(TimeUnit units) {
        this.set((FieldType)ResourceField.OVERTIME_RATE_UNITS, units);
    }

    public TimeUnit getOvertimeRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.OVERTIME_RATE_UNITS);
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number currency) {
        this.set((FieldType)ResourceField.OVERTIME_COST, currency);
    }

    public void setCostPerUse(Number costPerUse) {
        this.set((FieldType)ResourceField.COST_PER_USE, costPerUse);
    }

    public Number getCostPerUse() {
        return (Number)this.getCachedValue(ResourceField.COST_PER_USE);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)ResourceField.ACTUAL_COST, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_COST);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number actualOvertimeCost) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_COST, actualOvertimeCost);
    }

    public void setRemainingCost(Number remainingCost) {
        this.set((FieldType)ResourceField.REMAINING_COST, remainingCost);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_COST);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number remainingOvertimeCost) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_COST, remainingOvertimeCost);
    }

    public void setWorkVariance(Duration workVariance) {
        this.set((FieldType)ResourceField.WORK_VARIANCE, workVariance);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(ResourceField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
                this.set((FieldType)ResourceField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setCostVariance(Number costVariance) {
        this.set((FieldType)ResourceField.COST_VARIANCE, costVariance);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(ResourceField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)ResourceField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public void setSV(Number sv) {
        this.set((FieldType)ResourceField.SV, sv);
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(ResourceField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)ResourceField.SV, variance);
            }
        }
        return variance;
    }

    public void setCV(Number cv) {
        this.set((FieldType)ResourceField.CV, cv);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(ResourceField.CV);
        if (variance == null) {
            variance = NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
            this.set((FieldType)ResourceField.CV, variance);
        }
        return variance;
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)ResourceField.ACWP, acwp);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(ResourceField.ACWP);
    }

    public void setNotes(String notes) {
        this.set((FieldType)ResourceField.NOTES, notes);
    }

    public String getNotes() {
        String notes = (String)this.getCachedValue(ResourceField.NOTES);
        return notes == null ? "" : notes;
    }

    public void setBCWS(Number bcws) {
        this.set((FieldType)ResourceField.BCWS, bcws);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(ResourceField.BCWS);
    }

    public void setBCWP(Number bcwp) {
        this.set((FieldType)ResourceField.BCWP, bcwp);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(ResourceField.BCWP);
    }

    public void setIsGeneric(boolean isGeneric) {
        this.m_generic = isGeneric;
    }

    public boolean getGeneric() {
        return this.m_generic;
    }

    public void setIsInactive(boolean isInactive) {
        this.m_inactive = isInactive;
    }

    public boolean getInactive() {
        return this.m_inactive;
    }

    public void setActveDirectoryGUID(String guid) {
        this.m_activeDirectoryGUID = guid;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualWorkProtected(Duration duration) {
        this.m_actualWorkProtected = duration;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setBookingType(BookingType bookingType) {
        this.m_bookingType = bookingType;
    }

    public BookingType getBookingType() {
        return this.m_bookingType;
    }

    public void setCreationDate(Date creationDate) {
        this.set((FieldType)ResourceField.CREATED, creationDate);
    }

    public Date getCreationDate() {
        return (Date)this.getCachedValue(ResourceField.CREATED);
    }

    public void setIsEnterprise(boolean enterprise) {
        this.m_enterprise = enterprise;
    }

    public boolean getEnterprise() {
        return this.m_enterprise;
    }

    public ProjectCalendar getResourceCalendar() {
        return (ProjectCalendar)this.getCachedValue(ResourceField.CALENDAR);
    }

    public void setResourceCalendar(ProjectCalendar calendar) {
        this.set((FieldType)ResourceField.CALENDAR, calendar);
        if (calendar == null) {
            this.setResourceCalendarUniqueID(null);
        } else {
            calendar.setResource(this);
            this.setResourceCalendarUniqueID(calendar.getUniqueID());
        }
    }

    public void setResourceCalendarUniqueID(Integer id) {
        this.set((FieldType)ResourceField.CALENDAR_UNIQUE_ID, id);
    }

    public Integer getResourceCalendarUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.CALENDAR_UNIQUE_ID);
    }

    public ProjectCalendar addResourceCalendar() throws MPXJException {
        if (this.getResourceCalendar() != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        ProjectCalendar calendar = new ProjectCalendar(this.getParentFile());
        this.setResourceCalendar(calendar);
        return calendar;
    }

    public void setBaseCalendar(String val) {
        this.set((FieldType)ResourceField.BASE_CALENDAR, val == null || val.length() == 0 ? "Standard" : val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)ResourceField.BASELINE_COST, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)ResourceField.BASELINE_WORK, val);
    }

    @Override
    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.getResources().unmapID(previous);
        }
        parent.getResources().mapID(val, this);
        this.set((FieldType)ResourceField.ID, val);
    }

    public void setLinkedFields(boolean val) {
        this.set((FieldType)ResourceField.LINKED_FIELDS, val);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)ResourceField.OBJECTS, val);
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_TEXT, index));
    }

    @Override
    public void setUniqueID(Integer val) {
        this.set((FieldType)ResourceField.UNIQUE_ID, val);
    }

    public void setParentID(Integer val) {
        this.set((FieldType)ResourceField.PARENT_ID, val);
    }

    public String getBaseCalendar() {
        return (String)this.getCachedValue(ResourceField.BASE_CALENDAR);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(ResourceField.BASELINE_COST);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(ResourceField.BASELINE_WORK);
    }

    @Override
    public Integer getID() {
        return (Integer)this.getCachedValue(ResourceField.ID);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.LINKED_FIELDS));
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(ResourceField.OBJECTS);
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.UNIQUE_ID);
    }

    public Integer getParentID() {
        return (Integer)this.getCachedValue(ResourceField.PARENT_ID);
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_START, index));
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_FINISH, index));
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index));
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_DURATION, index));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_DATE, index));
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_COST, index));
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_FLAG, index)));
    }

    public void setOutlineCode1(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE1, value);
    }

    public String getOutlineCode1() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE1);
    }

    public void setOutlineCode2(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE2, value);
    }

    public String getOutlineCode2() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE2);
    }

    public void setOutlineCode3(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE3, value);
    }

    public String getOutlineCode3() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE3);
    }

    public void setOutlineCode4(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE4, value);
    }

    public String getOutlineCode4() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE4);
    }

    public void setOutlineCode5(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE5, value);
    }

    public String getOutlineCode5() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE5);
    }

    public void setOutlineCode6(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE6, value);
    }

    public String getOutlineCode6() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE6);
    }

    public void setOutlineCode7(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE7, value);
    }

    public String getOutlineCode7() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE7);
    }

    public void setOutlineCode8(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE8, value);
    }

    public String getOutlineCode8() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE8);
    }

    public void setOutlineCode9(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE9, value);
    }

    public String getOutlineCode9() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE9);
    }

    public void setOutlineCode10(String value) {
        this.set((FieldType)ResourceField.OUTLINE_CODE10, value);
    }

    public String getOutlineCode10() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE10);
    }

    public void remove() {
        this.getParentFile().removeResource(this);
    }

    public Object getFieldByAlias(String alias) {
        return this.getCachedValue(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.RESOURCE, alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.RESOURCE, alias), value);
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.add(assignment);
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public List<ResourceAssignment> getTaskAssignments() {
        return this.m_assignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID);
    }

    public void setSubprojectResourceUniqueID(Integer subprojectUniqueResourceID) {
        this.set((FieldType)ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, subprojectUniqueResourceID);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_COST, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, index), value);
    }

    public String getEnterpriseCustomField(int index) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public boolean getBudget() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.BUDGET));
    }

    public void setBudget(boolean budget) {
        this.set((FieldType)ResourceField.BUDGET, budget);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(ResourceField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)ResourceField.GUID, value);
    }

    public void setCostRateTable(int index, CostRateTable crt) {
        this.m_costRateTables[index] = crt;
    }

    public CostRateTable getCostRateTable(int index) {
        return this.m_costRateTables[index];
    }

    public AvailabilityTable getAvailability() {
        return this.m_availability;
    }

    private ResourceField selectField(ResourceField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            ResourceField resourceField = (ResourceField)field;
            switch (resourceField) {
                case COST_VARIANCE: {
                    result = this.getCostVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    result = this.getWorkVariance();
                    break;
                }
                case CV: {
                    result = this.getCV();
                    break;
                }
                case SV: {
                    result = this.getSV();
                    break;
                }
                case OVERALLOCATED: {
                    result = this.getOverAllocated();
                    break;
                }
                default: {
                    result = this.m_array[field.getValue()];
                }
            }
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((ResourceField)field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void fireFieldChangeEvent(ResourceField field, Object oldValue, Object newValue) {
        switch (field) {
            case UNIQUE_ID: {
                ProjectFile parent = this.getParentFile();
                if (oldValue != null) {
                    parent.getResources().unmapUniqueID((Integer)oldValue);
                }
                parent.getResources().mapUniqueID((Integer)newValue, this);
                if (this.m_assignments.isEmpty()) break;
                for (ResourceAssignment assignment : this.m_assignments) {
                    assignment.setResourceUniqueID((Integer)newValue);
                }
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[ResourceField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[ResourceField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[ResourceField.CV.getValue()] = null;
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case PEAK: 
            case MAX_UNITS: {
                this.m_array[ResourceField.OVERALLOCATED.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }

    @Override
    public int compareTo(Resource o) {
        int id2;
        int id1 = NumberHelper.getInt(this.getID());
        return id1 < (id2 = NumberHelper.getInt(o.getID())) ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Resource) {
            result = this.compareTo((Resource)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return NumberHelper.getInt(this.getID());
    }

    public String toString() {
        return "[Resource id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + "]";
    }
}

