/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;

public final class Rate {
    private double m_amount;
    private TimeUnit m_units;

    public Rate(Number amount, TimeUnit time) {
        this.m_amount = amount == null ? 0.0 : amount.doubleValue();
        this.m_units = time;
    }

    public Rate(double amount, TimeUnit time) {
        this.m_amount = amount;
        this.m_units = time;
    }

    public double getAmount() {
        return this.m_amount;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Rate) {
            Rate rhs = (Rate)obj;
            result = this.amountComponentEquals(rhs) && this.m_units == rhs.m_units;
        }
        return result;
    }

    public boolean amountComponentEquals(Rate rhs) {
        return NumberHelper.equals(this.m_amount, rhs.m_amount, 1.0E-5);
    }

    public int hashCode() {
        return (int)this.m_amount + this.m_units.hashCode();
    }

    public String toString() {
        return this.m_amount + this.m_units.toString();
    }
}

