/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileVersion;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ProjectFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class ProjectProperties
extends ProjectEntity
implements FieldContainer {
    private Object[] m_array = new Object[ProjectField.MAX_VALUE];
    private List<FieldListener> m_listeners;
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final char DEFAULT_DATE_SEPARATOR = '/';
    private static final char DEFAULT_THOUSANDS_SEPARATOR = ',';
    private static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    private static final String DEFAULT_CURRENCY_SYMBOL = "$";
    private static final Double DEFAULT_COST = 0.0;
    private static final char DEFAULT_MPX_DELIMITER = ',';
    private static final Integer DEFAULT_CRITICAL_SLACK_LIMIT = 0;
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = 0;
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = 1;
    private static final Day DEFAULT_WEEK_START_DAY = Day.MONDAY;
    private static final Duration DEFAULT_WORK = Duration.getInstance(0, TimeUnit.HOURS);
    private static final Double DEFAULT_WORK2 = 0.0;
    private static final Duration DEFAULT_DURATION = Duration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Double DEFAULT_PERCENT_COMPLETE = 0.0;
    private static final String DEFAULT_CALENDAR_NAME = "Standard";
    private static final Integer DEFAULT_MINUTES_PER_DAY = 480;
    private static final Integer DEFAULT_DAYS_PER_MONTH = 20;
    private static final Integer DEFAULT_MINUTES_PER_WEEK = 2400;

    ProjectProperties(ProjectFile file) {
        super(file);
        this.setMpxDelimiter(',');
        this.setMpxProgramName("Microsoft Project for Windows");
        this.setMpxFileVersion(FileVersion.VERSION_4_0);
        this.setMpxCodePage(CodePage.ANSI);
        this.setCurrencySymbol(DEFAULT_CURRENCY_SYMBOL);
        this.setSymbolPosition(CurrencySymbolPosition.BEFORE);
        this.setCurrencyDigits(2);
        this.setThousandsSeparator(',');
        this.setDecimalSeparator('.');
        this.setDateOrder(DateOrder.DMY);
        this.setTimeFormat(ProjectTimeFormat.TWELVE_HOUR);
        this.setDefaultStartTime(DateHelper.getTimeFromMinutesPastMidnight(480));
        this.setDateSeparator('/');
        this.setTimeSeparator(':');
        this.setAMText("am");
        this.setPMText("pm");
        this.setDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setBarTextDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setMinutesPerDay(480);
        this.setMinutesPerWeek(2400);
        this.setDefaultStandardRate(new Rate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new Rate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setDefaultCalendarName(DEFAULT_CALENDAR_NAME);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(new Date());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
    }

    public TimeUnit getDefaultDurationUnits() {
        return (TimeUnit)this.getCachedValue(ProjectField.DEFAULT_DURATION_UNITS);
    }

    public void setDefaultDurationUnits(TimeUnit units) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_UNITS, units);
    }

    public boolean getDefaultDurationIsFixed() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.DEFAULT_DURATION_IS_FIXED));
    }

    public void setDefaultDurationIsFixed(boolean fixed) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_IS_FIXED, fixed);
    }

    public TimeUnit getDefaultWorkUnits() {
        return (TimeUnit)this.getCachedValue(ProjectField.DEFAULT_WORK_UNITS);
    }

    public void setDefaultWorkUnits(TimeUnit units) {
        this.set((FieldType)ProjectField.DEFAULT_WORK_UNITS, units);
    }

    public Rate getDefaultStandardRate() {
        return (Rate)this.getCachedValue(ProjectField.DEFAULT_STANDARD_RATE);
    }

    public void setDefaultStandardRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_STANDARD_RATE, rate);
    }

    public Rate getDefaultOvertimeRate() {
        return (Rate)this.getCachedValue(ProjectField.DEFAULT_OVERTIME_RATE);
    }

    public void setDefaultOvertimeRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_OVERTIME_RATE, rate);
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS));
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean flag) {
        this.set((FieldType)ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS, flag);
    }

    public boolean getSplitInProgressTasks() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPLIT_IN_PROGRESS_TASKS));
    }

    public void setSplitInProgressTasks(boolean flag) {
        this.set((FieldType)ProjectField.SPLIT_IN_PROGRESS_TASKS, flag);
    }

    public DateOrder getDateOrder() {
        return (DateOrder)this.getCachedValue(ProjectField.DATE_ORDER);
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.set((FieldType)ProjectField.DATE_ORDER, dateOrder);
    }

    public ProjectTimeFormat getTimeFormat() {
        return (ProjectTimeFormat)this.getCachedValue(ProjectField.TIME_FORMAT);
    }

    public void setTimeFormat(ProjectTimeFormat timeFormat) {
        this.set((FieldType)ProjectField.TIME_FORMAT, timeFormat);
    }

    public Date getDefaultStartTime() {
        return (Date)this.getCachedValue(ProjectField.DEFAULT_START_TIME);
    }

    public void setDefaultStartTime(Date defaultStartTime) {
        this.set((FieldType)ProjectField.DEFAULT_START_TIME, defaultStartTime);
    }

    public char getDateSeparator() {
        return this.getCachedCharValue(ProjectField.DATE_SEPARATOR, '/');
    }

    public void setDateSeparator(char dateSeparator) {
        this.set((FieldType)ProjectField.DATE_SEPARATOR, Character.valueOf(dateSeparator));
    }

    public char getTimeSeparator() {
        return this.getCachedCharValue(ProjectField.TIME_SEPARATOR, ':');
    }

    public void setTimeSeparator(char timeSeparator) {
        this.set((FieldType)ProjectField.TIME_SEPARATOR, Character.valueOf(timeSeparator));
    }

    public String getAMText() {
        return (String)this.getCachedValue(ProjectField.AM_TEXT);
    }

    public void setAMText(String amText) {
        this.set((FieldType)ProjectField.AM_TEXT, amText);
    }

    public String getPMText() {
        return (String)this.getCachedValue(ProjectField.PM_TEXT);
    }

    public void setPMText(String pmText) {
        this.set((FieldType)ProjectField.PM_TEXT, pmText);
    }

    public ProjectDateFormat getDateFormat() {
        return (ProjectDateFormat)this.getCachedValue(ProjectField.DATE_FORMAT);
    }

    public void setDateFormat(ProjectDateFormat dateFormat) {
        this.set((FieldType)ProjectField.DATE_FORMAT, dateFormat);
    }

    public ProjectDateFormat getBarTextDateFormat() {
        return (ProjectDateFormat)this.getCachedValue(ProjectField.BAR_TEXT_DATE_FORMAT);
    }

    public void setBarTextDateFormat(ProjectDateFormat dateFormat) {
        this.set((FieldType)ProjectField.BAR_TEXT_DATE_FORMAT, dateFormat);
    }

    public Date getDefaultEndTime() {
        return (Date)this.getCachedValue(ProjectField.DEFAULT_END_TIME);
    }

    public void setDefaultEndTime(Date date) {
        this.set((FieldType)ProjectField.DEFAULT_END_TIME, date);
    }

    public void setProjectTitle(String projectTitle) {
        this.set((FieldType)ProjectField.PROJECT_TITLE, projectTitle);
    }

    public String getProjectTitle() {
        return (String)this.getCachedValue(ProjectField.PROJECT_TITLE);
    }

    public void setCompany(String company) {
        this.set((FieldType)ProjectField.COMPANY, company);
    }

    public String getCompany() {
        return (String)this.getCachedValue(ProjectField.COMPANY);
    }

    public void setManager(String manager) {
        this.set((FieldType)ProjectField.MANAGER, manager);
    }

    public String getManager() {
        return (String)this.getCachedValue(ProjectField.MANAGER);
    }

    public void setDefaultCalendarName(String calendarName) {
        if (calendarName == null || calendarName.length() == 0) {
            calendarName = DEFAULT_CALENDAR_NAME;
        }
        this.set((FieldType)ProjectField.DEFAULT_CALENDAR_NAME, calendarName);
    }

    public String getDefaultCalendarName() {
        return (String)this.getCachedValue(ProjectField.DEFAULT_CALENDAR_NAME);
    }

    public void setStartDate(Date startDate) {
        this.set((FieldType)ProjectField.START_DATE, startDate);
    }

    public Date getStartDate() {
        Date result = (Date)this.getCachedValue(ProjectField.START_DATE);
        if (result == null) {
            result = this.getParentFile().getStartDate();
        }
        return result;
    }

    public Date getFinishDate() {
        Date result = (Date)this.getCachedValue(ProjectField.FINISH_DATE);
        if (result == null) {
            result = this.getParentFile().getFinishDate();
        }
        return result;
    }

    public void setFinishDate(Date finishDate) {
        this.set((FieldType)ProjectField.FINISH_DATE, finishDate);
    }

    public ScheduleFrom getScheduleFrom() {
        return (ScheduleFrom)this.getCachedValue(ProjectField.SCHEDULE_FROM);
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.set((FieldType)ProjectField.SCHEDULE_FROM, scheduleFrom);
    }

    public Date getCurrentDate() {
        return (Date)this.getCachedValue(ProjectField.CURRENT_DATE);
    }

    public void setCurrentDate(Date currentDate) {
        this.set((FieldType)ProjectField.CURRENT_DATE, currentDate);
    }

    public String getComments() {
        return (String)this.getCachedValue(ProjectField.COMMENTS);
    }

    public void setComments(String comments) {
        this.set((FieldType)ProjectField.COMMENTS, comments);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(ProjectField.COST);
    }

    public void setCost(Number cost) {
        this.set((FieldType)ProjectField.COST, cost);
    }

    public void setBaselineCost(Number baselineCost) {
        this.set((FieldType)ProjectField.BASELINE_COST, baselineCost);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(ProjectField.BASELINE_COST);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)ProjectField.ACTUAL_COST, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(ProjectField.ACTUAL_COST);
    }

    public void setWork(Duration work) {
        this.set((FieldType)ProjectField.WORK, work);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(ProjectField.WORK);
    }

    public void setBaselineWork(Duration baselineWork) {
        this.set((FieldType)ProjectField.BASELINE_WORK, baselineWork);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(ProjectField.BASELINE_WORK);
    }

    public void setActualWork(Duration actualWork) {
        this.set((FieldType)ProjectField.ACTUAL_WORK, actualWork);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(ProjectField.ACTUAL_WORK);
    }

    public Number getWork2() {
        return (Number)this.getCachedValue(ProjectField.WORK2);
    }

    public void setWork2(Number work2) {
        this.set((FieldType)ProjectField.WORK2, work2);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(ProjectField.DURATION);
    }

    public void setDuration(Duration duration) {
        this.set((FieldType)ProjectField.DURATION, duration);
    }

    public Duration getBaselineDuration() {
        return (Duration)this.getCachedValue(ProjectField.BASELINE_DURATION);
    }

    public void setBaselineDuration(Duration baselineDuration) {
        this.set((FieldType)ProjectField.BASELINE_DURATION, baselineDuration);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(ProjectField.ACTUAL_DURATION);
    }

    public void setActualDuration(Duration actualDuration) {
        this.set((FieldType)ProjectField.ACTUAL_DURATION, actualDuration);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(ProjectField.PERCENTAGE_COMPLETE);
    }

    public void setPercentageComplete(Number percentComplete) {
        this.set((FieldType)ProjectField.PERCENTAGE_COMPLETE, percentComplete);
    }

    public void setBaselineStart(Date baselineStartDate) {
        this.set((FieldType)ProjectField.BASELINE_START, baselineStartDate);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_START);
    }

    public void setBaselineFinish(Date baselineFinishDate) {
        this.set((FieldType)ProjectField.BASELINE_FINISH, baselineFinishDate);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_FINISH);
    }

    public void setActualStart(Date actualStartDate) {
        this.set((FieldType)ProjectField.ACTUAL_START, actualStartDate);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(ProjectField.ACTUAL_START);
    }

    public void setActualFinish(Date actualFinishDate) {
        this.set((FieldType)ProjectField.ACTUAL_FINISH, actualFinishDate);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(ProjectField.ACTUAL_FINISH);
    }

    public Duration getStartVariance() {
        return (Duration)this.getCachedValue(ProjectField.START_VARIANCE);
    }

    public void setStartVariance(Duration startVariance) {
        this.set((FieldType)ProjectField.START_VARIANCE, startVariance);
    }

    public Duration getFinishVariance() {
        return (Duration)this.getCachedValue(ProjectField.FINISH_VARIANCE);
    }

    public void setFinishVariance(Duration finishVariance) {
        this.set((FieldType)ProjectField.FINISH_VARIANCE, finishVariance);
    }

    public String getSubject() {
        return (String)this.getCachedValue(ProjectField.SUBJECT);
    }

    public void setSubject(String subject) {
        this.set((FieldType)ProjectField.SUBJECT, subject);
    }

    public String getAuthor() {
        return (String)this.getCachedValue(ProjectField.AUTHOR);
    }

    public void setAuthor(String author) {
        this.set((FieldType)ProjectField.AUTHOR, author);
    }

    public String getKeywords() {
        return (String)this.getCachedValue(ProjectField.KEYWORDS);
    }

    public void setKeywords(String keywords) {
        this.set((FieldType)ProjectField.KEYWORDS, keywords);
    }

    public void setCurrencySymbol(String symbol) {
        if (symbol == null) {
            symbol = DEFAULT_CURRENCY_SYMBOL;
        }
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL, symbol);
    }

    public String getCurrencySymbol() {
        return (String)this.getCachedValue(ProjectField.CURRENCY_SYMBOL);
    }

    public void setSymbolPosition(CurrencySymbolPosition posn) {
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL_POSITION, posn);
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return (CurrencySymbolPosition)this.getCachedValue(ProjectField.CURRENCY_SYMBOL_POSITION);
    }

    public void setCurrencyDigits(Integer currDigs) {
        this.set((FieldType)ProjectField.CURRENCY_DIGITS, currDigs);
    }

    public Integer getCurrencyDigits() {
        return (Integer)this.getCachedValue(ProjectField.CURRENCY_DIGITS);
    }

    public void setThousandsSeparator(char sep) {
        this.set((FieldType)ProjectField.THOUSANDS_SEPARATOR, Character.valueOf(sep));
    }

    public char getThousandsSeparator() {
        return this.getCachedCharValue(ProjectField.THOUSANDS_SEPARATOR, ',');
    }

    public void setDecimalSeparator(char decSep) {
        this.set((FieldType)ProjectField.DECIMAL_SEPARATOR, Character.valueOf(decSep));
    }

    public char getDecimalSeparator() {
        return this.getCachedCharValue(ProjectField.DECIMAL_SEPARATOR, '.');
    }

    public boolean getProjectExternallyEdited() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.PROJECT_EXTERNALLY_EDITED));
    }

    public void setProjectExternallyEdited(boolean projectExternallyEdited) {
        this.set((FieldType)ProjectField.PROJECT_EXTERNALLY_EDITED, projectExternallyEdited);
    }

    public String getCategory() {
        return (String)this.getCachedValue(ProjectField.CATEGORY);
    }

    public void setCategory(String category) {
        this.set((FieldType)ProjectField.CATEGORY, category);
    }

    public Number getDaysPerMonth() {
        return (Number)this.getCachedValue(ProjectField.DAYS_PER_MONTH);
    }

    public void setDaysPerMonth(Number daysPerMonth) {
        if (daysPerMonth != null) {
            this.set((FieldType)ProjectField.DAYS_PER_MONTH, daysPerMonth);
        }
    }

    public Number getMinutesPerDay() {
        return (Number)this.getCachedValue(ProjectField.MINUTES_PER_DAY);
    }

    public void setMinutesPerDay(Number minutesPerDay) {
        if (minutesPerDay != null) {
            this.set((FieldType)ProjectField.MINUTES_PER_DAY, minutesPerDay);
        }
    }

    public Number getMinutesPerWeek() {
        return (Number)this.getCachedValue(ProjectField.MINUTES_PER_WEEK);
    }

    public void setMinutesPerWeek(Number minutesPerWeek) {
        if (minutesPerWeek != null) {
            this.set((FieldType)ProjectField.MINUTES_PER_WEEK, minutesPerWeek);
        }
    }

    public Number getMinutesPerMonth() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth());
    }

    public Number getMinutesPerYear() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth()) * 12;
    }

    public boolean getFiscalYearStart() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.FISCAL_YEAR_START));
    }

    public void setFiscalYearStart(boolean fiscalYearStart) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START, fiscalYearStart);
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD);
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod defaultTaskEarnedValueMethod) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD, defaultTaskEarnedValueMethod);
    }

    public boolean getRemoveFileProperties() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.REMOVE_FILE_PROPERTIES));
    }

    public void setRemoveFileProperties(boolean removeFileProperties) {
        this.set((FieldType)ProjectField.REMOVE_FILE_PROPERTIES, removeFileProperties);
    }

    public boolean getMoveCompletedEndsBack() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_COMPLETED_ENDS_BACK));
    }

    public void setMoveCompletedEndsBack(boolean moveCompletedEndsBack) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_BACK, moveCompletedEndsBack);
    }

    public boolean getNewTasksEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASKS_ESTIMATED));
    }

    public void setNewTasksEstimated(boolean newTasksEstimated) {
        this.set((FieldType)ProjectField.NEW_TASKS_ESTIMATED, newTasksEstimated);
    }

    public boolean getSpreadActualCost() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPREAD_ACTUAL_COST));
    }

    public void setSpreadActualCost(boolean spreadActualCost) {
        this.set((FieldType)ProjectField.SPREAD_ACTUAL_COST, spreadActualCost);
    }

    public boolean getMultipleCriticalPaths() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MULTIPLE_CRITICAL_PATHS));
    }

    public void setMultipleCriticalPaths(boolean multipleCriticalPaths) {
        this.set((FieldType)ProjectField.MULTIPLE_CRITICAL_PATHS, multipleCriticalPaths);
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS));
    }

    public void setAutoAddNewResourcesAndTasks(boolean autoAddNewResourcesAndTasks) {
        this.set((FieldType)ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS, autoAddNewResourcesAndTasks);
    }

    public Date getLastSaved() {
        return (Date)this.getCachedValue(ProjectField.LAST_SAVED);
    }

    public void setLastSaved(Date lastSaved) {
        this.set((FieldType)ProjectField.LAST_SAVED, lastSaved);
    }

    public Date getStatusDate() {
        return (Date)this.getCachedValue(ProjectField.STATUS_DATE);
    }

    public void setStatusDate(Date statusDate) {
        this.set((FieldType)ProjectField.STATUS_DATE, statusDate);
    }

    public boolean getMoveRemainingStartsBack() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_REMAINING_STARTS_BACK));
    }

    public void setMoveRemainingStartsBack(boolean moveRemainingStartsBack) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_BACK, moveRemainingStartsBack);
    }

    public boolean getAutolink() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTO_LINK));
    }

    public void setAutolink(boolean autolink) {
        this.set((FieldType)ProjectField.AUTO_LINK, autolink);
    }

    public boolean getMicrosoftProjectServerURL() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MICROSOFT_PROJECT_SERVER_URL));
    }

    public void setMicrosoftProjectServerURL(boolean microsoftProjectServerURL) {
        this.set((FieldType)ProjectField.MICROSOFT_PROJECT_SERVER_URL, microsoftProjectServerURL);
    }

    public boolean getHonorConstraints() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.HONOR_CONSTRAINTS));
    }

    public void setHonorConstraints(boolean honorConstraints) {
        this.set((FieldType)ProjectField.HONOR_CONSTRAINTS, honorConstraints);
    }

    public boolean getAdminProject() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.ADMIN_PROJECT));
    }

    public void setAdminProject(boolean adminProject) {
        this.set((FieldType)ProjectField.ADMIN_PROJECT, adminProject);
    }

    public boolean getInsertedProjectsLikeSummary() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY));
    }

    public void setInsertedProjectsLikeSummary(boolean insertedProjectsLikeSummary) {
        this.set((FieldType)ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY, insertedProjectsLikeSummary);
    }

    public String getName() {
        return (String)this.getCachedValue(ProjectField.NAME);
    }

    public void setName(String name) {
        this.set((FieldType)ProjectField.NAME, name);
    }

    public boolean getSpreadPercentComplete() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPREAD_PERCENT_COMPLETE));
    }

    public void setSpreadPercentComplete(boolean spreadPercentComplete) {
        this.set((FieldType)ProjectField.SPREAD_PERCENT_COMPLETE, spreadPercentComplete);
    }

    public boolean getMoveCompletedEndsForward() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_COMPLETED_ENDS_FORWARD));
    }

    public void setMoveCompletedEndsForward(boolean moveCompletedEndsForward) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_FORWARD, moveCompletedEndsForward);
    }

    public boolean getEditableActualCosts() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.EDITABLE_ACTUAL_COSTS));
    }

    public void setEditableActualCosts(boolean editableActualCosts) {
        this.set((FieldType)ProjectField.EDITABLE_ACTUAL_COSTS, editableActualCosts);
    }

    public String getUniqueID() {
        return (String)this.getCachedValue(ProjectField.UNIQUE_ID);
    }

    public void setUniqueID(String uniqueID) {
        this.set((FieldType)ProjectField.UNIQUE_ID, uniqueID);
    }

    public Integer getRevision() {
        return (Integer)this.getCachedValue(ProjectField.REVISION);
    }

    public boolean getNewTasksEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASKS_EFFORT_DRIVEN));
    }

    public void setNewTasksEffortDriven(boolean newTasksEffortDriven) {
        this.set((FieldType)ProjectField.NEW_TASKS_EFFORT_DRIVEN, newTasksEffortDriven);
    }

    public void setRevision(Integer revision) {
        this.set((FieldType)ProjectField.REVISION, revision);
    }

    public boolean getMoveRemainingStartsForward() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_REMAINING_STARTS_FORWARD));
    }

    public void setMoveRemainingStartsForward(boolean moveRemainingStartsForward) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_FORWARD, moveRemainingStartsForward);
    }

    public boolean getActualsInSync() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.ACTUALS_IN_SYNC));
    }

    public void setActualsInSync(boolean actualsInSync) {
        this.set((FieldType)ProjectField.ACTUALS_IN_SYNC, actualsInSync);
    }

    public TaskType getDefaultTaskType() {
        return (TaskType)this.getCachedValue(ProjectField.DEFAULT_TASK_TYPE);
    }

    public void setDefaultTaskType(TaskType defaultTaskType) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_TYPE, defaultTaskType);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(ProjectField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)ProjectField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public Date getCreationDate() {
        return (Date)this.getCachedValue(ProjectField.CREATION_DATE);
    }

    public void setCreationDate(Date creationDate) {
        this.set((FieldType)ProjectField.CREATION_DATE, creationDate);
    }

    public Date getExtendedCreationDate() {
        return (Date)this.getCachedValue(ProjectField.EXTENDED_CREATION_DATE);
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(ProjectField.DEFAULT_FIXED_COST_ACCRUAL);
    }

    public void setDefaultFixedCostAccrual(AccrueType defaultFixedCostAccrual) {
        this.set((FieldType)ProjectField.DEFAULT_FIXED_COST_ACCRUAL, defaultFixedCostAccrual);
    }

    public void setExtendedCreationDate(Date creationDate) {
        this.set((FieldType)ProjectField.EXTENDED_CREATION_DATE, creationDate);
    }

    public Integer getCriticalSlackLimit() {
        return (Integer)this.getCachedValue(ProjectField.CRITICAL_SLACK_LIMIT);
    }

    public void setCriticalSlackLimit(Integer criticalSlackLimit) {
        this.set((FieldType)ProjectField.CRITICAL_SLACK_LIMIT, criticalSlackLimit);
    }

    public Integer getBaselineForEarnedValue() {
        return (Integer)this.getCachedValue(ProjectField.BASELINE_FOR_EARNED_VALUE);
    }

    public void setBaselineForEarnedValue(Integer baselineForEarnedValue) {
        this.set((FieldType)ProjectField.BASELINE_FOR_EARNED_VALUE, baselineForEarnedValue);
    }

    public Integer getFiscalYearStartMonth() {
        return (Integer)this.getCachedValue(ProjectField.FISCAL_YEAR_START_MONTH);
    }

    public void setFiscalYearStartMonth(Integer fiscalYearStartMonth) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START_MONTH, fiscalYearStartMonth);
    }

    public boolean getNewTaskStartIsProjectStart() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASK_START_IS_PROJECT_START));
    }

    public void setNewTaskStartIsProjectStart(boolean newTaskStartIsProjectStart) {
        this.set((FieldType)ProjectField.NEW_TASK_START_IS_PROJECT_START, newTaskStartIsProjectStart);
    }

    public Day getWeekStartDay() {
        return (Day)this.getCachedValue(ProjectField.WEEK_START_DAY);
    }

    public void setWeekStartDay(Day weekStartDay) {
        this.set((FieldType)ProjectField.WEEK_START_DAY, weekStartDay);
    }

    public void setCalculateMultipleCriticalPaths(boolean flag) {
        this.set((FieldType)ProjectField.CALCULATE_MULTIPLE_CRITICAL_PATHS, flag);
    }

    public boolean getCalculateMultipleCriticalPaths() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.CALCULATE_MULTIPLE_CRITICAL_PATHS));
    }

    public String getCurrencyCode() {
        return (String)this.getCachedValue(ProjectField.CURRENCY_CODE);
    }

    public void setCurrencyCode(String currencyCode) {
        this.set((FieldType)ProjectField.CURRENCY_CODE, currencyCode);
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.set((FieldType)ProjectField.CUSTOM_PROPERTIES, customProperties);
    }

    public Map<String, Object> getCustomProperties() {
        return (Map)this.getCachedValue(ProjectField.CUSTOM_PROPERTIES);
    }

    public void setHyperlinkBase(String hyperlinkBase) {
        this.set((FieldType)ProjectField.HYPERLINK_BASE, hyperlinkBase);
    }

    public String getHyperlinkBase() {
        return (String)this.getCachedValue(ProjectField.HYPERLINK_BASE);
    }

    public boolean getShowProjectSummaryTask() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SHOW_PROJECT_SUMMARY_TASK));
    }

    public void setShowProjectSummaryTask(boolean value) {
        this.set((FieldType)ProjectField.SHOW_PROJECT_SUMMARY_TASK, value);
    }

    public Date getBaselineDate() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_DATE);
    }

    public void setBaselineDate(Date value) {
        this.set((FieldType)ProjectField.BASELINE_DATE, value);
    }

    public Date getBaselineDate(int baselineNumber) {
        return (Date)this.getCachedValue(this.selectField(ProjectFieldLists.BASELINE_DATES, baselineNumber));
    }

    public void setBaselineDate(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(ProjectFieldLists.BASELINE_DATES, baselineNumber), value);
    }

    public String getTemplate() {
        return (String)this.getCachedValue(ProjectField.TEMPLATE);
    }

    public void setTemplate(String template) {
        this.set((FieldType)ProjectField.TEMPLATE, template);
    }

    public String getLastAuthor() {
        return (String)this.getCachedValue(ProjectField.LAST_AUTHOR);
    }

    public void setLastAuthor(String projectUser) {
        this.set((FieldType)ProjectField.LAST_AUTHOR, projectUser);
    }

    public Date getLastPrinted() {
        return (Date)this.getCachedValue(ProjectField.LASTPRINTED);
    }

    public void setLastPrinted(Date lastPrinted) {
        this.set((FieldType)ProjectField.LASTPRINTED, lastPrinted);
    }

    public String getShortApplicationName() {
        return (String)this.getCachedValue(ProjectField.SHORT_APPLICATION_NAME);
    }

    public void setShortApplicationName(String application) {
        this.set((FieldType)ProjectField.SHORT_APPLICATION_NAME, application);
    }

    public Integer getEditingTime() {
        return (Integer)this.getCachedValue(ProjectField.EDITING_TIME);
    }

    public void setEditingTime(Integer editingTime) {
        this.set((FieldType)ProjectField.EDITING_TIME, editingTime);
    }

    public String getPresentationFormat() {
        return (String)this.getCachedValue(ProjectField.PRESENTATION_FORMAT);
    }

    public void setPresentationFormat(String format) {
        this.set((FieldType)ProjectField.PRESENTATION_FORMAT, format);
    }

    public String getContentType() {
        return (String)this.getCachedValue(ProjectField.CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.set((FieldType)ProjectField.CONTENT_TYPE, contentType);
    }

    public String getContentStatus() {
        return (String)this.getCachedValue(ProjectField.CONTENT_STATUS);
    }

    public void setContentStatus(String contentStatus) {
        this.set((FieldType)ProjectField.CONTENT_STATUS, contentStatus);
    }

    public String getLanguage() {
        return (String)this.getCachedValue(ProjectField.LANGUAGE);
    }

    public void setLanguage(String language) {
        this.set((FieldType)ProjectField.LANGUAGE, language);
    }

    public String getDocumentVersion() {
        return (String)this.getCachedValue(ProjectField.DOCUMENT_VERSION);
    }

    public void setDocumentVersion(String documentVersion) {
        this.set((FieldType)ProjectField.DOCUMENT_VERSION, documentVersion);
    }

    public void setMpxDelimiter(char delimiter) {
        this.set((FieldType)ProjectField.MPX_DELIMITER, Character.valueOf(delimiter));
    }

    public char getMpxDelimiter() {
        return this.getCachedCharValue(ProjectField.MPX_DELIMITER, ',');
    }

    public void setMpxProgramName(String programName) {
        this.set((FieldType)ProjectField.MPX_PROGRAM_NAME, programName);
    }

    public String getMpxProgramName() {
        return (String)this.getCachedValue(ProjectField.MPX_PROGRAM_NAME);
    }

    public void setMpxFileVersion(FileVersion version) {
        this.set((FieldType)ProjectField.MPX_FILE_VERSION, version);
    }

    public FileVersion getMpxFileVersion() {
        return (FileVersion)this.getCachedValue(ProjectField.MPX_FILE_VERSION);
    }

    public void setMpxCodePage(CodePage codePage) {
        this.set((FieldType)ProjectField.MPX_CODE_PAGE, (Object)codePage);
    }

    public CodePage getMpxCodePage() {
        return (CodePage)((Object)this.getCachedValue(ProjectField.MPX_CODE_PAGE));
    }

    public void setProjectFilePath(String projectFilePath) {
        this.set((FieldType)ProjectField.PROJECT_FILE_PATH, projectFilePath);
    }

    public String getProjectFilePath() {
        return (String)this.getCachedValue(ProjectField.PROJECT_FILE_PATH);
    }

    public String getFullApplicationName() {
        return (String)this.getCachedValue(ProjectField.FULL_APPLICATION_NAME);
    }

    public void setFullApplicationName(String name) {
        this.set((FieldType)ProjectField.FULL_APPLICATION_NAME, name);
    }

    public Integer getApplicationVersion() {
        return (Integer)this.getCachedValue(ProjectField.APPLICATION_VERSION);
    }

    public void setApplicationVersion(Integer version) {
        this.set((FieldType)ProjectField.APPLICATION_VERSION, version);
    }

    public Integer getMppFileType() {
        return (Integer)this.getCachedValue(ProjectField.MPP_FILE_TYPE);
    }

    public void setMppFileType(Integer fileType) {
        this.set((FieldType)ProjectField.MPP_FILE_TYPE, fileType);
    }

    public boolean getAutoFilter() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTOFILTER));
    }

    public void setAutoFilter(boolean autoFilter) {
        this.set((FieldType)ProjectField.AUTOFILTER, autoFilter);
    }

    public String getFileApplication() {
        return (String)this.getCachedValue(ProjectField.FILE_APPLICATION);
    }

    public void setFileApplication(String type) {
        this.set((FieldType)ProjectField.FILE_APPLICATION, type);
    }

    public String getFileType() {
        return (String)this.getCachedValue(ProjectField.FILE_TYPE);
    }

    public void setFileType(String type) {
        this.set((FieldType)ProjectField.FILE_TYPE, type);
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private ProjectField selectField(ProjectField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    private char getCachedCharValue(FieldType field, char defaultValue) {
        Character c = (Character)this.getCachedValue(field);
        return c == null ? defaultValue : c.charValue();
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        return this.getCachedValue(field);
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            this.m_array[index] = value;
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }
}

