/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;

public class ProjectConfig {
    private final ProjectFile m_parent;
    private boolean m_autoWBS = true;
    private boolean m_autoOutlineLevel = true;
    private boolean m_autoOutlineNumber = true;
    private boolean m_autoTaskUniqueID = true;
    private boolean m_autoCalendarUniqueID = true;
    private boolean m_autoAssignmentUniqueID = true;
    private boolean m_autoTaskID = true;
    private boolean m_autoResourceUniqueID = true;
    private boolean m_autoResourceID = true;
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_assignmentUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;

    public ProjectConfig(ProjectFile projectFile) {
        this.m_parent = projectFile;
    }

    public void setAutoWBS(boolean flag) {
        this.m_autoWBS = flag;
    }

    public void setAutoOutlineLevel(boolean flag) {
        this.m_autoOutlineLevel = flag;
    }

    public void setAutoOutlineNumber(boolean flag) {
        this.m_autoOutlineNumber = flag;
    }

    public void setAutoTaskUniqueID(boolean flag) {
        this.m_autoTaskUniqueID = flag;
    }

    public void setAutoCalendarUniqueID(boolean flag) {
        this.m_autoCalendarUniqueID = flag;
    }

    public void setAutoAssignmentUniqueID(boolean flag) {
        this.m_autoAssignmentUniqueID = flag;
    }

    public void setAutoTaskID(boolean flag) {
        this.m_autoTaskID = flag;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoAssignmentUniqueID() {
        return this.m_autoAssignmentUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public void setAutoResourceUniqueID(boolean flag) {
        this.m_autoResourceUniqueID = flag;
    }

    public void setAutoResourceID(boolean flag) {
        this.m_autoResourceID = flag;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getNextTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    public int getNextCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getNextAssignmentUniqueID() {
        return ++this.m_assignmentUniqueID;
    }

    public int getNextTaskID() {
        return ++this.m_taskID;
    }

    public int getNextResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getNextResourceID() {
        return ++this.m_resourceID;
    }

    public void updateUniqueCounters() {
        int uniqueID;
        for (Task task : this.m_parent.getTasks()) {
            uniqueID = NumberHelper.getInt(task.getUniqueID());
            if (uniqueID <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = uniqueID;
        }
        for (Resource resource : this.m_parent.getResources()) {
            uniqueID = NumberHelper.getInt(resource.getUniqueID());
            if (uniqueID <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = uniqueID;
        }
        for (ProjectCalendar calendar : this.m_parent.getCalendars()) {
            uniqueID = NumberHelper.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
        for (ResourceAssignment assignment : this.m_parent.getResourceAssignments()) {
            uniqueID = NumberHelper.getInt(assignment.getUniqueID());
            if (uniqueID <= this.m_assignmentUniqueID) continue;
            this.m_assignmentUniqueID = uniqueID;
        }
    }
}

