/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.common.DateHelper;

public class ProjectCalendarWeek
implements Comparable<ProjectCalendarWeek> {
    private String m_name;
    private DateRange m_dateRange;
    private ProjectCalendarWeek m_parent;
    private ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private DayType[] m_days = new DayType[7];
    public static final DateRange DEFAULT_WORKING_MORNING = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(12, 0));
    public static final DateRange DEFAULT_WORKING_AFTERNOON = new DateRange(DateHelper.getTime(13, 0), DateHelper.getTime(17, 0));

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public DateRange getDateRange() {
        return this.m_dateRange;
    }

    public void setDateRange(DateRange range) {
        this.m_dateRange = range;
    }

    public ProjectCalendarWeek getParent() {
        return this.m_parent;
    }

    void setParent(ProjectCalendarWeek parent) {
        this.m_parent = parent;
        for (int loop = 0; loop < this.m_days.length; ++loop) {
            if (this.m_days[loop] != null) continue;
            this.m_days[loop] = DayType.DEFAULT;
        }
    }

    public boolean isDerived() {
        return this.m_parent != null;
    }

    public ProjectCalendarHours addCalendarHours() {
        return new ProjectCalendarHours(this);
    }

    public ProjectCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    public ProjectCalendarHours[] getHours() {
        return this.m_hours;
    }

    public ProjectCalendarHours getHours(Day day) {
        ProjectCalendarHours result = this.getCalendarHours(day);
        if (result == null) {
            if (this.m_parent == null) {
                this.addDefaultCalendarHours(day);
                result = this.getCalendarHours(day);
            } else {
                result = this.m_parent.getHours(day);
            }
        }
        return result;
    }

    public void addDefaultCalendarHours() {
        for (int i = 1; i <= 7; ++i) {
            this.addDefaultCalendarHours(Day.getInstance(i));
        }
    }

    public void addDefaultCalendarHours(Day day) {
        ProjectCalendarHours hours = this.addCalendarHours(day);
        if (day != Day.SATURDAY && day != Day.SUNDAY) {
            hours.addRange(DEFAULT_WORKING_MORNING);
            hours.addRange(DEFAULT_WORKING_AFTERNOON);
        }
    }

    public ProjectCalendarHours addCalendarHours(Day day) {
        ProjectCalendarHours bch = new ProjectCalendarHours(this);
        bch.setDay(day);
        this.m_hours[day.getValue() - 1] = bch;
        return bch;
    }

    public void attachHoursToDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = hours;
    }

    public void removeHoursFromDay(ProjectCalendarHours hours) {
        if (hours.getParentCalendar() != this) {
            throw new IllegalArgumentException();
        }
        this.m_hours[hours.getDay().getValue() - 1] = null;
    }

    public DayType[] getDays() {
        return this.m_days;
    }

    public DayType getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, boolean working) {
        this.setWorkingDay(day, working ? DayType.WORKING : DayType.NON_WORKING);
    }

    public void setWorkingDay(Day day, DayType working) {
        DayType value = working == null ? (this.isDerived() ? DayType.DEFAULT : DayType.WORKING) : working;
        this.m_days[day.getValue() - 1] = value;
    }

    @Override
    public int compareTo(ProjectCalendarWeek o) {
        long fromTime2;
        long fromTime1 = this.m_dateRange.getStart().getTime();
        return fromTime1 < (fromTime2 = o.m_dateRange.getStart().getTime()) ? -1 : (fromTime1 == fromTime2 ? 0 : 1);
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendarWeek");
        pw.println("   name=" + this.getName());
        pw.println("   date_range=" + this.getDateRange());
        String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        for (int loop = 0; loop < 7; ++loop) {
            pw.println("   [Day " + dayName[loop]);
            pw.println("      type=" + this.getDays()[loop]);
            pw.println("      hours=" + this.getHours()[loop]);
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

