/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;

public class GenericCriteria {
    private ProjectProperties m_properties;
    private FieldType m_leftValue;
    private TestOperator m_operator;
    private Object[] m_definedRightValues = new Object[2];
    private Object[] m_workingRightValues = new Object[2];
    private boolean m_symbolicValues;
    private List<GenericCriteria> m_criteriaList = new LinkedList<GenericCriteria>();

    public GenericCriteria(ProjectProperties properties) {
        this.m_properties = properties;
    }

    public void setLeftValue(FieldType value) {
        this.m_leftValue = value;
    }

    public FieldType getLeftValue() {
        return this.m_leftValue;
    }

    public TestOperator getOperator() {
        return this.m_operator;
    }

    public void setOperator(TestOperator operator) {
        this.m_operator = operator;
    }

    public void setRightValue(int index, Object value) {
        this.m_definedRightValues[index] = value;
        if (value instanceof FieldType) {
            this.m_symbolicValues = true;
        } else if (value instanceof Duration && ((Duration)value).getUnits() != TimeUnit.HOURS) {
            value = ((Duration)value).convertUnits(TimeUnit.HOURS, this.m_properties);
        }
        this.m_workingRightValues[index] = value;
    }

    public Object getValue(int index) {
        return this.m_definedRightValues[index];
    }

    public boolean evaluate(FieldContainer container, Map<GenericCriteriaPrompt, Object> promptValues) {
        boolean result;
        Object lhs;
        FieldType field = this.m_leftValue;
        if (field == null) {
            lhs = null;
        } else {
            lhs = container.getCurrentValue(field);
            switch (field.getDataType()) {
                case DATE: {
                    if (lhs == null) break;
                    lhs = DateHelper.getDayStartDate((Date)lhs);
                    break;
                }
                case DURATION: {
                    if (lhs != null) {
                        Duration dur = (Duration)lhs;
                        lhs = dur.convertUnits(TimeUnit.HOURS, this.m_properties);
                        break;
                    }
                    lhs = Duration.getInstance(0, TimeUnit.HOURS);
                    break;
                }
                case STRING: {
                    lhs = lhs == null ? "" : lhs;
                    break;
                }
            }
        }
        Object[] rhs = this.m_symbolicValues ? this.processSymbolicValues(this.m_workingRightValues, container, promptValues) : this.m_workingRightValues;
        switch (this.m_operator) {
            case AND: 
            case OR: {
                result = this.evaluateLogicalOperator(container, promptValues);
                break;
            }
            default: {
                result = this.m_operator.evaluate(lhs, rhs);
            }
        }
        return result;
    }

    private boolean evaluateLogicalOperator(FieldContainer container, Map<GenericCriteriaPrompt, Object> promptValues) {
        boolean result = false;
        if (this.m_criteriaList.size() == 0) {
            result = true;
        } else {
            for (GenericCriteria criteria : this.m_criteriaList) {
                result = criteria.evaluate(container, promptValues);
                if ((this.m_operator != TestOperator.AND || result) && (this.m_operator != TestOperator.OR || !result)) continue;
                break;
            }
        }
        return result;
    }

    private Object[] processSymbolicValues(Object[] oldValues, FieldContainer container, Map<GenericCriteriaPrompt, Object> promptValues) {
        Object[] newValues = new Object[2];
        for (int loop = 0; loop < oldValues.length; ++loop) {
            Object value = oldValues[loop];
            if (value == null) continue;
            if (value instanceof FieldType) {
                FieldType type = (FieldType)value;
                value = container.getCachedValue(type);
                switch (type.getDataType()) {
                    case DATE: {
                        if (value == null) break;
                        value = DateHelper.getDayStartDate((Date)value);
                        break;
                    }
                    case DURATION: {
                        if (value != null && ((Duration)value).getUnits() != TimeUnit.HOURS) {
                            value = ((Duration)value).convertUnits(TimeUnit.HOURS, this.m_properties);
                            break;
                        }
                        value = Duration.getInstance(0, TimeUnit.HOURS);
                        break;
                    }
                    case STRING: {
                        value = value == null ? "" : value;
                        break;
                    }
                }
            } else if (value instanceof GenericCriteriaPrompt && promptValues != null) {
                GenericCriteriaPrompt prompt = (GenericCriteriaPrompt)value;
                value = promptValues.get(prompt);
            }
            newValues[loop] = value;
        }
        return newValues;
    }

    public List<GenericCriteria> getCriteriaList() {
        return this.m_criteriaList;
    }

    public void addCriteria(GenericCriteria criteria) {
        this.m_criteriaList.add(criteria);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        switch (this.m_operator) {
            case AND: 
            case OR: {
                int index = 0;
                for (GenericCriteria c : this.m_criteriaList) {
                    sb.append(c);
                    if (++index >= this.m_criteriaList.size()) continue;
                    sb.append(" ");
                    sb.append(this.m_operator);
                    sb.append(" ");
                }
                break;
            }
            default: {
                sb.append(this.m_leftValue);
                sb.append(" ");
                sb.append(this.m_operator);
                sb.append(" ");
                sb.append(this.m_definedRightValues[0]);
                if (this.m_definedRightValues[1] == null) break;
                sb.append(",");
                sb.append(this.m_definedRightValues[1]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

