/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CustomFieldValueItem;

public class CustomFieldContainer
implements Iterable<CustomField> {
    private Map<FieldType, CustomField> m_configMap = new HashMap<FieldType, CustomField>();
    private Map<Integer, CustomFieldValueItem> m_valueMap = new HashMap<Integer, CustomFieldValueItem>();
    private Map<Pair<FieldTypeClass, String>, FieldType> m_aliasMap = new HashMap<Pair<FieldTypeClass, String>, FieldType>();
    private Map<String, Map<Integer, Object>> m_aliasValueMap = new HashMap<String, Map<Integer, Object>>();

    public CustomField getCustomField(FieldType field) {
        CustomField result = this.m_configMap.get(field);
        if (result == null) {
            result = new CustomField(field, this);
            this.m_configMap.put(field, result);
        }
        return result;
    }

    public int size() {
        return this.m_configMap.values().size();
    }

    @Override
    public Iterator<CustomField> iterator() {
        return this.m_configMap.values().iterator();
    }

    public CustomFieldValueItem getCustomFieldValueItemByUniqueID(int uniqueID) {
        return this.m_valueMap.get(uniqueID);
    }

    public void registerValue(CustomFieldValueItem item) {
        this.m_valueMap.put(item.getUniqueID(), item);
    }

    public void deregisterValue(CustomFieldValueItem item) {
        this.m_valueMap.remove(item.getUniqueID());
    }

    void registerAlias(FieldType type, String alias) {
        this.m_aliasMap.put(new Pair<FieldTypeClass, String>(type.getFieldTypeClass(), alias), type);
    }

    public FieldType getFieldByAlias(FieldTypeClass typeClass, String alias) {
        return this.m_aliasMap.get(new Pair<FieldTypeClass, String>(typeClass, alias));
    }

    public void registerAliasValue(String alias, Integer uid, Object value) {
        if (!this.m_aliasValueMap.containsKey(alias)) {
            this.m_aliasValueMap.put(alias, new HashMap());
        }
        this.m_aliasValueMap.get(alias).put(uid, value);
    }

    public Object getAliasValue(String alias, Integer uid) {
        if (this.m_aliasValueMap.containsKey(alias)) {
            return this.m_aliasValueMap.get(alias).get(uid);
        }
        return null;
    }
}

