/*
 * file:       FieldMap9.java
 * author:     Jon Iles
 * copyright:  (c) Packwood Software 2011
 * date:       13/04/2010
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

package net.sf.mpxj.mpp;

import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.FieldTypeHelper;

/**
 * MPP9 field map.
 */
class FieldMap9 extends FieldMap
{
   /**
    * Constructor.
    *
    * @param properties project properties
    * @param customFields custom fields
    */
   public FieldMap9(ProjectProperties properties, CustomFieldContainer customFields)
   {
      super(properties, customFields);
   }

   /**
    * {@inheritDoc}
    */
   @Override protected FieldType getFieldType(int fieldID)
   {
      return FieldTypeHelper.getInstance(fieldID);
   }

   /**
    * {@inheritDoc}
    */
   @Override protected boolean useTypeAsVarDataKey()
   {
      return false;
   }

   /**
    * {@inheritDoc}
    */
   @Override protected Integer substituteVarDataKey(FieldType type)
   {
      return null;
   }

   /**
    * {@inheritDoc}
    */
   @Override protected FieldItem[] getDefaultTaskData()
   {
      FieldItem[] result = new FieldItem[]
      {
         new FieldItem(TaskField.UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 0, 0, 0, 0),
         new FieldItem(TaskField.ID, FieldLocation.FIXED_DATA, 0, 4, 0, 0, 0),
         new FieldItem(TaskField.EARLY_FINISH, FieldLocation.FIXED_DATA, 0, 8, 0, 0, 0),
         new FieldItem(TaskField.LATE_START, FieldLocation.FIXED_DATA, 0, 12, 0, 0, 0),
         new FieldItem(TaskField.STOP, FieldLocation.FIXED_DATA, 0, 16, 0, 0, 0),
         new FieldItem(TaskField.RESUME, FieldLocation.FIXED_DATA, 0, 20, 0, 0, 0),
         new FieldItem(TaskField.FREE_SLACK, FieldLocation.FIXED_DATA, 0, 24, 0, 0, 0),
         new FieldItem(TaskField.START_SLACK, FieldLocation.FIXED_DATA, 0, 28, 0, 0, 0),
         new FieldItem(TaskField.FINISH_SLACK, FieldLocation.FIXED_DATA, 0, 32, 0, 0, 0),
         new FieldItem(TaskField.PARENT_TASK_UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 36, 0, 0, 0),
         new FieldItem(TaskField.OUTLINE_LEVEL, FieldLocation.FIXED_DATA, 0, 40, 0, 0, 0),
         new FieldItem(TaskField.DURATION_UNITS, FieldLocation.FIXED_DATA, 0, 58, 0, 0, 0),
         new FieldItem(TaskField.DURATION, FieldLocation.FIXED_DATA, 0, 60, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_DURATION_UNITS, FieldLocation.FIXED_DATA, 0, 64, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_DURATION, FieldLocation.FIXED_DATA, 0, 66, 0, 0, 0),
         new FieldItem(TaskField.REMAINING_DURATION, FieldLocation.FIXED_DATA, 0, 70, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_DURATION, FieldLocation.FIXED_DATA, 0, 74, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_DURATION_UNITS, FieldLocation.FIXED_DATA, 0, 78, 0, 0, 0),
         new FieldItem(TaskField.CONSTRAINT_TYPE, FieldLocation.FIXED_DATA, 0, 80, 0, 0, 0),
         new FieldItem(TaskField.LEVELING_DELAY, FieldLocation.FIXED_DATA, 0, 82, 0, 0, 0),
         new FieldItem(TaskField.LEVELING_DELAY_UNITS, FieldLocation.FIXED_DATA, 0, 86, 0, 0, 0),
         new FieldItem(TaskField.START, FieldLocation.FIXED_DATA, 0, 88, 0, 0, 0),
         new FieldItem(TaskField.FINISH, FieldLocation.FIXED_DATA, 0, 92, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_START, FieldLocation.FIXED_DATA, 0, 96, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_FINISH, FieldLocation.FIXED_DATA, 0, 100, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_START, FieldLocation.FIXED_DATA, 0, 104, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_FINISH, FieldLocation.FIXED_DATA, 0, 108, 0, 0, 0),
         new FieldItem(TaskField.CONSTRAINT_DATE, FieldLocation.FIXED_DATA, 0, 112, 0, 0, 0),
         new FieldItem(TaskField.RESUME_NO_EARLIER_THAN, FieldLocation.FIXED_DATA, 0, 116, 0, 0, 0),
         new FieldItem(TaskField.PRIORITY, FieldLocation.FIXED_DATA, 0, 120, 0, 0, 0),
         new FieldItem(TaskField.PERCENT_COMPLETE, FieldLocation.FIXED_DATA, 0, 122, 0, 0, 0),
         new FieldItem(TaskField.PERCENT_WORK_COMPLETE, FieldLocation.FIXED_DATA, 0, 124, 0, 0, 0),
         new FieldItem(TaskField.TYPE, FieldLocation.FIXED_DATA, 0, 126, 0, 0, 0),
         new FieldItem(TaskField.FIXED_COST_ACCRUAL, FieldLocation.FIXED_DATA, 0, 128, 0, 0, 0),
         new FieldItem(TaskField.CREATED, FieldLocation.FIXED_DATA, 0, 130, 0, 0, 0),
         new FieldItem(TaskField.RECURRING, FieldLocation.FIXED_DATA, 0, 134, 0, 0, 0),
         new FieldItem(TaskField.PRELEVELED_START, FieldLocation.FIXED_DATA, 0, 136, 0, 0, 0),
         new FieldItem(TaskField.PRELEVELED_FINISH, FieldLocation.FIXED_DATA, 0, 140, 0, 0, 0),
         new FieldItem(TaskField.EARLY_START, FieldLocation.FIXED_DATA, 0, 148, 0, 0, 0),
         new FieldItem(TaskField.LATE_FINISH, FieldLocation.FIXED_DATA, 0, 152, 0, 0, 0),
         new FieldItem(TaskField.SUMMARY_PROGRESS, FieldLocation.FIXED_DATA, 0, 156, 0, 0, 0),
         new FieldItem(TaskField.CALENDAR_UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 160, 0, 0, 0),
         new FieldItem(TaskField.DEADLINE, FieldLocation.FIXED_DATA, 0, 164, 0, 0, 0),
         new FieldItem(TaskField.WORK, FieldLocation.FIXED_DATA, 0, 168, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_WORK, FieldLocation.FIXED_DATA, 0, 176, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_WORK, FieldLocation.FIXED_DATA, 0, 184, 0, 0, 0),
         new FieldItem(TaskField.REMAINING_WORK, FieldLocation.FIXED_DATA, 0, 192, 0, 0, 0),
         new FieldItem(TaskField.COST, FieldLocation.FIXED_DATA, 0, 200, 0, 0, 0),
         new FieldItem(TaskField.FIXED_COST, FieldLocation.FIXED_DATA, 0, 208, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_COST, FieldLocation.FIXED_DATA, 0, 216, 0, 0, 0),
         new FieldItem(TaskField.REMAINING_COST, FieldLocation.FIXED_DATA, 0, 224, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_COST, FieldLocation.FIXED_DATA, 0, 232, 0, 0, 0),
         new FieldItem(TaskField.BASELINE_FIXED_COST, FieldLocation.FIXED_DATA, 0, 256, 0, 0, 0),
         new FieldItem(TaskField.ACTUAL_OVERTIME_WORK, FieldLocation.VAR_DATA, 0, 65535, 3, 0, 0),
         new FieldItem(TaskField.REMAINING_OVERTIME_WORK, FieldLocation.VAR_DATA, 0, 65535, 4, 0, 0),
         new FieldItem(TaskField.OVERTIME_COST, FieldLocation.VAR_DATA, 0, 65535, 5, 0, 0),
         new FieldItem(TaskField.ACTUAL_OVERTIME_COST, FieldLocation.VAR_DATA, 0, 65535, 6, 0, 0),
         new FieldItem(TaskField.REMAINING_OVERTIME_COST, FieldLocation.VAR_DATA, 0, 65535, 7, 0, 0),
         new FieldItem(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, FieldLocation.VAR_DATA, 0, 65535, 8, 0, 0),
         new FieldItem(TaskField.SUBPROJECT_UNIQUE_TASK_ID, FieldLocation.VAR_DATA, 0, 65535, 9, 0, 0),
         new FieldItem(TaskField.WBS, FieldLocation.VAR_DATA, 0, 65535, 10, 0, 0),
         new FieldItem(TaskField.NAME, FieldLocation.VAR_DATA, 0, 65535, 11, 0, 0),
         new FieldItem(TaskField.CONTACT, FieldLocation.VAR_DATA, 0, 65535, 12, 0, 0),
         new FieldItem(TaskField.TEXT1, FieldLocation.VAR_DATA, 0, 65535, 14, 0, 0),
         new FieldItem(TaskField.TEXT2, FieldLocation.VAR_DATA, 0, 65535, 15, 0, 0),
         new FieldItem(TaskField.TEXT3, FieldLocation.VAR_DATA, 0, 65535, 16, 0, 0),
         new FieldItem(TaskField.TEXT4, FieldLocation.VAR_DATA, 0, 65535, 17, 0, 0),
         new FieldItem(TaskField.TEXT5, FieldLocation.VAR_DATA, 0, 65535, 18, 0, 0),
         new FieldItem(TaskField.TEXT6, FieldLocation.VAR_DATA, 0, 65535, 19, 0, 0),
         new FieldItem(TaskField.TEXT7, FieldLocation.VAR_DATA, 0, 65535, 20, 0, 0),
         new FieldItem(TaskField.TEXT8, FieldLocation.VAR_DATA, 0, 65535, 21, 0, 0),
         new FieldItem(TaskField.TEXT9, FieldLocation.VAR_DATA, 0, 65535, 22, 0, 0),
         new FieldItem(TaskField.TEXT10, FieldLocation.VAR_DATA, 0, 65535, 23, 0, 0),
         new FieldItem(TaskField.START1, FieldLocation.VAR_DATA, 0, 65535, 24, 0, 0),
         new FieldItem(TaskField.FINISH1, FieldLocation.VAR_DATA, 0, 65535, 25, 0, 0),
         new FieldItem(TaskField.START2, FieldLocation.VAR_DATA, 0, 65535, 26, 0, 0),
         new FieldItem(TaskField.FINISH2, FieldLocation.VAR_DATA, 0, 65535, 27, 0, 0),
         new FieldItem(TaskField.START3, FieldLocation.VAR_DATA, 0, 65535, 28, 0, 0),
         new FieldItem(TaskField.FINISH3, FieldLocation.VAR_DATA, 0, 65535, 29, 0, 0),
         new FieldItem(TaskField.START4, FieldLocation.VAR_DATA, 0, 65535, 30, 0, 0),
         new FieldItem(TaskField.FINISH4, FieldLocation.VAR_DATA, 0, 65535, 31, 0, 0),
         new FieldItem(TaskField.START5, FieldLocation.VAR_DATA, 0, 65535, 32, 0, 0),
         new FieldItem(TaskField.FINISH5, FieldLocation.VAR_DATA, 0, 65535, 33, 0, 0),
         new FieldItem(TaskField.START6, FieldLocation.VAR_DATA, 0, 65535, 34, 0, 0),
         new FieldItem(TaskField.FINISH6, FieldLocation.VAR_DATA, 0, 65535, 35, 0, 0),
         new FieldItem(TaskField.START7, FieldLocation.VAR_DATA, 0, 65535, 36, 0, 0),
         new FieldItem(TaskField.FINISH7, FieldLocation.VAR_DATA, 0, 65535, 37, 0, 0),
         new FieldItem(TaskField.START8, FieldLocation.VAR_DATA, 0, 65535, 38, 0, 0),
         new FieldItem(TaskField.FINISH8, FieldLocation.VAR_DATA, 0, 65535, 39, 0, 0),
         new FieldItem(TaskField.START9, FieldLocation.VAR_DATA, 0, 65535, 40, 0, 0),
         new FieldItem(TaskField.FINISH9, FieldLocation.VAR_DATA, 0, 65535, 41, 0, 0),
         new FieldItem(TaskField.START10, FieldLocation.VAR_DATA, 0, 65535, 42, 0, 0),
         new FieldItem(TaskField.FINISH10, FieldLocation.VAR_DATA, 0, 65535, 43, 0, 0),
         new FieldItem(TaskField.NUMBER1, FieldLocation.VAR_DATA, 0, 65535, 45, 0, 0),
         new FieldItem(TaskField.NUMBER2, FieldLocation.VAR_DATA, 0, 65535, 46, 0, 0),
         new FieldItem(TaskField.NUMBER3, FieldLocation.VAR_DATA, 0, 65535, 47, 0, 0),
         new FieldItem(TaskField.NUMBER4, FieldLocation.VAR_DATA, 0, 65535, 48, 0, 0),
         new FieldItem(TaskField.NUMBER5, FieldLocation.VAR_DATA, 0, 65535, 49, 0, 0),
         new FieldItem(TaskField.NUMBER6, FieldLocation.VAR_DATA, 0, 65535, 50, 0, 0),
         new FieldItem(TaskField.NUMBER7, FieldLocation.VAR_DATA, 0, 65535, 51, 0, 0),
         new FieldItem(TaskField.NUMBER8, FieldLocation.VAR_DATA, 0, 65535, 52, 0, 0),
         new FieldItem(TaskField.NUMBER9, FieldLocation.VAR_DATA, 0, 65535, 53, 0, 0),
         new FieldItem(TaskField.NUMBER10, FieldLocation.VAR_DATA, 0, 65535, 54, 0, 0),
         new FieldItem(TaskField.DURATION1, FieldLocation.VAR_DATA, 0, 65535, 55, 0, 0),
         new FieldItem(TaskField.DURATION1_UNITS, FieldLocation.VAR_DATA, 0, 65535, 56, 0, 0),
         new FieldItem(TaskField.DURATION2, FieldLocation.VAR_DATA, 0, 65535, 57, 0, 0),
         new FieldItem(TaskField.DURATION2_UNITS, FieldLocation.VAR_DATA, 0, 65535, 58, 0, 0),
         new FieldItem(TaskField.DURATION3, FieldLocation.VAR_DATA, 0, 65535, 59, 0, 0),
         new FieldItem(TaskField.DURATION3_UNITS, FieldLocation.VAR_DATA, 0, 65535, 60, 0, 0),
         new FieldItem(TaskField.DURATION4, FieldLocation.VAR_DATA, 0, 65535, 61, 0, 0),
         new FieldItem(TaskField.DURATION4_UNITS, FieldLocation.VAR_DATA, 0, 65535, 62, 0, 0),
         new FieldItem(TaskField.DURATION5, FieldLocation.VAR_DATA, 0, 65535, 63, 0, 0),
         new FieldItem(TaskField.DURATION5_UNITS, FieldLocation.VAR_DATA, 0, 65535, 64, 0, 0),
         new FieldItem(TaskField.DURATION6, FieldLocation.VAR_DATA, 0, 65535, 65, 0, 0),
         new FieldItem(TaskField.DURATION6_UNITS, FieldLocation.VAR_DATA, 0, 65535, 66, 0, 0),
         new FieldItem(TaskField.DURATION7, FieldLocation.VAR_DATA, 0, 65535, 67, 0, 0),
         new FieldItem(TaskField.DURATION7_UNITS, FieldLocation.VAR_DATA, 0, 65535, 68, 0, 0),
         new FieldItem(TaskField.DURATION8, FieldLocation.VAR_DATA, 0, 65535, 69, 0, 0),
         new FieldItem(TaskField.DURATION8_UNITS, FieldLocation.VAR_DATA, 0, 65535, 70, 0, 0),
         new FieldItem(TaskField.DURATION9, FieldLocation.VAR_DATA, 0, 65535, 71, 0, 0),
         new FieldItem(TaskField.DURATION9_UNITS, FieldLocation.VAR_DATA, 0, 65535, 72, 0, 0),
         new FieldItem(TaskField.DURATION10, FieldLocation.VAR_DATA, 0, 65535, 73, 0, 0),
         new FieldItem(TaskField.DURATION10_UNITS, FieldLocation.VAR_DATA, 0, 65535, 74, 0, 0),
         new FieldItem(TaskField.RECURRING_DATA, FieldLocation.VAR_DATA, 0, 65535, 76, 0, 0),
         new FieldItem(TaskField.SUBPROJECT_TASK_ID, FieldLocation.VAR_DATA, 0, 65535, 79, 0, 0),
         new FieldItem(TaskField.DATE1, FieldLocation.VAR_DATA, 0, 65535, 80, 0, 0),
         new FieldItem(TaskField.DATE2, FieldLocation.VAR_DATA, 0, 65535, 81, 0, 0),
         new FieldItem(TaskField.DATE3, FieldLocation.VAR_DATA, 0, 65535, 82, 0, 0),
         new FieldItem(TaskField.DATE4, FieldLocation.VAR_DATA, 0, 65535, 83, 0, 0),
         new FieldItem(TaskField.DATE5, FieldLocation.VAR_DATA, 0, 65535, 84, 0, 0),
         new FieldItem(TaskField.DATE6, FieldLocation.VAR_DATA, 0, 65535, 85, 0, 0),
         new FieldItem(TaskField.DATE7, FieldLocation.VAR_DATA, 0, 65535, 86, 0, 0),
         new FieldItem(TaskField.DATE8, FieldLocation.VAR_DATA, 0, 65535, 87, 0, 0),
         new FieldItem(TaskField.DATE9, FieldLocation.VAR_DATA, 0, 65535, 88, 0, 0),
         new FieldItem(TaskField.DATE10, FieldLocation.VAR_DATA, 0, 65535, 89, 0, 0),
         new FieldItem(TaskField.TEXT11, FieldLocation.VAR_DATA, 0, 65535, 90, 0, 0),
         new FieldItem(TaskField.TEXT12, FieldLocation.VAR_DATA, 0, 65535, 91, 0, 0),
         new FieldItem(TaskField.TEXT13, FieldLocation.VAR_DATA, 0, 65535, 92, 0, 0),
         new FieldItem(TaskField.TEXT14, FieldLocation.VAR_DATA, 0, 65535, 93, 0, 0),
         new FieldItem(TaskField.TEXT15, FieldLocation.VAR_DATA, 0, 65535, 94, 0, 0),
         new FieldItem(TaskField.TEXT16, FieldLocation.VAR_DATA, 0, 65535, 95, 0, 0),
         new FieldItem(TaskField.TEXT17, FieldLocation.VAR_DATA, 0, 65535, 96, 0, 0),
         new FieldItem(TaskField.TEXT18, FieldLocation.VAR_DATA, 0, 65535, 97, 0, 0),
         new FieldItem(TaskField.TEXT19, FieldLocation.VAR_DATA, 0, 65535, 98, 0, 0),
         new FieldItem(TaskField.TEXT20, FieldLocation.VAR_DATA, 0, 65535, 99, 0, 0),
         new FieldItem(TaskField.TEXT21, FieldLocation.VAR_DATA, 0, 65535, 100, 0, 0),
         new FieldItem(TaskField.TEXT22, FieldLocation.VAR_DATA, 0, 65535, 101, 0, 0),
         new FieldItem(TaskField.TEXT23, FieldLocation.VAR_DATA, 0, 65535, 102, 0, 0),
         new FieldItem(TaskField.TEXT24, FieldLocation.VAR_DATA, 0, 65535, 103, 0, 0),
         new FieldItem(TaskField.TEXT25, FieldLocation.VAR_DATA, 0, 65535, 104, 0, 0),
         new FieldItem(TaskField.TEXT26, FieldLocation.VAR_DATA, 0, 65535, 105, 0, 0),
         new FieldItem(TaskField.TEXT27, FieldLocation.VAR_DATA, 0, 65535, 106, 0, 0),
         new FieldItem(TaskField.TEXT28, FieldLocation.VAR_DATA, 0, 65535, 107, 0, 0),
         new FieldItem(TaskField.TEXT29, FieldLocation.VAR_DATA, 0, 65535, 108, 0, 0),
         new FieldItem(TaskField.TEXT30, FieldLocation.VAR_DATA, 0, 65535, 109, 0, 0),
         new FieldItem(TaskField.NUMBER11, FieldLocation.VAR_DATA, 0, 65535, 110, 0, 0),
         new FieldItem(TaskField.NUMBER12, FieldLocation.VAR_DATA, 0, 65535, 111, 0, 0),
         new FieldItem(TaskField.NUMBER13, FieldLocation.VAR_DATA, 0, 65535, 112, 0, 0),
         new FieldItem(TaskField.NUMBER14, FieldLocation.VAR_DATA, 0, 65535, 113, 0, 0),
         new FieldItem(TaskField.NUMBER15, FieldLocation.VAR_DATA, 0, 65535, 114, 0, 0),
         new FieldItem(TaskField.NUMBER16, FieldLocation.VAR_DATA, 0, 65535, 115, 0, 0),
         new FieldItem(TaskField.NUMBER17, FieldLocation.VAR_DATA, 0, 65535, 116, 0, 0),
         new FieldItem(TaskField.NUMBER18, FieldLocation.VAR_DATA, 0, 65535, 117, 0, 0),
         new FieldItem(TaskField.NUMBER19, FieldLocation.VAR_DATA, 0, 65535, 118, 0, 0),
         new FieldItem(TaskField.NUMBER20, FieldLocation.VAR_DATA, 0, 65535, 119, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE1_INDEX, FieldLocation.VAR_DATA, 0, 65535, 123, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE2_INDEX, FieldLocation.VAR_DATA, 0, 65535, 124, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE3_INDEX, FieldLocation.VAR_DATA, 0, 65535, 125, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE4_INDEX, FieldLocation.VAR_DATA, 0, 65535, 126, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE5_INDEX, FieldLocation.VAR_DATA, 0, 65535, 127, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE6_INDEX, FieldLocation.VAR_DATA, 0, 65535, 128, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE7_INDEX, FieldLocation.VAR_DATA, 0, 65535, 129, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE8_INDEX, FieldLocation.VAR_DATA, 0, 65535, 130, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE9_INDEX, FieldLocation.VAR_DATA, 0, 65535, 131, 0, 0),
         new FieldItem(TaskField.OUTLINE_CODE10_INDEX, FieldLocation.VAR_DATA, 0, 65535, 132, 0, 0),
         new FieldItem(TaskField.HYPERLINK_DATA, FieldLocation.VAR_DATA, 0, 65535, 133, 0, 0),
         new FieldItem(TaskField.COST1, FieldLocation.VAR_DATA, 0, 65535, 134, 0, 0),
         new FieldItem(TaskField.COST2, FieldLocation.VAR_DATA, 0, 65535, 135, 0, 0),
         new FieldItem(TaskField.COST3, FieldLocation.VAR_DATA, 0, 65535, 136, 0, 0),
         new FieldItem(TaskField.COST4, FieldLocation.VAR_DATA, 0, 65535, 137, 0, 0),
         new FieldItem(TaskField.COST5, FieldLocation.VAR_DATA, 0, 65535, 138, 0, 0),
         new FieldItem(TaskField.COST6, FieldLocation.VAR_DATA, 0, 65535, 139, 0, 0),
         new FieldItem(TaskField.COST7, FieldLocation.VAR_DATA, 0, 65535, 140, 0, 0),
         new FieldItem(TaskField.COST8, FieldLocation.VAR_DATA, 0, 65535, 141, 0, 0),
         new FieldItem(TaskField.COST9, FieldLocation.VAR_DATA, 0, 65535, 142, 0, 0),
         new FieldItem(TaskField.COST10, FieldLocation.VAR_DATA, 0, 65535, 143, 0, 0),
         new FieldItem(TaskField.NOTES, FieldLocation.VAR_DATA, 0, 65535, 144, 0, 0),
         new FieldItem(TaskField.SUBPROJECT_FILE, FieldLocation.VAR_DATA, 0, 65535, 160, 0, 0),
         new FieldItem(TaskField.ENTERPRISE_DATA, FieldLocation.VAR_DATA, 0, 65535, 163, 0, 0)
      };
      return result;
   }

   /**
    * {@inheritDoc}
    */
   @Override protected FieldItem[] getDefaultResourceData()
   {
      FieldItem[] result = new FieldItem[]
      {
         new FieldItem(ResourceField.UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 0, 0, 0, 0),
         new FieldItem(ResourceField.ID, FieldLocation.FIXED_DATA, 0, 4, 0, 0, 0),
         new FieldItem(ResourceField.STANDARD_RATE_UNITS, FieldLocation.FIXED_DATA, 0, 8, 0, 0, 0),
         new FieldItem(ResourceField.OVERTIME_RATE_UNITS, FieldLocation.FIXED_DATA, 0, 10, 0, 0, 0),
         new FieldItem(ResourceField.ACCRUE_AT, FieldLocation.FIXED_DATA, 0, 12, 0, 0, 0),
         new FieldItem(ResourceField.WORKGROUP, FieldLocation.FIXED_DATA, 0, 14, 0, 0, 0),
         new FieldItem(ResourceField.AVAILABLE_FROM, FieldLocation.FIXED_DATA, 0, 20, 0, 0, 0),
         new FieldItem(ResourceField.AVAILABLE_TO, FieldLocation.FIXED_DATA, 0, 24, 0, 0, 0),
         new FieldItem(ResourceField.STANDARD_RATE, FieldLocation.FIXED_DATA, 0, 28, 0, 0, 0),
         new FieldItem(ResourceField.OVERTIME_RATE, FieldLocation.FIXED_DATA, 0, 36, 0, 0, 0),
         new FieldItem(ResourceField.MAX_UNITS, FieldLocation.FIXED_DATA, 0, 44, 0, 0, 0),
         new FieldItem(ResourceField.WORK, FieldLocation.FIXED_DATA, 0, 52, 0, 0, 0),
         new FieldItem(ResourceField.ACTUAL_WORK, FieldLocation.FIXED_DATA, 0, 60, 0, 0, 0),
         new FieldItem(ResourceField.BASELINE_WORK, FieldLocation.FIXED_DATA, 0, 68, 0, 0, 0),
         new FieldItem(ResourceField.OVERTIME_WORK, FieldLocation.FIXED_DATA, 0, 76, 0, 0, 0),
         new FieldItem(ResourceField.COST_PER_USE, FieldLocation.FIXED_DATA, 0, 84, 0, 0, 0),
         new FieldItem(ResourceField.REMAINING_WORK, FieldLocation.FIXED_DATA, 0, 92, 0, 0, 0),
         new FieldItem(ResourceField.REGULAR_WORK, FieldLocation.FIXED_DATA, 0, 100, 0, 0, 0),
         new FieldItem(ResourceField.ACTUAL_OVERTIME_WORK, FieldLocation.FIXED_DATA, 0, 108, 0, 0, 0),
         new FieldItem(ResourceField.REMAINING_OVERTIME_WORK, FieldLocation.FIXED_DATA, 0, 116, 0, 0, 0),
         new FieldItem(ResourceField.PEAK, FieldLocation.FIXED_DATA, 0, 124, 0, 0, 0),
         new FieldItem(ResourceField.ACTUAL_COST, FieldLocation.FIXED_DATA, 0, 132, 0, 0, 0),
         new FieldItem(ResourceField.COST, FieldLocation.FIXED_DATA, 0, 140, 0, 0, 0),
         new FieldItem(ResourceField.BASELINE_COST, FieldLocation.FIXED_DATA, 0, 148, 0, 0, 0),
         new FieldItem(ResourceField.REMAINING_COST, FieldLocation.FIXED_DATA, 0, 156, 0, 0, 0),
         new FieldItem(ResourceField.OVERTIME_COST, FieldLocation.FIXED_DATA, 0, 164, 0, 0, 0),
         new FieldItem(ResourceField.ACTUAL_OVERTIME_COST, FieldLocation.FIXED_DATA, 0, 172, 0, 0, 0),
         new FieldItem(ResourceField.REMAINING_OVERTIME_COST, FieldLocation.FIXED_DATA, 0, 180, 0, 0, 0),
         new FieldItem(ResourceField.NAME, FieldLocation.VAR_DATA, 0, 65535, 1, 0, 0),
         new FieldItem(ResourceField.INITIALS, FieldLocation.VAR_DATA, 0, 65535, 3, 0, 0),
         new FieldItem(ResourceField.GROUP, FieldLocation.VAR_DATA, 0, 65535, 4, 0, 0),
         new FieldItem(ResourceField.CODE, FieldLocation.VAR_DATA, 0, 65535, 5, 0, 0),
         new FieldItem(ResourceField.EMAIL_ADDRESS, FieldLocation.VAR_DATA, 0, 65535, 6, 0, 0),
         new FieldItem(ResourceField.PHONETICS, FieldLocation.VAR_DATA, 0, 65535, 7, 0, 0),
         new FieldItem(ResourceField.MATERIAL_LABEL, FieldLocation.VAR_DATA, 0, 65535, 8, 0, 0),
         new FieldItem(ResourceField.WINDOWS_USER_ACCOUNT, FieldLocation.VAR_DATA, 0, 65535, 9, 0, 0),
         new FieldItem(ResourceField.TEXT1, FieldLocation.VAR_DATA, 0, 65535, 10, 0, 0),
         new FieldItem(ResourceField.TEXT2, FieldLocation.VAR_DATA, 0, 65535, 11, 0, 0),
         new FieldItem(ResourceField.TEXT3, FieldLocation.VAR_DATA, 0, 65535, 12, 0, 0),
         new FieldItem(ResourceField.TEXT4, FieldLocation.VAR_DATA, 0, 65535, 13, 0, 0),
         new FieldItem(ResourceField.TEXT5, FieldLocation.VAR_DATA, 0, 65535, 14, 0, 0),
         new FieldItem(ResourceField.TEXT6, FieldLocation.VAR_DATA, 0, 65535, 15, 0, 0),
         new FieldItem(ResourceField.TEXT7, FieldLocation.VAR_DATA, 0, 65535, 16, 0, 0),
         new FieldItem(ResourceField.TEXT8, FieldLocation.VAR_DATA, 0, 65535, 17, 0, 0),
         new FieldItem(ResourceField.TEXT9, FieldLocation.VAR_DATA, 0, 65535, 18, 0, 0),
         new FieldItem(ResourceField.TEXT10, FieldLocation.VAR_DATA, 0, 65535, 19, 0, 0),
         new FieldItem(ResourceField.TEXT11, FieldLocation.VAR_DATA, 0, 65535, 20, 0, 0),
         new FieldItem(ResourceField.TEXT12, FieldLocation.VAR_DATA, 0, 65535, 21, 0, 0),
         new FieldItem(ResourceField.TEXT13, FieldLocation.VAR_DATA, 0, 65535, 22, 0, 0),
         new FieldItem(ResourceField.TEXT14, FieldLocation.VAR_DATA, 0, 65535, 23, 0, 0),
         new FieldItem(ResourceField.TEXT15, FieldLocation.VAR_DATA, 0, 65535, 24, 0, 0),
         new FieldItem(ResourceField.TEXT16, FieldLocation.VAR_DATA, 0, 65535, 25, 0, 0),
         new FieldItem(ResourceField.TEXT17, FieldLocation.VAR_DATA, 0, 65535, 26, 0, 0),
         new FieldItem(ResourceField.TEXT18, FieldLocation.VAR_DATA, 0, 65535, 27, 0, 0),
         new FieldItem(ResourceField.TEXT19, FieldLocation.VAR_DATA, 0, 65535, 28, 0, 0),
         new FieldItem(ResourceField.TEXT20, FieldLocation.VAR_DATA, 0, 65535, 29, 0, 0),
         new FieldItem(ResourceField.TEXT21, FieldLocation.VAR_DATA, 0, 65535, 30, 0, 0),
         new FieldItem(ResourceField.TEXT22, FieldLocation.VAR_DATA, 0, 65535, 31, 0, 0),
         new FieldItem(ResourceField.TEXT23, FieldLocation.VAR_DATA, 0, 65535, 32, 0, 0),
         new FieldItem(ResourceField.TEXT24, FieldLocation.VAR_DATA, 0, 65535, 33, 0, 0),
         new FieldItem(ResourceField.TEXT25, FieldLocation.VAR_DATA, 0, 65535, 34, 0, 0),
         new FieldItem(ResourceField.TEXT26, FieldLocation.VAR_DATA, 0, 65535, 35, 0, 0),
         new FieldItem(ResourceField.TEXT27, FieldLocation.VAR_DATA, 0, 65535, 36, 0, 0),
         new FieldItem(ResourceField.TEXT28, FieldLocation.VAR_DATA, 0, 65535, 37, 0, 0),
         new FieldItem(ResourceField.TEXT29, FieldLocation.VAR_DATA, 0, 65535, 38, 0, 0),
         new FieldItem(ResourceField.TEXT30, FieldLocation.VAR_DATA, 0, 65535, 39, 0, 0),
         new FieldItem(ResourceField.START1, FieldLocation.VAR_DATA, 0, 65535, 40, 0, 0),
         new FieldItem(ResourceField.START2, FieldLocation.VAR_DATA, 0, 65535, 41, 0, 0),
         new FieldItem(ResourceField.START3, FieldLocation.VAR_DATA, 0, 65535, 42, 0, 0),
         new FieldItem(ResourceField.START4, FieldLocation.VAR_DATA, 0, 65535, 43, 0, 0),
         new FieldItem(ResourceField.START5, FieldLocation.VAR_DATA, 0, 65535, 44, 0, 0),
         new FieldItem(ResourceField.START6, FieldLocation.VAR_DATA, 0, 65535, 45, 0, 0),
         new FieldItem(ResourceField.START7, FieldLocation.VAR_DATA, 0, 65535, 46, 0, 0),
         new FieldItem(ResourceField.START8, FieldLocation.VAR_DATA, 0, 65535, 47, 0, 0),
         new FieldItem(ResourceField.START9, FieldLocation.VAR_DATA, 0, 65535, 48, 0, 0),
         new FieldItem(ResourceField.START10, FieldLocation.VAR_DATA, 0, 65535, 49, 0, 0),
         new FieldItem(ResourceField.FINISH1, FieldLocation.VAR_DATA, 0, 65535, 50, 0, 0),
         new FieldItem(ResourceField.FINISH2, FieldLocation.VAR_DATA, 0, 65535, 51, 0, 0),
         new FieldItem(ResourceField.FINISH3, FieldLocation.VAR_DATA, 0, 65535, 52, 0, 0),
         new FieldItem(ResourceField.FINISH4, FieldLocation.VAR_DATA, 0, 65535, 53, 0, 0),
         new FieldItem(ResourceField.FINISH5, FieldLocation.VAR_DATA, 0, 65535, 54, 0, 0),
         new FieldItem(ResourceField.FINISH6, FieldLocation.VAR_DATA, 0, 65535, 55, 0, 0),
         new FieldItem(ResourceField.FINISH7, FieldLocation.VAR_DATA, 0, 65535, 56, 0, 0),
         new FieldItem(ResourceField.FINISH8, FieldLocation.VAR_DATA, 0, 65535, 57, 0, 0),
         new FieldItem(ResourceField.FINISH9, FieldLocation.VAR_DATA, 0, 65535, 58, 0, 0),
         new FieldItem(ResourceField.FINISH10, FieldLocation.VAR_DATA, 0, 65535, 59, 0, 0),
         new FieldItem(ResourceField.NUMBER1, FieldLocation.VAR_DATA, 0, 65535, 60, 0, 0),
         new FieldItem(ResourceField.NUMBER2, FieldLocation.VAR_DATA, 0, 65535, 61, 0, 0),
         new FieldItem(ResourceField.NUMBER3, FieldLocation.VAR_DATA, 0, 65535, 62, 0, 0),
         new FieldItem(ResourceField.NUMBER4, FieldLocation.VAR_DATA, 0, 65535, 63, 0, 0),
         new FieldItem(ResourceField.NUMBER5, FieldLocation.VAR_DATA, 0, 65535, 64, 0, 0),
         new FieldItem(ResourceField.NUMBER6, FieldLocation.VAR_DATA, 0, 65535, 65, 0, 0),
         new FieldItem(ResourceField.NUMBER7, FieldLocation.VAR_DATA, 0, 65535, 66, 0, 0),
         new FieldItem(ResourceField.NUMBER8, FieldLocation.VAR_DATA, 0, 65535, 67, 0, 0),
         new FieldItem(ResourceField.NUMBER9, FieldLocation.VAR_DATA, 0, 65535, 68, 0, 0),
         new FieldItem(ResourceField.NUMBER10, FieldLocation.VAR_DATA, 0, 65535, 69, 0, 0),
         new FieldItem(ResourceField.NUMBER11, FieldLocation.VAR_DATA, 0, 65535, 70, 0, 0),
         new FieldItem(ResourceField.NUMBER12, FieldLocation.VAR_DATA, 0, 65535, 71, 0, 0),
         new FieldItem(ResourceField.NUMBER13, FieldLocation.VAR_DATA, 0, 65535, 72, 0, 0),
         new FieldItem(ResourceField.NUMBER14, FieldLocation.VAR_DATA, 0, 65535, 73, 0, 0),
         new FieldItem(ResourceField.NUMBER15, FieldLocation.VAR_DATA, 0, 65535, 74, 0, 0),
         new FieldItem(ResourceField.NUMBER16, FieldLocation.VAR_DATA, 0, 65535, 75, 0, 0),
         new FieldItem(ResourceField.NUMBER17, FieldLocation.VAR_DATA, 0, 65535, 76, 0, 0),
         new FieldItem(ResourceField.NUMBER18, FieldLocation.VAR_DATA, 0, 65535, 77, 0, 0),
         new FieldItem(ResourceField.NUMBER19, FieldLocation.VAR_DATA, 0, 65535, 78, 0, 0),
         new FieldItem(ResourceField.NUMBER20, FieldLocation.VAR_DATA, 0, 65535, 79, 0, 0),
         new FieldItem(ResourceField.DURATION1, FieldLocation.VAR_DATA, 0, 65535, 80, 0, 0),
         new FieldItem(ResourceField.DURATION2, FieldLocation.VAR_DATA, 0, 65535, 81, 0, 0),
         new FieldItem(ResourceField.DURATION3, FieldLocation.VAR_DATA, 0, 65535, 82, 0, 0),
         new FieldItem(ResourceField.DURATION4, FieldLocation.VAR_DATA, 0, 65535, 83, 0, 0),
         new FieldItem(ResourceField.DURATION5, FieldLocation.VAR_DATA, 0, 65535, 84, 0, 0),
         new FieldItem(ResourceField.DURATION6, FieldLocation.VAR_DATA, 0, 65535, 85, 0, 0),
         new FieldItem(ResourceField.DURATION7, FieldLocation.VAR_DATA, 0, 65535, 86, 0, 0),
         new FieldItem(ResourceField.DURATION8, FieldLocation.VAR_DATA, 0, 65535, 87, 0, 0),
         new FieldItem(ResourceField.DURATION9, FieldLocation.VAR_DATA, 0, 65535, 88, 0, 0),
         new FieldItem(ResourceField.DURATION10, FieldLocation.VAR_DATA, 0, 65535, 89, 0, 0),
         new FieldItem(ResourceField.DURATION1_UNITS, FieldLocation.VAR_DATA, 0, 65535, 90, 0, 0),
         new FieldItem(ResourceField.DURATION2_UNITS, FieldLocation.VAR_DATA, 0, 65535, 91, 0, 0),
         new FieldItem(ResourceField.DURATION3_UNITS, FieldLocation.VAR_DATA, 0, 65535, 92, 0, 0),
         new FieldItem(ResourceField.DURATION4_UNITS, FieldLocation.VAR_DATA, 0, 65535, 93, 0, 0),
         new FieldItem(ResourceField.DURATION5_UNITS, FieldLocation.VAR_DATA, 0, 65535, 94, 0, 0),
         new FieldItem(ResourceField.DURATION6_UNITS, FieldLocation.VAR_DATA, 0, 65535, 95, 0, 0),
         new FieldItem(ResourceField.DURATION7_UNITS, FieldLocation.VAR_DATA, 0, 65535, 96, 0, 0),
         new FieldItem(ResourceField.DURATION8_UNITS, FieldLocation.VAR_DATA, 0, 65535, 97, 0, 0),
         new FieldItem(ResourceField.DURATION9_UNITS, FieldLocation.VAR_DATA, 0, 65535, 98, 0, 0),
         new FieldItem(ResourceField.DURATION10_UNITS, FieldLocation.VAR_DATA, 0, 65535, 99, 0, 0),
         new FieldItem(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, FieldLocation.VAR_DATA, 0, 65535, 102, 0, 0),
         new FieldItem(ResourceField.DATE1, FieldLocation.VAR_DATA, 0, 65535, 103, 0, 0),
         new FieldItem(ResourceField.DATE2, FieldLocation.VAR_DATA, 0, 65535, 104, 0, 0),
         new FieldItem(ResourceField.DATE3, FieldLocation.VAR_DATA, 0, 65535, 105, 0, 0),
         new FieldItem(ResourceField.DATE4, FieldLocation.VAR_DATA, 0, 65535, 106, 0, 0),
         new FieldItem(ResourceField.DATE5, FieldLocation.VAR_DATA, 0, 65535, 107, 0, 0),
         new FieldItem(ResourceField.DATE6, FieldLocation.VAR_DATA, 0, 65535, 108, 0, 0),
         new FieldItem(ResourceField.DATE7, FieldLocation.VAR_DATA, 0, 65535, 109, 0, 0),
         new FieldItem(ResourceField.DATE8, FieldLocation.VAR_DATA, 0, 65535, 110, 0, 0),
         new FieldItem(ResourceField.DATE9, FieldLocation.VAR_DATA, 0, 65535, 111, 0, 0),
         new FieldItem(ResourceField.DATE10, FieldLocation.VAR_DATA, 0, 65535, 112, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE1_INDEX, FieldLocation.VAR_DATA, 0, 65535, 113, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE2_INDEX, FieldLocation.VAR_DATA, 0, 65535, 114, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE3_INDEX, FieldLocation.VAR_DATA, 0, 65535, 115, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE4_INDEX, FieldLocation.VAR_DATA, 0, 65535, 116, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE5_INDEX, FieldLocation.VAR_DATA, 0, 65535, 117, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE6_INDEX, FieldLocation.VAR_DATA, 0, 65535, 118, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE7_INDEX, FieldLocation.VAR_DATA, 0, 65535, 119, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE8_INDEX, FieldLocation.VAR_DATA, 0, 65535, 120, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE9_INDEX, FieldLocation.VAR_DATA, 0, 65535, 121, 0, 0),
         new FieldItem(ResourceField.OUTLINE_CODE10_INDEX, FieldLocation.VAR_DATA, 0, 65535, 122, 0, 0),
         new FieldItem(ResourceField.HYPERLINK_DATA, FieldLocation.VAR_DATA, 0, 65535, 123, 0, 0),
         new FieldItem(ResourceField.NOTES, FieldLocation.VAR_DATA, 0, 65535, 124, 0, 0),
         new FieldItem(ResourceField.COST1, FieldLocation.VAR_DATA, 0, 65535, 125, 0, 0),
         new FieldItem(ResourceField.COST2, FieldLocation.VAR_DATA, 0, 65535, 126, 0, 0),
         new FieldItem(ResourceField.COST3, FieldLocation.VAR_DATA, 0, 65535, 127, 0, 0),
         new FieldItem(ResourceField.COST4, FieldLocation.VAR_DATA, 0, 65535, 128, 0, 0),
         new FieldItem(ResourceField.COST5, FieldLocation.VAR_DATA, 0, 65535, 129, 0, 0),
         new FieldItem(ResourceField.COST6, FieldLocation.VAR_DATA, 0, 65535, 130, 0, 0),
         new FieldItem(ResourceField.COST7, FieldLocation.VAR_DATA, 0, 65535, 131, 0, 0),
         new FieldItem(ResourceField.COST8, FieldLocation.VAR_DATA, 0, 65535, 132, 0, 0),
         new FieldItem(ResourceField.COST9, FieldLocation.VAR_DATA, 0, 65535, 133, 0, 0),
         new FieldItem(ResourceField.COST10, FieldLocation.VAR_DATA, 0, 65535, 134, 0, 0),
         new FieldItem(ResourceField.COST_RATE_A, FieldLocation.VAR_DATA, 0, 65535, 135, 0, 0),
         new FieldItem(ResourceField.COST_RATE_B, FieldLocation.VAR_DATA, 0, 65535, 136, 0, 0),
         new FieldItem(ResourceField.COST_RATE_C, FieldLocation.VAR_DATA, 0, 65535, 137, 0, 0),
         new FieldItem(ResourceField.COST_RATE_D, FieldLocation.VAR_DATA, 0, 65535, 138, 0, 0),
         new FieldItem(ResourceField.COST_RATE_E, FieldLocation.VAR_DATA, 0, 65535, 139, 0, 0),
         new FieldItem(ResourceField.AVAILABILITY_DATA, FieldLocation.VAR_DATA, 0, 65535, 142, 0, 0),
         new FieldItem(ResourceField.ENTERPRISE_DATA, FieldLocation.VAR_DATA, 0, 65535, 143, 0, 0),
         new FieldItem(ResourceField.BASELINE1_WORK, FieldLocation.VAR_DATA, 0, 65535, 144, 0, 0),
         new FieldItem(ResourceField.BASELINE1_COST, FieldLocation.VAR_DATA, 0, 65535, 145, 0, 0),
         new FieldItem(ResourceField.BASELINE2_WORK, FieldLocation.VAR_DATA, 0, 65535, 148, 0, 0),
         new FieldItem(ResourceField.BASELINE2_COST, FieldLocation.VAR_DATA, 0, 65535, 149, 0, 0),
         new FieldItem(ResourceField.BASELINE3_WORK, FieldLocation.VAR_DATA, 0, 65535, 152, 0, 0),
         new FieldItem(ResourceField.BASELINE3_COST, FieldLocation.VAR_DATA, 0, 65535, 153, 0, 0),
         new FieldItem(ResourceField.BASELINE4_WORK, FieldLocation.VAR_DATA, 0, 65535, 156, 0, 0),
         new FieldItem(ResourceField.BASELINE4_COST, FieldLocation.VAR_DATA, 0, 65535, 157, 0, 0),
         new FieldItem(ResourceField.BASELINE5_WORK, FieldLocation.VAR_DATA, 0, 65535, 160, 0, 0),
         new FieldItem(ResourceField.BASELINE5_COST, FieldLocation.VAR_DATA, 0, 65535, 161, 0, 0),
         new FieldItem(ResourceField.BASELINE6_WORK, FieldLocation.VAR_DATA, 0, 65535, 164, 0, 0),
         new FieldItem(ResourceField.BASELINE6_COST, FieldLocation.VAR_DATA, 0, 65535, 165, 0, 0),
         new FieldItem(ResourceField.BASELINE7_WORK, FieldLocation.VAR_DATA, 0, 65535, 168, 0, 0),
         new FieldItem(ResourceField.BASELINE7_COST, FieldLocation.VAR_DATA, 0, 65535, 169, 0, 0),
         new FieldItem(ResourceField.BASELINE8_WORK, FieldLocation.VAR_DATA, 0, 65535, 172, 0, 0),
         new FieldItem(ResourceField.BASELINE8_COST, FieldLocation.VAR_DATA, 0, 65535, 173, 0, 0),
         new FieldItem(ResourceField.BASELINE9_WORK, FieldLocation.VAR_DATA, 0, 65535, 176, 0, 0),
         new FieldItem(ResourceField.BASELINE9_COST, FieldLocation.VAR_DATA, 0, 65535, 177, 0, 0),
         new FieldItem(ResourceField.BASELINE10_WORK, FieldLocation.VAR_DATA, 0, 65535, 180, 0, 0),
         new FieldItem(ResourceField.BASELINE10_COST, FieldLocation.VAR_DATA, 0, 65535, 181, 0, 0),
         new FieldItem(ResourceField.ENTERPRISE_UNIQUE_ID, FieldLocation.VAR_DATA, 0, 65535, 185, 0, 0)
      };

      return result;
   }

   /**
    * {@inheritDoc}
    */
   @Override protected FieldItem[] getDefaultAssignmentData()
   {
      FieldItem[] result = new FieldItem[]
      {
         new FieldItem(AssignmentField.UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 0, 0, 0, 0),
         new FieldItem(AssignmentField.TASK_UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 4, 0, 0, 0),
         new FieldItem(AssignmentField.RESOURCE_UNIQUE_ID, FieldLocation.FIXED_DATA, 0, 8, 0, 0, 0),
         new FieldItem(AssignmentField.START, FieldLocation.FIXED_DATA, 0, 12, 0, 0, 0),
         new FieldItem(AssignmentField.FINISH, FieldLocation.FIXED_DATA, 0, 16, 0, 0, 0),
         new FieldItem(AssignmentField.ASSIGNMENT_DELAY, FieldLocation.FIXED_DATA, 0, 24, 0, 0, 0),
         new FieldItem(AssignmentField.LEVELING_DELAY_UNITS, FieldLocation.FIXED_DATA, 0, 28, 0, 0, 0),
         new FieldItem(AssignmentField.LEVELING_DELAY, FieldLocation.FIXED_DATA, 0, 30, 0, 0, 0),
         new FieldItem(AssignmentField.COST_RATE_TABLE, FieldLocation.FIXED_DATA, 0, 34, 0, 0, 0),
         new FieldItem(AssignmentField.BASELINE_START, FieldLocation.FIXED_DATA, 0, 36, 0, 0, 0),
         new FieldItem(AssignmentField.BASELINE_FINISH, FieldLocation.FIXED_DATA, 0, 40, 0, 0, 0),
         new FieldItem(AssignmentField.VARIABLE_RATE_UNITS, FieldLocation.FIXED_DATA, 0, 52, 0, 0, 0),
         new FieldItem(AssignmentField.ASSIGNMENT_UNITS, FieldLocation.FIXED_DATA, 0, 54, 0, 0, 0),
         new FieldItem(AssignmentField.WORK, FieldLocation.FIXED_DATA, 0, 62, 0, 0, 0),
         new FieldItem(AssignmentField.ACTUAL_WORK, FieldLocation.FIXED_DATA, 0, 70, 0, 0, 0),
         new FieldItem(AssignmentField.REGULAR_WORK, FieldLocation.FIXED_DATA, 0, 78, 0, 0, 0),
         new FieldItem(AssignmentField.REMAINING_WORK, FieldLocation.FIXED_DATA, 0, 86, 0, 0, 0),
         new FieldItem(AssignmentField.BASELINE_WORK, FieldLocation.FIXED_DATA, 0, 94, 0, 0, 0),
         new FieldItem(AssignmentField.COST, FieldLocation.FIXED_DATA, 0, 102, 0, 0, 0),
         new FieldItem(AssignmentField.ACTUAL_COST, FieldLocation.FIXED_DATA, 0, 110, 0, 0, 0),
         new FieldItem(AssignmentField.REMAINING_COST, FieldLocation.FIXED_DATA, 0, 118, 0, 0, 0),
         new FieldItem(AssignmentField.BASELINE_COST, FieldLocation.FIXED_DATA, 0, 126, 0, 0, 0),
         new FieldItem(AssignmentField.OVERTIME_WORK, FieldLocation.VAR_DATA, 0, 65535, 1, 0, 0),
         new FieldItem(AssignmentField.ACTUAL_OVERTIME_WORK, FieldLocation.VAR_DATA, 0, 65535, 2, 0, 0),
         new FieldItem(AssignmentField.REMAINING_OVERTIME_WORK, FieldLocation.VAR_DATA, 0, 65535, 3, 0, 0),
         new FieldItem(AssignmentField.ACTUAL_OVERTIME_COST, FieldLocation.VAR_DATA, 0, 65535, 4, 0, 0),
         new FieldItem(AssignmentField.REMAINING_OVERTIME_COST, FieldLocation.VAR_DATA, 0, 65535, 5, 0, 0),
         new FieldItem(AssignmentField.NOTES, FieldLocation.VAR_DATA, 0, 65535, 6, 0, 0),
         new FieldItem(AssignmentField.TIMEPHASED_WORK, FieldLocation.VAR_DATA, 0, 65535, 7, 0, 0),
         new FieldItem(AssignmentField.TIMEPHASED_ACTUAL_WORK, FieldLocation.VAR_DATA, 0, 65535, 9, 0, 0),
         new FieldItem(AssignmentField.TEXT1, FieldLocation.VAR_DATA, 0, 65535, 15, 0, 0),
         new FieldItem(AssignmentField.TEXT2, FieldLocation.VAR_DATA, 0, 65535, 16, 0, 0),
         new FieldItem(AssignmentField.TEXT3, FieldLocation.VAR_DATA, 0, 65535, 17, 0, 0),
         new FieldItem(AssignmentField.TEXT4, FieldLocation.VAR_DATA, 0, 65535, 18, 0, 0),
         new FieldItem(AssignmentField.TEXT5, FieldLocation.VAR_DATA, 0, 65535, 19, 0, 0),
         new FieldItem(AssignmentField.TEXT6, FieldLocation.VAR_DATA, 0, 65535, 20, 0, 0),
         new FieldItem(AssignmentField.TEXT7, FieldLocation.VAR_DATA, 0, 65535, 21, 0, 0),
         new FieldItem(AssignmentField.TEXT8, FieldLocation.VAR_DATA, 0, 65535, 22, 0, 0),
         new FieldItem(AssignmentField.TEXT9, FieldLocation.VAR_DATA, 0, 65535, 23, 0, 0),
         new FieldItem(AssignmentField.TEXT10, FieldLocation.VAR_DATA, 0, 65535, 24, 0, 0),
         new FieldItem(AssignmentField.TEXT11, FieldLocation.VAR_DATA, 0, 65535, 25, 0, 0),
         new FieldItem(AssignmentField.TEXT12, FieldLocation.VAR_DATA, 0, 65535, 26, 0, 0),
         new FieldItem(AssignmentField.TEXT13, FieldLocation.VAR_DATA, 0, 65535, 27, 0, 0),
         new FieldItem(AssignmentField.TEXT14, FieldLocation.VAR_DATA, 0, 65535, 28, 0, 0),
         new FieldItem(AssignmentField.TEXT15, FieldLocation.VAR_DATA, 0, 65535, 29, 0, 0),
         new FieldItem(AssignmentField.TEXT16, FieldLocation.VAR_DATA, 0, 65535, 30, 0, 0),
         new FieldItem(AssignmentField.TEXT17, FieldLocation.VAR_DATA, 0, 65535, 31, 0, 0),
         new FieldItem(AssignmentField.TEXT18, FieldLocation.VAR_DATA, 0, 65535, 32, 0, 0),
         new FieldItem(AssignmentField.TEXT19, FieldLocation.VAR_DATA, 0, 65535, 33, 0, 0),
         new FieldItem(AssignmentField.TEXT20, FieldLocation.VAR_DATA, 0, 65535, 34, 0, 0),
         new FieldItem(AssignmentField.TEXT21, FieldLocation.VAR_DATA, 0, 65535, 35, 0, 0),
         new FieldItem(AssignmentField.TEXT22, FieldLocation.VAR_DATA, 0, 65535, 36, 0, 0),
         new FieldItem(AssignmentField.TEXT23, FieldLocation.VAR_DATA, 0, 65535, 37, 0, 0),
         new FieldItem(AssignmentField.TEXT24, FieldLocation.VAR_DATA, 0, 65535, 38, 0, 0),
         new FieldItem(AssignmentField.TEXT25, FieldLocation.VAR_DATA, 0, 65535, 39, 0, 0),
         new FieldItem(AssignmentField.TEXT26, FieldLocation.VAR_DATA, 0, 65535, 40, 0, 0),
         new FieldItem(AssignmentField.TEXT27, FieldLocation.VAR_DATA, 0, 65535, 41, 0, 0),
         new FieldItem(AssignmentField.TEXT28, FieldLocation.VAR_DATA, 0, 65535, 42, 0, 0),
         new FieldItem(AssignmentField.TEXT29, FieldLocation.VAR_DATA, 0, 65535, 43, 0, 0),
         new FieldItem(AssignmentField.TEXT30, FieldLocation.VAR_DATA, 0, 65535, 44, 0, 0),
         new FieldItem(AssignmentField.START1, FieldLocation.VAR_DATA, 0, 65535, 45, 0, 0),
         new FieldItem(AssignmentField.START2, FieldLocation.VAR_DATA, 0, 65535, 46, 0, 0),
         new FieldItem(AssignmentField.START3, FieldLocation.VAR_DATA, 0, 65535, 47, 0, 0),
         new FieldItem(AssignmentField.START4, FieldLocation.VAR_DATA, 0, 65535, 48, 0, 0),
         new FieldItem(AssignmentField.START5, FieldLocation.VAR_DATA, 0, 65535, 49, 0, 0),
         new FieldItem(AssignmentField.START6, FieldLocation.VAR_DATA, 0, 65535, 50, 0, 0),
         new FieldItem(AssignmentField.START7, FieldLocation.VAR_DATA, 0, 65535, 51, 0, 0),
         new FieldItem(AssignmentField.START8, FieldLocation.VAR_DATA, 0, 65535, 52, 0, 0),
         new FieldItem(AssignmentField.START9, FieldLocation.VAR_DATA, 0, 65535, 53, 0, 0),
         new FieldItem(AssignmentField.START10, FieldLocation.VAR_DATA, 0, 65535, 54, 0, 0),
         new FieldItem(AssignmentField.FINISH1, FieldLocation.VAR_DATA, 0, 65535, 55, 0, 0),
         new FieldItem(AssignmentField.FINISH2, FieldLocation.VAR_DATA, 0, 65535, 56, 0, 0),
         new FieldItem(AssignmentField.FINISH3, FieldLocation.VAR_DATA, 0, 65535, 57, 0, 0),
         new FieldItem(AssignmentField.FINISH4, FieldLocation.VAR_DATA, 0, 65535, 58, 0, 0),
         new FieldItem(AssignmentField.FINISH5, FieldLocation.VAR_DATA, 0, 65535, 59, 0, 0),
         new FieldItem(AssignmentField.FINISH6, FieldLocation.VAR_DATA, 0, 65535, 60, 0, 0),
         new FieldItem(AssignmentField.FINISH7, FieldLocation.VAR_DATA, 0, 65535, 61, 0, 0),
         new FieldItem(AssignmentField.FINISH8, FieldLocation.VAR_DATA, 0, 65535, 62, 0, 0),
         new FieldItem(AssignmentField.FINISH9, FieldLocation.VAR_DATA, 0, 65535, 63, 0, 0),
         new FieldItem(AssignmentField.FINISH10, FieldLocation.VAR_DATA, 0, 65535, 64, 0, 0),
         new FieldItem(AssignmentField.NUMBER1, FieldLocation.VAR_DATA, 0, 65535, 65, 0, 0),
         new FieldItem(AssignmentField.NUMBER2, FieldLocation.VAR_DATA, 0, 65535, 66, 0, 0),
         new FieldItem(AssignmentField.NUMBER3, FieldLocation.VAR_DATA, 0, 65535, 67, 0, 0),
         new FieldItem(AssignmentField.NUMBER4, FieldLocation.VAR_DATA, 0, 65535, 68, 0, 0),
         new FieldItem(AssignmentField.NUMBER5, FieldLocation.VAR_DATA, 0, 65535, 69, 0, 0),
         new FieldItem(AssignmentField.NUMBER6, FieldLocation.VAR_DATA, 0, 65535, 70, 0, 0),
         new FieldItem(AssignmentField.NUMBER7, FieldLocation.VAR_DATA, 0, 65535, 71, 0, 0),
         new FieldItem(AssignmentField.NUMBER8, FieldLocation.VAR_DATA, 0, 65535, 72, 0, 0),
         new FieldItem(AssignmentField.NUMBER9, FieldLocation.VAR_DATA, 0, 65535, 73, 0, 0),
         new FieldItem(AssignmentField.NUMBER10, FieldLocation.VAR_DATA, 0, 65535, 74, 0, 0),
         new FieldItem(AssignmentField.NUMBER11, FieldLocation.VAR_DATA, 0, 65535, 75, 0, 0),
         new FieldItem(AssignmentField.NUMBER12, FieldLocation.VAR_DATA, 0, 65535, 76, 0, 0),
         new FieldItem(AssignmentField.NUMBER13, FieldLocation.VAR_DATA, 0, 65535, 77, 0, 0),
         new FieldItem(AssignmentField.NUMBER14, FieldLocation.VAR_DATA, 0, 65535, 78, 0, 0),
         new FieldItem(AssignmentField.NUMBER15, FieldLocation.VAR_DATA, 0, 65535, 79, 0, 0),
         new FieldItem(AssignmentField.NUMBER16, FieldLocation.VAR_DATA, 0, 65535, 80, 0, 0),
         new FieldItem(AssignmentField.NUMBER17, FieldLocation.VAR_DATA, 0, 65535, 81, 0, 0),
         new FieldItem(AssignmentField.NUMBER18, FieldLocation.VAR_DATA, 0, 65535, 82, 0, 0),
         new FieldItem(AssignmentField.NUMBER19, FieldLocation.VAR_DATA, 0, 65535, 83, 0, 0),
         new FieldItem(AssignmentField.NUMBER20, FieldLocation.VAR_DATA, 0, 65535, 84, 0, 0),
         new FieldItem(AssignmentField.DURATION1, FieldLocation.VAR_DATA, 0, 65535, 85, 0, 0),
         new FieldItem(AssignmentField.DURATION2, FieldLocation.VAR_DATA, 0, 65535, 86, 0, 0),
         new FieldItem(AssignmentField.DURATION3, FieldLocation.VAR_DATA, 0, 65535, 87, 0, 0),
         new FieldItem(AssignmentField.DURATION4, FieldLocation.VAR_DATA, 0, 65535, 88, 0, 0),
         new FieldItem(AssignmentField.DURATION5, FieldLocation.VAR_DATA, 0, 65535, 89, 0, 0),
         new FieldItem(AssignmentField.DURATION6, FieldLocation.VAR_DATA, 0, 65535, 90, 0, 0),
         new FieldItem(AssignmentField.DURATION7, FieldLocation.VAR_DATA, 0, 65535, 91, 0, 0),
         new FieldItem(AssignmentField.DURATION8, FieldLocation.VAR_DATA, 0, 65535, 92, 0, 0),
         new FieldItem(AssignmentField.DURATION9, FieldLocation.VAR_DATA, 0, 65535, 93, 0, 0),
         new FieldItem(AssignmentField.DURATION10, FieldLocation.VAR_DATA, 0, 65535, 94, 0, 0),
         new FieldItem(AssignmentField.DATE1, FieldLocation.VAR_DATA, 0, 65535, 108, 0, 0),
         new FieldItem(AssignmentField.DATE2, FieldLocation.VAR_DATA, 0, 65535, 109, 0, 0),
         new FieldItem(AssignmentField.DATE3, FieldLocation.VAR_DATA, 0, 65535, 110, 0, 0),
         new FieldItem(AssignmentField.DATE4, FieldLocation.VAR_DATA, 0, 65535, 111, 0, 0),
         new FieldItem(AssignmentField.DATE5, FieldLocation.VAR_DATA, 0, 65535, 112, 0, 0),
         new FieldItem(AssignmentField.DATE6, FieldLocation.VAR_DATA, 0, 65535, 113, 0, 0),
         new FieldItem(AssignmentField.DATE7, FieldLocation.VAR_DATA, 0, 65535, 114, 0, 0),
         new FieldItem(AssignmentField.DATE8, FieldLocation.VAR_DATA, 0, 65535, 115, 0, 0),
         new FieldItem(AssignmentField.DATE9, FieldLocation.VAR_DATA, 0, 65535, 116, 0, 0),
         new FieldItem(AssignmentField.DATE10, FieldLocation.VAR_DATA, 0, 65535, 117, 0, 0),
         new FieldItem(AssignmentField.COST1, FieldLocation.VAR_DATA, 0, 65535, 128, 0, 0),
         new FieldItem(AssignmentField.COST2, FieldLocation.VAR_DATA, 0, 65535, 129, 0, 0),
         new FieldItem(AssignmentField.COST3, FieldLocation.VAR_DATA, 0, 65535, 130, 0, 0),
         new FieldItem(AssignmentField.COST4, FieldLocation.VAR_DATA, 0, 65535, 131, 0, 0),
         new FieldItem(AssignmentField.COST5, FieldLocation.VAR_DATA, 0, 65535, 132, 0, 0),
         new FieldItem(AssignmentField.COST6, FieldLocation.VAR_DATA, 0, 65535, 133, 0, 0),
         new FieldItem(AssignmentField.COST7, FieldLocation.VAR_DATA, 0, 65535, 134, 0, 0),
         new FieldItem(AssignmentField.COST8, FieldLocation.VAR_DATA, 0, 65535, 135, 0, 0),
         new FieldItem(AssignmentField.COST9, FieldLocation.VAR_DATA, 0, 65535, 136, 0, 0),
         new FieldItem(AssignmentField.COST10, FieldLocation.VAR_DATA, 0, 65535, 137, 0, 0),
         new FieldItem(AssignmentField.BASELINE1_START, FieldLocation.VAR_DATA, 0, 65535, 140, 0, 0),
         new FieldItem(AssignmentField.BASELINE1_FINISH, FieldLocation.VAR_DATA, 0, 65535, 141, 0, 0),
         new FieldItem(AssignmentField.BASELINE1_WORK, FieldLocation.VAR_DATA, 0, 65535, 142, 0, 0),
         new FieldItem(AssignmentField.BASELINE1_COST, FieldLocation.VAR_DATA, 0, 65535, 143, 0, 0),
         new FieldItem(AssignmentField.BASELINE2_START, FieldLocation.VAR_DATA, 0, 65535, 148, 0, 0),
         new FieldItem(AssignmentField.BASELINE2_FINISH, FieldLocation.VAR_DATA, 0, 65535, 149, 0, 0),
         new FieldItem(AssignmentField.BASELINE2_WORK, FieldLocation.VAR_DATA, 0, 65535, 150, 0, 0),
         new FieldItem(AssignmentField.BASELINE2_COST, FieldLocation.VAR_DATA, 0, 65535, 151, 0, 0),
         new FieldItem(AssignmentField.BASELINE3_START, FieldLocation.VAR_DATA, 0, 65535, 156, 0, 0),
         new FieldItem(AssignmentField.BASELINE3_FINISH, FieldLocation.VAR_DATA, 0, 65535, 157, 0, 0),
         new FieldItem(AssignmentField.BASELINE3_WORK, FieldLocation.VAR_DATA, 0, 65535, 158, 0, 0),
         new FieldItem(AssignmentField.BASELINE3_COST, FieldLocation.VAR_DATA, 0, 65535, 159, 0, 0),
         new FieldItem(AssignmentField.BASELINE4_START, FieldLocation.VAR_DATA, 0, 65535, 164, 0, 0),
         new FieldItem(AssignmentField.BASELINE4_FINISH, FieldLocation.VAR_DATA, 0, 65535, 165, 0, 0),
         new FieldItem(AssignmentField.BASELINE4_WORK, FieldLocation.VAR_DATA, 0, 65535, 166, 0, 0),
         new FieldItem(AssignmentField.BASELINE4_COST, FieldLocation.VAR_DATA, 0, 65535, 167, 0, 0),
         new FieldItem(AssignmentField.BASELINE5_START, FieldLocation.VAR_DATA, 0, 65535, 172, 0, 0),
         new FieldItem(AssignmentField.BASELINE5_FINISH, FieldLocation.VAR_DATA, 0, 65535, 173, 0, 0),
         new FieldItem(AssignmentField.BASELINE5_WORK, FieldLocation.VAR_DATA, 0, 65535, 174, 0, 0),
         new FieldItem(AssignmentField.BASELINE5_COST, FieldLocation.VAR_DATA, 0, 65535, 175, 0, 0),
         new FieldItem(AssignmentField.BASELINE6_START, FieldLocation.VAR_DATA, 0, 65535, 180, 0, 0),
         new FieldItem(AssignmentField.BASELINE6_FINISH, FieldLocation.VAR_DATA, 0, 65535, 181, 0, 0),
         new FieldItem(AssignmentField.BASELINE6_WORK, FieldLocation.VAR_DATA, 0, 65535, 182, 0, 0),
         new FieldItem(AssignmentField.BASELINE6_COST, FieldLocation.VAR_DATA, 0, 65535, 183, 0, 0),
         new FieldItem(AssignmentField.BASELINE7_START, FieldLocation.VAR_DATA, 0, 65535, 188, 0, 0),
         new FieldItem(AssignmentField.BASELINE7_FINISH, FieldLocation.VAR_DATA, 0, 65535, 189, 0, 0),
         new FieldItem(AssignmentField.BASELINE7_WORK, FieldLocation.VAR_DATA, 0, 65535, 190, 0, 0),
         new FieldItem(AssignmentField.BASELINE7_COST, FieldLocation.VAR_DATA, 0, 65535, 191, 0, 0),
         new FieldItem(AssignmentField.BASELINE8_START, FieldLocation.VAR_DATA, 0, 65535, 196, 0, 0),
         new FieldItem(AssignmentField.BASELINE8_FINISH, FieldLocation.VAR_DATA, 0, 65535, 197, 0, 0),
         new FieldItem(AssignmentField.BASELINE8_WORK, FieldLocation.VAR_DATA, 0, 65535, 198, 0, 0),
         new FieldItem(AssignmentField.BASELINE8_COST, FieldLocation.VAR_DATA, 0, 65535, 199, 0, 0),
         new FieldItem(AssignmentField.BASELINE9_START, FieldLocation.VAR_DATA, 0, 65535, 204, 0, 0),
         new FieldItem(AssignmentField.BASELINE9_FINISH, FieldLocation.VAR_DATA, 0, 65535, 205, 0, 0),
         new FieldItem(AssignmentField.BASELINE9_WORK, FieldLocation.VAR_DATA, 0, 65535, 206, 0, 0),
         new FieldItem(AssignmentField.BASELINE9_COST, FieldLocation.VAR_DATA, 0, 65535, 207, 0, 0),
         new FieldItem(AssignmentField.BASELINE10_START, FieldLocation.VAR_DATA, 0, 65535, 212, 0, 0),
         new FieldItem(AssignmentField.BASELINE10_FINISH, FieldLocation.VAR_DATA, 0, 65535, 213, 0, 0),
         new FieldItem(AssignmentField.BASELINE10_WORK, FieldLocation.VAR_DATA, 0, 65535, 214, 0, 0),
         new FieldItem(AssignmentField.BASELINE10_COST, FieldLocation.VAR_DATA, 0, 65535, 215, 0, 0)
      };
      return result;
   }

   /**
    * {@inheritDoc}
    */
   @Override protected FieldItem[] getDefaultRelationData()
   {
      return new FieldItem[0];
   }
}
