/*
 * file:       ObjectPropertiesPanel.java
 * author:     Jon Iles
 * copyright:  (c) Packwood Software 2014
 * date:       16/07/2014
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

package net.sf.mpxj.explorer;

import java.awt.GridLayout;

import javax.swing.JPanel;

/**
 * This panel represents a Java object as a set of properties.
 * The properties are displayed in a table with the property names
 * in the first column, and the property values in the second column.
 */
public class ObjectPropertiesPanel extends JPanel
{
   private ObjectPropertiesModel m_objectPropertiesModel;
   private ObjectPropertiesController m_objectPropertiesController;
   private ObjectPropertiesView m_objectPropertiesView;

   /**
    * Constructor.
    *
    * @param object the object whose properties we will display
    */
   public ObjectPropertiesPanel(Object object)
   {
      setLayout(new GridLayout(0, 1, 0, 0));

      m_objectPropertiesModel = new ObjectPropertiesModel();
      m_objectPropertiesController = new ObjectPropertiesController(m_objectPropertiesModel);
      m_objectPropertiesView = new ObjectPropertiesView(m_objectPropertiesModel);

      add(m_objectPropertiesView);

      m_objectPropertiesController.loadObject(object);
   }
}
