/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.parts.subreport;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.BookmarkHelper;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.fill.AbstractVariableReturnValueSourceContext;
import net.sf.jasperreports.engine.fill.BandReportFillerParent;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.FillReturnValues;
import net.sf.jasperreports.engine.fill.FillerPageAddedEvent;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.PartPropertiesDetector;
import net.sf.jasperreports.engine.fill.PartReportFiller;
import net.sf.jasperreports.engine.part.BasePartFillComponent;
import net.sf.jasperreports.engine.part.FillingPrintPart;
import net.sf.jasperreports.engine.part.PartPrintOutput;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.util.BookmarksFlatDataSource;
import net.sf.jasperreports.parts.PartFillerParent;
import net.sf.jasperreports.parts.subreport.PrintPartCreator;
import net.sf.jasperreports.parts.subreport.SubreportPartComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubreportFillPart
extends BasePartFillComponent {
    private static final Log log = LogFactory.getLog(SubreportFillPart.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_PRINT_ORDER = "parts.subreport.unknown.report.print.order";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE = "parts.subreport.unknown.report.section.type";
    public static final String PROPERTY_BOOKMARKS_DATA_SOURCE_PARAMETER = "net.sf.jasperreports.bookmarks.data.source.parameter";
    private SubreportPartComponent subreportPart;
    private JRFillExpressionEvaluator expressionEvaluator;
    private FillReturnValues returnValues;
    private FillReturnValues.SourceContext returnValuesSource;
    private Object reportSource;
    private JasperReportSource jasperReportSource;
    private Map<String, Object> parameterValues;
    private FillDatasetPosition datasetPosition;
    private boolean cacheIncluded;
    private volatile BaseReportFiller subreportFiller;

    public SubreportFillPart(SubreportPartComponent subreportPart, JRFillObjectFactory factory) {
        this.subreportPart = subreportPart;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.returnValues = new FillReturnValues(subreportPart.getReturnValues(), factory, factory.getReportFiller());
        this.returnValuesSource = new AbstractVariableReturnValueSourceContext(){

            @Override
            public Object getValue(CommonReturnValue returnValue) {
                return SubreportFillPart.this.subreportFiller.getVariableValue(((VariableReturnValue)returnValue).getFromVariable());
            }

            @Override
            public JRFillVariable getToVariable(String name) {
                return SubreportFillPart.this.fillContext.getFiller().getVariable(name);
            }

            @Override
            public JRVariable getFromVariable(String name) {
                return SubreportFillPart.this.subreportFiller.getVariable(name);
            }
        };
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        this.jasperReportSource = this.evaluateReportSource(evaluation);
        JRFillDataset parentDataset = this.expressionEvaluator.getFillDataset();
        this.datasetPosition = new FillDatasetPosition(parentDataset.getFillPosition());
        this.datasetPosition.addAttribute("subreportPartUUID", this.fillContext.getPart().getUUID());
        parentDataset.setCacheRecordIndex(this.datasetPosition, evaluation);
        String cacheIncludedProp = JRPropertiesUtil.getOwnProperty(this.fillContext.getPart(), "net.sf.jasperreports.data.cache.included");
        this.cacheIncluded = JRPropertiesUtil.asBoolean(cacheIncludedProp, true);
        JasperReport jasperReport = this.getReport();
        this.parameterValues = JRFillSubreport.getParameterValues(this.fillContext.getFiller(), this.expressionEvaluator, this.subreportPart.getParametersMapExpression(), this.subreportPart.getParameters(), evaluation, false, jasperReport.getResourceBundle() != null, jasperReport.getFormatFactoryClass() != null);
        this.setBookmarksParameter();
    }

    private JasperReportSource evaluateReportSource(byte evaluation) throws JRException {
        this.reportSource = this.fillContext.evaluate(this.subreportPart.getExpression(), evaluation);
        return JRFillSubreport.getReportSource(this.reportSource, this.subreportPart.getUsingCache(), this.fillContext.getFiller());
    }

    private JasperReport getReport() {
        return this.jasperReportSource == null ? null : this.jasperReportSource.getReport();
    }

    private void setBookmarksParameter() {
        String bookmarksParameter;
        JRPart part = this.fillContext.getPart();
        String string = bookmarksParameter = part.hasProperties() ? part.getPropertiesMap().getProperty(PROPERTY_BOOKMARKS_DATA_SOURCE_PARAMETER) : null;
        if (bookmarksParameter == null) {
            return;
        }
        if (bookmarksParameter.equals("REPORT_DATA_SOURCE")) {
            this.cacheIncluded = false;
        }
        BookmarkHelper bookmarks = this.fillContext.getFiller().getFirstBookmarkHelper();
        BookmarksFlatDataSource bookmarksDataSource = new BookmarksFlatDataSource(bookmarks);
        this.parameterValues.put(bookmarksParameter, bookmarksDataSource);
    }

    @Override
    public void fill(PartPrintOutput output) throws JRException {
        this.subreportFiller = this.createSubreportFiller(output);
        this.returnValues.checkReturnValues(this.returnValuesSource);
        JRFillDataset subreportDataset = this.subreportFiller.getMainDataset();
        subreportDataset.setFillPosition(this.datasetPosition);
        subreportDataset.setCacheSkipped(!this.cacheIncluded);
        this.subreportFiller.fill(this.parameterValues);
        this.returnValues.copyValues(this.returnValuesSource);
    }

    protected BaseReportFiller createSubreportFiller(PartPrintOutput output) throws JRException {
        BaseReportFiller filler;
        SectionTypeEnum sectionType = SectionTypeEnum.getValueOrDefault(this.getReport().getSectionType());
        switch (sectionType) {
            case BAND: {
                filler = this.createBandSubfiller(output);
                break;
            }
            case PART: {
                filler = this.createPartSubfiller(output);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE, sectionType);
            }
        }
        return filler;
    }

    protected JRBaseFiller createBandSubfiller(final PartPrintOutput output) throws JRException {
        JRBaseFiller bandFiller;
        PartBandParent bandParent = new PartBandParent(output);
        JasperReport jasperReport = this.getReport();
        PrintOrderEnum printOrder = PrintOrderEnum.getValueOrDefault(jasperReport.getPrintOrder());
        switch (printOrder) {
            case HORIZONTAL: {
                bandFiller = new JRHorizontalFiller(this.getJasperReportsContext(), this.jasperReportSource, (BandReportFillerParent)bandParent);
                break;
            }
            case VERTICAL: {
                bandFiller = new JRVerticalFiller(this.getJasperReportsContext(), this.jasperReportSource, (BandReportFillerParent)bandParent);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_PRINT_ORDER, printOrder);
            }
        }
        bandFiller.addFillListener(new FillListener(){

            @Override
            public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
            }

            @Override
            public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
                output.pageUpdated(pageIndex);
            }
        });
        return bandFiller;
    }

    protected BaseReportFiller createPartSubfiller(PartPrintOutput output) throws JRException {
        PartParent partParent = new PartParent(output);
        PartReportFiller partFiller = new PartReportFiller(this.getJasperReportsContext(), this.jasperReportSource, (PartFillerParent)partParent);
        return partFiller;
    }

    protected String getPartName() {
        return this.fillContext.getFillPart().getPartName();
    }

    protected JRPropertiesHolder getPrintPartProperties() {
        return this.fillContext.getFillPart().getPrintPartProperties();
    }

    protected class PartParent
    implements PartFillerParent {
        private PartPrintOutput output;

        public PartParent(PartPrintOutput output) {
            this.output = output;
        }

        @Override
        public PartReportFiller getFiller() {
            return SubreportFillPart.this.fillContext.getFiller();
        }

        @Override
        public JRPropertiesHolder getParentProperties() {
            return null;
        }

        @Override
        public DatasetExpressionEvaluator getCachedEvaluator() {
            return null;
        }

        @Override
        public void updateBookmark(JRPrintElement element) {
            BookmarkHelper bookmarkHelper = this.output.getBookmarkHelper();
            if (bookmarkHelper != null) {
                bookmarkHelper.updateBookmark(element);
            }
        }

        @Override
        public boolean isParentPagination() {
            return false;
        }
    }

    protected static class FillerPrintPart
    implements FillingPrintPart {
        private final JRBaseFiller filler;

        protected FillerPrintPart(JRBaseFiller filler) {
            this.filler = filler;
        }

        @Override
        public boolean isPageFinal(JRPrintPage page) {
            return this.filler.isPageFinal(page);
        }
    }

    protected class PartBandParent
    implements BandReportFillerParent {
        private final PartPrintOutput output;

        protected PartBandParent(PartPrintOutput output) {
            this.output = output;
        }

        @Override
        public String getReportName() {
            return SubreportFillPart.this.getReport().getName();
        }

        @Override
        public BaseReportFiller getFiller() {
            return SubreportFillPart.this.fillContext.getFiller();
        }

        @Override
        public JRPropertiesHolder getParentProperties() {
            return null;
        }

        @Override
        public DatasetExpressionEvaluator getCachedEvaluator() {
            return null;
        }

        @Override
        public void registerSubfiller(JRBaseFiller filler) {
        }

        @Override
        public void unregisterSubfiller(JRBaseFiller filler) {
        }

        @Override
        public void abortSubfiller(JRBaseFiller filler) {
        }

        @Override
        public boolean isRunToBottom() {
            return true;
        }

        @Override
        public boolean isParentPagination() {
            return false;
        }

        @Override
        public boolean isPageBreakInhibited() {
            return true;
        }

        @Override
        public boolean isSplitTypePreventInhibited(boolean isTopLevelCall) {
            return true;
        }

        @Override
        public void addPage(FillerPageAddedEvent pageAdded) throws JRException {
            PrintPartCreator partCreator = new PrintPartCreator(pageAdded.getJasperPrint());
            if (pageAdded.getPageIndex() == 0) {
                partCreator.accept(SubreportFillPart.this.getPartName(), SubreportFillPart.this.getPrintPartProperties());
            }
            if (SubreportFillPart.this.fillContext.getFiller().getFillContext().toDetectParts()) {
                PartPropertiesDetector detector = new PartPropertiesDetector(pageAdded.getFiller().getPropertiesUtil(), partCreator::accept);
                detector.detect(pageAdded.getPage().getElements());
            }
            if (partCreator.hasPart()) {
                FillerPrintPart fillingPart = new FillerPrintPart(pageAdded.getFiller());
                this.output.startPart(partCreator.getPart(), fillingPart);
            }
            this.output.addPage(pageAdded.getPage(), pageAdded.getDelayedActions());
            SubreportFillPart.this.fillContext.getFiller().recordUsedPageWidth(pageAdded.getFiller().getUsedPageWidth());
            if (pageAdded.hasReportEnded()) {
                this.output.addStyles(pageAdded.getJasperPrint().getStylesList());
                this.output.addOrigins(pageAdded.getJasperPrint().getOriginsList());
            }
        }

        @Override
        public void updateBookmark(JRPrintElement element) {
            BookmarkHelper bookmarkHelper = this.output.getBookmarkHelper();
            if (bookmarkHelper != null) {
                bookmarkHelper.updateBookmark(element);
            }
        }

        @Override
        public String getReportLocation() {
            return SubreportFillPart.this.jasperReportSource == null ? null : SubreportFillPart.this.jasperReportSource.getReportLocation();
        }

        @Override
        public void registerReportStyles(List<JRStyle> styles) {
        }
    }
}

