/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.components.iconlabel.IconLabelElementCsvHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementDocxHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementGraphics2DHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementHtmlHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementOdsHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementOdtHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementPptxHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementRtfHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementXlsxHandler;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.engine.query.DefaultQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.scriptlets.DefaultScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.util.MessageProviderFactory;
import net.sf.jasperreports.engine.util.ResourceBundleMessageProviderFactory;
import net.sf.jasperreports.engine.xml.JacksonReportLoader;
import net.sf.jasperreports.engine.xml.JacksonReportWriterFactory;
import net.sf.jasperreports.engine.xml.ReportLoader;
import net.sf.jasperreports.engine.xml.ReportWriterFactory;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;

public class DefaultExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final GenericElementHandlerBundle HANDLER_BUNDLE = new GenericElementHandlerBundle(){

        @Override
        public String getNamespace() {
            return "http://jasperreports.sourceforge.net/jasperreports";
        }

        @Override
        public GenericElementHandler getHandler(String elementName, String exporterKey) {
            if ("iconLabel".equals(elementName)) {
                if ("net.sf.jasperreports.graphics2d".equals(exporterKey)) {
                    return new IconLabelElementGraphics2DHandler();
                }
                if ("net.sf.jasperreports.html".equals(exporterKey)) {
                    return IconLabelElementHtmlHandler.getInstance();
                }
                if ("net.sf.jasperreports.csv".equals(exporterKey)) {
                    return IconLabelElementCsvHandler.getInstance();
                }
                if ("net.sf.jasperreports.xlsx".equals(exporterKey)) {
                    return IconLabelElementXlsxHandler.getInstance();
                }
                if ("net.sf.jasperreports.docx".equals(exporterKey)) {
                    return IconLabelElementDocxHandler.getInstance();
                }
                if ("net.sf.jasperreports.pptx".equals(exporterKey)) {
                    return IconLabelElementPptxHandler.getInstance();
                }
                if ("net.sf.jasperreports.ods".equals(exporterKey)) {
                    return IconLabelElementOdsHandler.getInstance();
                }
                if ("net.sf.jasperreports.odt".equals(exporterKey)) {
                    return IconLabelElementOdtHandler.getInstance();
                }
                if ("net.sf.jasperreports.rtf".equals(exporterKey)) {
                    return IconLabelElementRtfHandler.getInstance();
                }
            }
            return null;
        }
    };
    private static final ExtensionsRegistry defaultExtensionsRegistry = new ExtensionsRegistry(){

        @Override
        public <T> List<T> getExtensions(Class<T> extensionType) {
            if (JRQueryExecuterFactoryBundle.class.equals(extensionType)) {
                return Collections.singletonList(DefaultQueryExecuterFactoryBundle.getInstance());
            }
            if (ScriptletFactory.class.equals(extensionType)) {
                return Collections.singletonList(DefaultScriptletFactory.getInstance());
            }
            if (GenericElementHandlerBundle.class.equals(extensionType)) {
                return Collections.singletonList(HANDLER_BUNDLE);
            }
            if (MessageProviderFactory.class.equals(extensionType)) {
                return Collections.singletonList(new ResourceBundleMessageProviderFactory());
            }
            if (ReportLoader.class.equals(extensionType)) {
                return Collections.singletonList(JacksonReportLoader.instance());
            }
            if (ReportWriterFactory.class.equals(extensionType)) {
                return Collections.singletonList(JacksonReportWriterFactory.instance());
            }
            return null;
        }
    };

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        return defaultExtensionsRegistry;
    }
}

