/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.compilers.JavaScriptCompilerBase;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.util.CompositeExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.optimizer.ClassCompiler;

public class JavaScriptClassCompiler
extends JavaScriptCompilerBase {
    public static final String PROPERTY_OPTIMIZATION_LEVEL = "net.sf.jasperreports.javascript.class.compiler.optimization.level";
    public static final String PROPERTY_EXPRESSIONS_PER_SCRIPT = "net.sf.jasperreports.javascript.class.compiler.expressions.per.script";
    public static final String PROPERTY_SCRIPT_MAX_SIZE = "net.sf.jasperreports.javascript.class.compiler.script.max.size";
    private static final Log log = LogFactory.getLog(JavaScriptClassCompiler.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_CLASS_NAME = "compilers.javascript.unexpected.class.name";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_CLASSES_LENGTH = "compilers.javascript.unexpected.classes.length";

    public JavaScriptClassCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        Context context = ContextFactory.getGlobal().enterContext();
        try {
            JRPropertiesUtil properties = JRPropertiesUtil.getInstance(this.jasperReportsContext);
            int expressionsPerScript = properties.getIntegerProperty(PROPERTY_EXPRESSIONS_PER_SCRIPT);
            int scriptMaxLength = properties.getIntegerProperty(PROPERTY_SCRIPT_MAX_SIZE);
            int optimizationLevel = properties.getIntegerProperty(PROPERTY_OPTIMIZATION_LEVEL);
            context.setOptimizationLevel(optimizationLevel);
            context.getWrapFactory().setJavaPrimitiveWrap(false);
            JavaScriptCompilerBase.Errors errors = new JavaScriptCompilerBase.Errors();
            CompilerEnvirons compilerEnv = new CompilerEnvirons();
            compilerEnv.initFromContext(context);
            context.setOptimizationLevel(-1);
            for (int i = 0; i < units.length; ++i) {
                JRCompilationUnit unit = units[i];
                CompileSources compileSources = new CompileSources(expressionsPerScript, scriptMaxLength);
                JavaScriptCompiledData compiledData = new JavaScriptCompiledData();
                for (JRExpression expr : unit.getExpressions()) {
                    int id = unit.getCompileTask().getExpressionId(expr);
                    JavaScriptCompilerBase.ScriptExpressionVisitor defaultVisitor = this.defaultExpressionCreator();
                    JRExpressionUtil.visitChunks(expr, defaultVisitor);
                    String defaultExpression = defaultVisitor.getScript();
                    try {
                        context.compileString(defaultExpression, "expression", 0, null);
                    }
                    catch (EvaluatorException e) {
                        errors.addError(e);
                    }
                    if (errors.hasErrors()) continue;
                    JavaScriptCompilerBase.ScriptExpressionVisitor oldVisitor = this.oldExpressionCreator();
                    JavaScriptCompilerBase.ScriptExpressionVisitor estimatedVisitor = this.estimatedExpressionCreator();
                    JRExpressionUtil.visitChunks(expr, new CompositeExpressionChunkVisitor(oldVisitor, estimatedVisitor));
                    int defaultExpressionIdx = compileSources.addExpression(defaultExpression);
                    int oldExpressionIdx = compileSources.addExpression(oldVisitor.getScript());
                    int estimatedExpressionIdx = compileSources.addExpression(estimatedVisitor.getScript());
                    compiledData.addExpression(id, defaultExpressionIdx, oldExpressionIdx, estimatedExpressionIdx);
                }
                if (errors.hasErrors()) continue;
                this.compileScripts(unit, compilerEnv, compileSources, compiledData);
                unit.setCompileData(compiledData);
            }
            String string = errors.errorMessage();
            return string;
        }
        finally {
            Context.exit();
        }
    }

    protected void compileScripts(JRCompilationUnit unit, CompilerEnvirons compilerEnv, CompileSources compileSources, JavaScriptCompiledData compiledData) {
        List<String> scripts = compileSources.getScripts();
        int scriptIndex = 0;
        for (String scriptSource : scripts) {
            ClassCompiler compiler;
            Object[] compilationResult;
            String scriptClassName = unit.getName() + "_" + scriptIndex;
            if (log.isTraceEnabled()) {
                log.trace((Object)("compiling script with name " + scriptClassName + "\n" + scriptSource));
            }
            if ((compilationResult = (compiler = new ClassCompiler(compilerEnv)).compileToClassFiles(scriptSource, unit.getName(), 0, scriptClassName)).length != 2) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_CLASSES_LENGTH, new Object[]{compilationResult.length});
            }
            if (!scriptClassName.equals(compilationResult[0])) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_CLASS_NAME, new Object[]{compilationResult[0], scriptClassName});
            }
            byte[] compiledClass = (byte[])compilationResult[1];
            compiledData.addClass(scriptClassName, compiledClass);
            ++scriptIndex;
        }
    }

    protected static class CompileSources {
        private final int expressionsPerSource;
        private final int scriptMaxLength;
        private final Map<String, Integer> expressionIndexes = new HashMap<String, Integer>();
        private final List<String> scriptSources = new LinkedList<String>();
        private int currentScriptIndex = 0;
        private int currentExpressionId = 0;
        private StringBuilder currentScriptSource;

        public CompileSources(int expressionsPerSource, int scriptMaxLength) {
            this.expressionsPerSource = expressionsPerSource;
            this.scriptMaxLength = scriptMaxLength;
            this.currentScriptSource = this.initScriptSource();
        }

        private StringBuilder initScriptSource() {
            StringBuilder source = new StringBuilder(1024);
            source.append("switch(");
            source.append("_jreid");
            source.append("){\n");
            return source;
        }

        public Integer expressionIndex(String expression) {
            return this.expressionIndexes.get(expression);
        }

        public int addExpression(String expression) {
            Integer existingIdx = this.expressionIndexes.get(expression);
            if (existingIdx != null) {
                return existingIdx;
            }
            String expressionFragment = "case " + this.currentExpressionId + ":\n" + expression + "\nbreak\n";
            if (this.currentExpressionId >= this.expressionsPerSource || this.currentScriptSource.length() + expressionFragment.length() > this.scriptMaxLength) {
                this.addScriptSource();
                expressionFragment = "case " + this.currentExpressionId + ":\n" + expression + "\nbreak\n";
            }
            this.currentScriptSource.append(expressionFragment);
            int expressionIdx = JavaScriptCompiledData.makeExpressionIndex(this.currentScriptIndex, this.currentExpressionId);
            ++this.currentExpressionId;
            this.expressionIndexes.put(expression, expressionIdx);
            if (log.isTraceEnabled()) {
                log.trace((Object)("expression index " + expressionIdx + " for expression " + expression));
            }
            return expressionIdx;
        }

        protected void addScriptSource() {
            this.closeCurrentScript();
            this.currentScriptSource = this.initScriptSource();
            ++this.currentScriptIndex;
            this.currentExpressionId = 0;
        }

        protected void closeCurrentScript() {
            if (this.currentExpressionId > 0) {
                this.currentScriptSource.append("}");
                String scriptSource = this.currentScriptSource.toString();
                this.scriptSources.add(scriptSource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created script of length " + scriptSource.length() + ", expression count " + this.currentExpressionId));
                }
            }
        }

        public List<String> getScripts() {
            this.closeCurrentScript();
            return this.scriptSources;
        }
    }
}

