/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived;

import java.util.EnumSet;
import java.util.Set;
import org.terracotta.statistics.AbstractSourceStatistic;
import org.terracotta.statistics.observer.EventObserver;
import org.terracotta.statistics.observer.OperationObserver;

public class OperationResultFilter<T extends Enum<T>>
extends AbstractSourceStatistic<EventObserver>
implements OperationObserver<T> {
    private final Set<T> targets;

    public OperationResultFilter(Set<T> targets, EventObserver ... observers) {
        this.targets = EnumSet.copyOf(targets);
        for (EventObserver observer : observers) {
            this.addDerivedStatistic(observer);
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void end(T result) {
        if (!this.derivedStatistics.isEmpty() && this.targets.contains(result)) {
            for (EventObserver derived : this.derivedStatistics) {
                derived.event(new long[0]);
            }
        }
    }

    @Override
    public void end(T result, long ... parameters) {
        if (!this.derivedStatistics.isEmpty() && this.targets.contains(result)) {
            for (EventObserver derived : this.derivedStatistics) {
                derived.event(parameters);
            }
        }
    }
}

