/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.nonstop;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.writebehind.NonStopWriteBehind;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.modules.ehcache.ClusteredCacheInternalContext;
import org.terracotta.modules.ehcache.ToolkitInstanceFactory;
import org.terracotta.modules.ehcache.concurrency.NonStopCacheLockProvider;
import org.terracotta.modules.ehcache.store.ToolkitNonStopExceptionOnTimeoutConfiguration;
import org.terracotta.modules.ehcache.store.nonstop.ExceptionOnTimeoutStore;
import org.terracotta.modules.ehcache.store.nonstop.LocalReadsAndExceptionOnWritesTimeoutStore;
import org.terracotta.modules.ehcache.store.nonstop.LocalReadsOnTimeoutStore;
import org.terracotta.modules.ehcache.store.nonstop.NoOpOnTimeoutStore;
import org.terracotta.modules.ehcache.store.nonstop.NonStopSubTypeProxyUtil;
import org.terracotta.modules.ehcache.store.nonstop.ToolkitNonstopDisableConfig;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.nonstop.NonStopConfiguration;
import org.terracotta.toolkit.nonstop.NonStopException;
import org.terracotta.toolkit.rejoin.InvalidLockStateAfterRejoinException;
import org.terracotta.toolkit.rejoin.RejoinException;

public class NonStopStoreWrapper
implements TerracottaStore {
    private static final long TIME_TO_WAIT_FOR_ASYNC_STORE_INIT = Long.parseLong(System.getProperty("com.tc.non.stop.async.store.init", String.valueOf(TimeUnit.MINUTES.toMillis(5L))));
    private static final Set<String> LOCAL_METHODS = new HashSet<String>();
    private volatile TerracottaStore delegate;
    private final NonStopFeature nonStop;
    private final ToolkitNonStopExceptionOnTimeoutConfiguration toolkitNonStopConfiguration;
    private final NonstopConfiguration ehcacheNonStopConfiguration;
    private volatile TerracottaStore localReadDelegate;
    private final BulkOpsToolkitNonStopConfiguration bulkOpsToolkitNonStopConfiguration;
    private final ClusteredCacheInternalContext clusteredCacheInternalContext;
    private final Ehcache cache;
    private WriteBehind writeBehind;

    public NonStopStoreWrapper(Callable<TerracottaStore> clusteredStoreCreator, ToolkitInstanceFactory toolkitInstanceFactory, Ehcache cache) {
        this.cache = cache;
        this.nonStop = (NonStopFeature)toolkitInstanceFactory.getToolkit().getFeature(ToolkitFeatureType.NONSTOP);
        this.ehcacheNonStopConfiguration = cache.getCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration();
        this.toolkitNonStopConfiguration = new ToolkitNonStopExceptionOnTimeoutConfiguration(this.ehcacheNonStopConfiguration);
        this.bulkOpsToolkitNonStopConfiguration = new BulkOpsToolkitNonStopConfiguration(this.ehcacheNonStopConfiguration);
        Toolkit toolkit = toolkitInstanceFactory.getToolkit();
        CacheLockProvider cacheLockProvider = this.createCacheLockProvider(toolkit, toolkitInstanceFactory);
        this.clusteredCacheInternalContext = new ClusteredCacheInternalContext(toolkit, cacheLockProvider);
        if (this.ehcacheNonStopConfiguration != null && this.ehcacheNonStopConfiguration.isEnabled()) {
            this.createStoreAsynchronously(toolkit, clusteredStoreCreator);
        } else {
            this.doInit(clusteredStoreCreator);
        }
    }

    private CacheLockProvider createCacheLockProvider(Toolkit toolkit, ToolkitInstanceFactory toolkitInstanceFactory) {
        return new NonStopCacheLockProvider((NonStopFeature)toolkit.getFeature(ToolkitFeatureType.NONSTOP), this.ehcacheNonStopConfiguration, toolkitInstanceFactory);
    }

    private void createStoreAsynchronously(Toolkit toolkit, Callable<TerracottaStore> clusteredStoreCreator) {
        Thread t = new Thread(this.createInitRunnable(clusteredStoreCreator), "init Store asynchronously " + this.cache.getName());
        t.setDaemon(true);
        t.start();
    }

    private Runnable createInitRunnable(final Callable<TerracottaStore> clusteredStoreCreator) {
        Runnable initRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                while (true) {
                    NonStopStoreWrapper.this.nonStop.start((NonStopConfiguration)new ToolkitNonstopDisableConfig());
                    try {
                        NonStopStoreWrapper.this.doInit(clusteredStoreCreator);
                        NonStopStoreWrapper nonStopStoreWrapper = NonStopStoreWrapper.this;
                        synchronized (nonStopStoreWrapper) {
                            NonStopStoreWrapper.this.notifyAll();
                        }
                        return;
                    }
                    catch (RejoinException e) {
                        if (startTime + TIME_TO_WAIT_FOR_ASYNC_STORE_INIT >= System.currentTimeMillis()) continue;
                        throw new RuntimeException("Unable to create clusteredStore in time", e);
                    }
                    finally {
                        NonStopStoreWrapper.this.nonStop.finish();
                        continue;
                    }
                    break;
                }
            }
        };
        return initRunnable;
    }

    @Override
    public Object getInternalContext() {
        return this.clusteredCacheInternalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteBehind createWriteBehind() {
        if (this.ehcacheNonStopConfiguration != null && this.ehcacheNonStopConfiguration.isEnabled()) {
            NonStopStoreWrapper nonStopStoreWrapper = this;
            synchronized (nonStopStoreWrapper) {
                if (this.writeBehind != null) {
                    throw new IllegalStateException();
                }
                this.writeBehind = new NonStopWriteBehind();
                if (this.delegate != null) {
                    ((NonStopWriteBehind)this.writeBehind).init(this.cache.getCacheManager().createTerracottaWriteBehind(this.cache));
                }
                return this.writeBehind;
            }
        }
        this.writeBehind = this.cache.getCacheManager().createTerracottaWriteBehind(this.cache);
        return this.writeBehind;
    }

    @Override
    public boolean bufferFull() {
        return false;
    }

    private TerracottaStore createStore(Callable<TerracottaStore> clusteredStoreCreator) {
        try {
            return clusteredStoreCreator.call();
        }
        catch (InvalidConfigurationException e) {
            throw e;
        }
        catch (RejoinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit(Callable<TerracottaStore> clusteredStoreCreator) {
        TerracottaStore delegateTemp = this.createStore(clusteredStoreCreator);
        if (this.clusteredCacheInternalContext.getCacheLockProvider() instanceof NonStopCacheLockProvider) {
            ((NonStopCacheLockProvider)this.clusteredCacheInternalContext.getCacheLockProvider()).init((CacheLockProvider)delegateTemp.getInternalContext());
        }
        this.cache.getCacheManager().createTerracottaEventReplicator(this.cache);
        NonStopStoreWrapper nonStopStoreWrapper = this;
        synchronized (nonStopStoreWrapper) {
            if (this.delegate == null) {
                this.delegate = delegateTemp;
                StatisticsManager.associate(this).withChild(delegateTemp);
                if (this.writeBehind != null && this.writeBehind instanceof NonStopWriteBehind) {
                    ((NonStopWriteBehind)this.writeBehind).init(this.cache.getCacheManager().createTerracottaWriteBehind(this.cache));
                }
            }
        }
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public void removeStoreListener(StoreListener arg0) {
        if (this.delegate != null) {
            this.delegate.removeStoreListener(arg0);
        }
    }

    @Override
    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    private void throwNonStopExceptionWhenClusterNotInit() throws NonStopException {
        if (this.delegate == null && this.ehcacheNonStopConfiguration != null && this.ehcacheNonStopConfiguration.isEnabled()) {
            if (this.ehcacheNonStopConfiguration.isImmediateTimeout()) {
                throw new NonStopException("Cluster not up OR still in the process of connecting ");
            }
            long timeout = this.ehcacheNonStopConfiguration.getTimeoutMillis();
            this.waitForInit(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInit(long timeout) {
        NonStopStoreWrapper nonStopStoreWrapper = this;
        synchronized (nonStopStoreWrapper) {
            while (this.delegate == null) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new NonStopException("Cluster not up OR still in the process of connecting ");
                }
            }
        }
    }

    private TerracottaStore getTimeoutBehavior() {
        if (this.ehcacheNonStopConfiguration == null) {
            throw new AssertionError((Object)"Ehcache NonStopConfig cannot be null");
        }
        TimeoutBehaviorConfiguration behaviorConfiguration = this.ehcacheNonStopConfiguration.getTimeoutBehavior();
        switch (behaviorConfiguration.getTimeoutBehaviorType()) {
            case EXCEPTION: {
                return ExceptionOnTimeoutStore.getInstance();
            }
            case LOCAL_READS: {
                if (this.localReadDelegate == null) {
                    if (this.delegate == null) {
                        return NoOpOnTimeoutStore.getInstance();
                    }
                    this.localReadDelegate = new LocalReadsOnTimeoutStore(this.delegate);
                }
                return this.localReadDelegate;
            }
            case LOCAL_READS_AND_EXCEPTION_ON_WRITES: {
                if (this.localReadDelegate == null) {
                    if (this.delegate == null) {
                        return new LocalReadsAndExceptionOnWritesTimeoutStore();
                    }
                    this.localReadDelegate = new LocalReadsAndExceptionOnWritesTimeoutStore(this.delegate);
                }
                return this.localReadDelegate;
            }
            case NOOP: {
                return NoOpOnTimeoutStore.getInstance();
            }
        }
        return ExceptionOnTimeoutStore.getInstance();
    }

    private static void validateMethodNamesExist(Class klazz, Set<String> methodToCheck) {
        for (String methodName : methodToCheck) {
            if (!NonStopStoreWrapper.exist(klazz, methodName)) {
                throw new AssertionError((Object)("Method " + methodName + " does not exist in class " + klazz.getName()));
            }
        }
    }

    private static boolean exist(Class klazz, String method) {
        Method[] methods;
        for (Method m : methods = klazz.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        PrintStream out = System.out;
        Class[] classes = new Class[]{TerracottaStore.class};
        HashSet<String> bulkMethods = new HashSet<String>();
        bulkMethods.add("setNodeCoherent");
        bulkMethods.add("putAll");
        bulkMethods.add("getAllQuiet");
        bulkMethods.add("getAll");
        bulkMethods.add("removeAll");
        NonStopStoreWrapper.validateMethodNamesExist(TerracottaStore.class, bulkMethods);
        for (Class c : classes) {
            for (Method m : c.getMethods()) {
                int i;
                out.println("/**");
                out.println("* {@inheritDoc}");
                out.println("*/");
                out.print("public " + m.getReturnType().getSimpleName() + " " + m.getName() + "(");
                Class<?>[] params = m.getParameterTypes();
                for (int i2 = 0; i2 < params.length; ++i2) {
                    out.print(params[i2].getSimpleName() + " arg" + i2);
                    if (i2 >= params.length - 1) continue;
                    out.print(", ");
                }
                out.print(")");
                Class<?>[] exceptions = m.getExceptionTypes();
                if (exceptions.length > 0) {
                    out.print(" throws ");
                }
                for (i = 0; i < exceptions.length; ++i) {
                    out.print(exceptions[i].getSimpleName());
                    if (i >= exceptions.length - 1) continue;
                    out.print(", ");
                }
                out.println(" {");
                if (LOCAL_METHODS.contains(m.getName())) {
                    out.println(" if (delegate != null) {");
                    if (m.getReturnType() != Void.TYPE) {
                        out.print("return ");
                    }
                    if (NonStopSubTypeProxyUtil.isNonStopSubtype(m.getReturnType())) {
                        out.print("NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(" + m.getReturnType().getSimpleName() + ".class , ");
                    }
                    out.print("this.delegate." + m.getName() + "(");
                    for (i = 0; i < params.length; ++i) {
                        out.print("arg" + i);
                        if (i >= params.length - 1) continue;
                        out.print(", ");
                    }
                    if (NonStopSubTypeProxyUtil.isNonStopSubtype(m.getReturnType())) {
                        out.println(")");
                    }
                    out.println(");");
                    out.println("    } else {");
                    if (m.getReturnType() != Void.TYPE) {
                        out.print("return ");
                    }
                    out.print("NoOpOnTimeoutStore.getInstance()." + m.getName() + "(");
                    for (i = 0; i < params.length; ++i) {
                        out.print("arg" + i);
                        if (i >= params.length - 1) continue;
                        out.print(", ");
                    }
                    out.println(");");
                    out.println(" }");
                    out.println(" }");
                    continue;
                }
                out.println("    // THIS IS GENERATED CODE -- DO NOT HAND MODIFY!");
                if (bulkMethods.contains(m.getName())) {
                    out.println("      nonStop.start(bulkOpsToolkitNonStopConfiguration);");
                } else {
                    out.println("      nonStop.start(toolkitNonStopConfiguration);");
                }
                out.println("      try {");
                out.println("      throwNonStopExceptionWhenClusterNotInit();");
                out.print("        ");
                if (m.getReturnType() != Void.TYPE) {
                    out.print("return ");
                }
                if (NonStopSubTypeProxyUtil.isNonStopSubtype(m.getReturnType())) {
                    out.print("NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(" + m.getReturnType().getSimpleName() + ".class , ");
                }
                out.print("this.delegate." + m.getName() + "(");
                for (i = 0; i < params.length; ++i) {
                    out.print("arg" + i);
                    if (i >= params.length - 1) continue;
                    out.print(", ");
                }
                if (NonStopSubTypeProxyUtil.isNonStopSubtype(m.getReturnType())) {
                    out.println(")");
                }
                out.println(");");
                out.println("      } catch (NonStopException e) {");
                if (m.getReturnType() != Void.TYPE) {
                    out.print("return ");
                }
                out.print("getTimeoutBehavior()." + m.getName() + "(");
                for (i = 0; i < params.length; ++i) {
                    out.print("arg" + i);
                    if (i >= params.length - 1) continue;
                    out.print(", ");
                }
                out.println(");");
                out.println("      } catch (InvalidLockStateAfterRejoinException e) {");
                if (m.getReturnType() != Void.TYPE) {
                    out.print("return ");
                }
                out.print("getTimeoutBehavior()." + m.getName() + "(");
                for (i = 0; i < params.length; ++i) {
                    out.print("arg" + i);
                    if (i >= params.length - 1) continue;
                    out.print(", ");
                }
                out.println(");");
                out.println("      } finally {");
                out.println("        nonStop.finish();");
                out.println("      }");
                out.println("}");
                out.println("");
            }
        }
    }

    @Override
    public Element unsafeGet(Object arg0) {
        if (this.delegate != null) {
            return this.delegate.unsafeGet(arg0);
        }
        return NoOpOnTimeoutStore.getInstance().unsafeGet(arg0);
    }

    @Override
    public Set getLocalKeys() {
        if (this.delegate != null) {
            return NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(Set.class, this.delegate.getLocalKeys());
        }
        return NoOpOnTimeoutStore.getInstance().getLocalKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheConfiguration.TransactionalMode getTransactionalMode() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            CacheConfiguration.TransactionalMode transactionalMode = this.delegate.getTransactionalMode();
            return transactionalMode;
        }
        catch (NonStopException e) {
            CacheConfiguration.TransactionalMode transactionalMode = this.getTimeoutBehavior().getTransactionalMode();
            return transactionalMode;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            CacheConfiguration.TransactionalMode transactionalMode = this.getTimeoutBehavior().getTransactionalMode();
            return transactionalMode;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element get(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.get(arg0);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().get(arg0);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().get(arg0);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Element arg0) throws CacheException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.put(arg0);
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().put(arg0);
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().put(arg0);
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Element arg0, Element arg1, ElementValueComparator arg2) throws NullPointerException, IllegalArgumentException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.replace(arg0, arg1, arg2);
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().replace(arg0, arg1, arg2);
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().replace(arg0, arg1, arg2);
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Element arg0) throws NullPointerException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.replace(arg0);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().replace(arg0);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().replace(arg0);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection arg0) throws CacheException {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.putAll(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().putAll(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().putAll(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element remove(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.remove(arg0);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().remove(arg0);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().remove(arg0);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.flush();
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().flush();
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().flush();
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.containsKey(arg0);
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().containsKey(arg0);
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().containsKey(arg0);
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            int n = this.delegate.getSize();
            return n;
        }
        catch (NonStopException e) {
            int n = this.getTimeoutBehavior().getSize();
            return n;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            int n = this.getTimeoutBehavior().getSize();
            return n;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws CacheException {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.removeAll();
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().removeAll();
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().removeAll();
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection arg0) {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.removeAll(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().removeAll(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().removeAll(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element arg0, ElementValueComparator arg1) throws NullPointerException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.removeElement(arg0, arg1);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().removeElement(arg0, arg1);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().removeElement(arg0, arg1);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element putIfAbsent(Element arg0) throws NullPointerException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.putIfAbsent(arg0);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().putIfAbsent(arg0);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().putIfAbsent(arg0);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    @Override
    public boolean containsKeyInMemory(Object arg0) {
        if (this.delegate != null) {
            return this.delegate.containsKeyInMemory(arg0);
        }
        return NoOpOnTimeoutStore.getInstance().containsKeyInMemory(arg0);
    }

    @Override
    public boolean containsKeyOffHeap(Object arg0) {
        if (this.delegate != null) {
            return this.delegate.containsKeyOffHeap(arg0);
        }
        return NoOpOnTimeoutStore.getInstance().containsKeyOffHeap(arg0);
    }

    @Override
    public long getInMemorySizeInBytes() {
        if (this.delegate != null) {
            return this.delegate.getInMemorySizeInBytes();
        }
        return NoOpOnTimeoutStore.getInstance().getInMemorySizeInBytes();
    }

    @Override
    public int getInMemorySize() {
        if (this.delegate != null) {
            return this.delegate.getInMemorySize();
        }
        return NoOpOnTimeoutStore.getInstance().getInMemorySize();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        if (this.delegate != null) {
            return this.delegate.getOffHeapSizeInBytes();
        }
        return NoOpOnTimeoutStore.getInstance().getOffHeapSizeInBytes();
    }

    @Override
    public int getOffHeapSize() {
        if (this.delegate != null) {
            return this.delegate.getOffHeapSize();
        }
        return NoOpOnTimeoutStore.getInstance().getOffHeapSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNodeCoherent(boolean arg0) throws UnsupportedOperationException, TerracottaNotRunningException {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.setNodeCoherent(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().setNodeCoherent(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().setNodeCoherent(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllQuiet(Collection arg0) {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Map<Object, Element> map = NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(Map.class, this.delegate.getAllQuiet(arg0));
            return map;
        }
        catch (NonStopException e) {
            Map<Object, Element> map = this.getTimeoutBehavior().getAllQuiet(arg0);
            return map;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Map<Object, Element> map = this.getTimeoutBehavior().getAllQuiet(arg0);
            return map;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Collection arg0) {
        this.nonStop.start((NonStopConfiguration)this.bulkOpsToolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Map<Object, Element> map = NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(Map.class, this.delegate.getAll(arg0));
            return map;
        }
        catch (NonStopException e) {
            Map<Object, Element> map = this.getTimeoutBehavior().getAll(arg0);
            return map;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Map<Object, Element> map = this.getTimeoutBehavior().getAll(arg0);
            return map;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeExtractors(Map arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.setAttributeExtractors(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().setAttributeExtractors(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().setAttributeExtractors(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAbortedSizeOf() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.hasAbortedSizeOf();
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().hasAbortedSizeOf();
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().hasAbortedSizeOf();
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOnDiskSize() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            int n = this.delegate.getOnDiskSize();
            return n;
        }
        catch (NonStopException e) {
            int n = this.getTimeoutBehavior().getOnDiskSize();
            return n;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            int n = this.getTimeoutBehavior().getOnDiskSize();
            return n;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInMemoryEvictionPolicy(Policy arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.setInMemoryEvictionPolicy(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().setInMemoryEvictionPolicy(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().setInMemoryEvictionPolicy(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Results executeQuery(StoreQuery arg0) throws SearchException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Results results = this.delegate.executeQuery(arg0);
            return results;
        }
        catch (NonStopException e) {
            Results results = this.getTimeoutBehavior().executeQuery(arg0);
            return results;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Results results = this.getTimeoutBehavior().executeQuery(arg0);
            return results;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element arg0, CacheWriterManager arg1) throws CacheException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.putWithWriter(arg0, arg1);
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().putWithWriter(arg0, arg1);
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().putWithWriter(arg0, arg1);
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recalculateSize(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.recalculateSize(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().recalculateSize(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().recalculateSize(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getQuiet(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.getQuiet(arg0);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().getQuiet(arg0);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().getQuiet(arg0);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCacheCoherent() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.isCacheCoherent();
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().isCacheCoherent();
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().isCacheCoherent();
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOnDiskSizeInBytes() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            long l = this.delegate.getOnDiskSizeInBytes();
            return l;
        }
        catch (NonStopException e) {
            long l = this.getTimeoutBehavior().getOnDiskSizeInBytes();
            return l;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            long l = this.getTimeoutBehavior().getOnDiskSizeInBytes();
            return l;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTerracottaClusteredSize() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            int n = this.delegate.getTerracottaClusteredSize();
            return n;
        }
        catch (NonStopException e) {
            int n = this.getTimeoutBehavior().getTerracottaClusteredSize();
            return n;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            int n = this.getTimeoutBehavior().getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireElements() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.expireElements();
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().expireElements();
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().expireElements();
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeCoherent() throws TerracottaNotRunningException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.isNodeCoherent();
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().isNodeCoherent();
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().isNodeCoherent();
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStoreListener(StoreListener arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.addStoreListener(arg0);
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().addStoreListener(arg0);
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().addStoreListener(arg0);
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClusterCoherent() throws TerracottaNotRunningException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.isClusterCoherent();
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().isClusterCoherent();
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().isClusterCoherent();
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException, TerracottaNotRunningException, InterruptedException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            this.delegate.waitUntilClusterCoherent();
        }
        catch (NonStopException e) {
            this.getTimeoutBehavior().waitUntilClusterCoherent();
        }
        catch (InvalidLockStateAfterRejoinException e) {
            this.getTimeoutBehavior().waitUntilClusterCoherent();
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getInMemoryEvictionPolicy() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Policy policy = this.delegate.getInMemoryEvictionPolicy();
            return policy;
        }
        catch (NonStopException e) {
            Policy policy = this.getTimeoutBehavior().getInMemoryEvictionPolicy();
            return policy;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Policy policy = this.getTimeoutBehavior().getInMemoryEvictionPolicy();
            return policy;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object arg0, CacheWriterManager arg1) throws CacheException {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Element element = this.delegate.removeWithWriter(arg0, arg1);
            return element;
        }
        catch (NonStopException e) {
            Element element = this.getTimeoutBehavior().removeWithWriter(arg0, arg1);
            return element;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Element element = this.getTimeoutBehavior().removeWithWriter(arg0, arg1);
            return element;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getKeys() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            List list = NonStopSubTypeProxyUtil.newNonStopSubTypeProxy(List.class, this.delegate.getKeys());
            return list;
        }
        catch (NonStopException e) {
            List list = this.getTimeoutBehavior().getKeys();
            return list;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            List list = this.getTimeoutBehavior().getKeys();
            return list;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getStatus() {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Status status = this.delegate.getStatus();
            return status;
        }
        catch (NonStopException e) {
            Status status = this.getTimeoutBehavior().getStatus();
            return status;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Status status = this.getTimeoutBehavior().getStatus();
            return status;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getSearchAttribute(String arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            Attribute attribute = this.delegate.getSearchAttribute(arg0);
            return attribute;
        }
        catch (NonStopException e) {
            Attribute attribute = this.getTimeoutBehavior().getSearchAttribute(arg0);
            return attribute;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            Attribute attribute = this.getTimeoutBehavior().getSearchAttribute(arg0);
            return attribute;
        }
        finally {
            this.nonStop.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOnDisk(Object arg0) {
        this.nonStop.start((NonStopConfiguration)this.toolkitNonStopConfiguration);
        try {
            this.throwNonStopExceptionWhenClusterNotInit();
            boolean bl = this.delegate.containsKeyOnDisk(arg0);
            return bl;
        }
        catch (NonStopException e) {
            boolean bl = this.getTimeoutBehavior().containsKeyOnDisk(arg0);
            return bl;
        }
        catch (InvalidLockStateAfterRejoinException e) {
            boolean bl = this.getTimeoutBehavior().containsKeyOnDisk(arg0);
            return bl;
        }
        finally {
            this.nonStop.finish();
        }
    }

    static {
        LOCAL_METHODS.add("unsafeGet");
        LOCAL_METHODS.add("containsKeyInMemory");
        LOCAL_METHODS.add("containsKeyOffHeap");
        LOCAL_METHODS.add("getInMemorySizeInBytes");
        LOCAL_METHODS.add("getInMemorySize");
        LOCAL_METHODS.add("getOffHeapSizeInBytes");
        LOCAL_METHODS.add("getOffHeapSize");
        LOCAL_METHODS.add("getLocalKeys");
    }

    private static class BulkOpsToolkitNonStopConfiguration
    extends ToolkitNonStopExceptionOnTimeoutConfiguration {
        public BulkOpsToolkitNonStopConfiguration(NonstopConfiguration ehcacheNonStopConfig) {
            super(ehcacheNonStopConfig);
        }

        @Override
        public long getTimeoutMillis() {
            return (long)this.ehcacheNonStopConfig.getBulkOpsTimeoutMultiplyFactor() * this.ehcacheNonStopConfig.getTimeoutMillis();
        }
    }
}

