/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.bulkload;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.pool.SizeOfEngine;
import net.sf.ehcache.pool.impl.DefaultSizeOfEngine;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadConstants;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadToolkitCache;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;

public class LocalBufferedMap<K, V> {
    private static final int MAX_SIZEOF_DEPTH = 1000;
    private static final String CONCURRENT_TXN_LOCK_ID = "local-buffer-static-concurrent-txn-lock-id";
    private static final Map EMPTY_MAP = Collections.EMPTY_MAP;
    private static final int LOCAL_MAP_INITIAL_CAPACITY = 128;
    private static final float LOCAL_MAP_LOAD_FACTOR = 0.75f;
    private static final int LOCAL_MAP_INITIAL_SEGMENTS = 128;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_BATCH_SIZE = 600;
    protected static final int DEFAULT_LOCAL_BUFFER_PUTS_THROTTLE_SIZE = 200000;
    private final FlushToServerThread flushToServerThread;
    private final BulkLoadToolkitCache<K, V> bulkLoadClusteredCache;
    private final ToolkitCacheInternal<K, V> backend;
    private final int putsBatchByteSize;
    private final long batchTimeMillis;
    private final long throttlePutsByteSize;
    private volatile Map<K, Value<V>> collectBuffer;
    private volatile Map<K, Value<V>> flushBuffer;
    private volatile boolean clearMap = false;
    private volatile AtomicLong pendingOpsSize = new AtomicLong();
    private final SizeOfEngine sizeOfEngine;
    private final Lock concurrentTransactionLock;

    public LocalBufferedMap(String name, BulkLoadToolkitCache<K, V> bulkLoadClusteredCache, ToolkitCacheInternal<K, V> backend, ToolkitInternal toolkit) {
        this.bulkLoadClusteredCache = bulkLoadClusteredCache;
        this.backend = backend;
        this.collectBuffer = this.newMap();
        this.flushBuffer = EMPTY_MAP;
        this.concurrentTransactionLock = toolkit.getLock(CONCURRENT_TXN_LOCK_ID, ToolkitLockTypeInternal.CONCURRENT);
        this.flushToServerThread = new FlushToServerThread("BulkLoad Flush Thread [" + name + "]", this);
        this.flushToServerThread.setDaemon(true);
        this.sizeOfEngine = new DefaultSizeOfEngine(1000, true);
        this.putsBatchByteSize = BulkLoadConstants.getBatchedPutsBatchBytes(toolkit.getProperties());
        this.batchTimeMillis = BulkLoadConstants.getBatchedPutsBatchTimeMillis(toolkit.getProperties());
        this.throttlePutsByteSize = BulkLoadConstants.getBatchedPutsThrottlePutsAtByteSize(toolkit.getProperties());
    }

    private Map<K, Value<V>> newMap() {
        return new ConcurrentHashMap(128, 0.75f, 128);
    }

    public V get(Object key) {
        Value<V> v = this.collectBuffer.get(key);
        if (v != null && v.isRemove()) {
            return null;
        }
        if (v != null) {
            return v.getValue();
        }
        v = this.flushBuffer.get(key);
        if (v != null && v.isRemove()) {
            return null;
        }
        return v == null ? null : (V)v.getValue();
    }

    public V remove(K key) {
        RemoveValue remove = new RemoveValue();
        Value old = this.collectBuffer.put(key, remove);
        if (old == null) {
            this.pendingOpsSize.addAndGet(this.sizeOfEngine.sizeOf(key, remove, null).getCalculated());
            return null;
        }
        return old.isRemove() ? null : (V)old.getValue();
    }

    public boolean containsKey(Object key) {
        Value<V> v = this.collectBuffer.get(key);
        if (v != null) {
            return !v.isRemove();
        }
        v = this.flushBuffer.get(key);
        return v != null && !v.isRemove();
    }

    public int getSize() {
        int size = 0;
        Map<K, Value<V>> localCollectingMap = this.collectBuffer;
        Map<K, Value<V>> localFlushMap = this.flushBuffer;
        for (Map.Entry<K, Value<Object>> e : localCollectingMap.entrySet()) {
            if (e.getValue() == null || e.getValue().isRemove()) continue;
            ++size;
        }
        for (Map.Entry<K, Value<Object>> e : localFlushMap.entrySet()) {
            if (e.getValue() == null || e.getValue().isRemove()) continue;
            ++size;
        }
        return size;
    }

    public void clear() {
        this.collectBuffer.clear();
        this.flushBuffer.clear();
        this.clearMap = true;
        this.pendingOpsSize.set(0L);
    }

    public Set<K> getKeys() {
        HashSet<K> keySet = new HashSet<K>(this.collectBuffer.keySet());
        keySet.addAll(this.flushBuffer.keySet());
        return keySet;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> rv = new HashSet<Map.Entry<K, V>>();
        this.addEntriesToSet(rv, this.collectBuffer);
        this.addEntriesToSet(rv, this.flushBuffer);
        return rv;
    }

    private void addEntriesToSet(Set<Map.Entry<K, V>> rv, Map<K, Value<V>> map) {
        for (Map.Entry<K, Value<V>> entry : map.entrySet()) {
            final K key = entry.getKey();
            Value<V> wrappedValue = entry.getValue();
            final V value = wrappedValue.getValue();
            if (wrappedValue.isRemove()) continue;
            rv.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V param) {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }

    public V put(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        Value<V> wrappedValue = new Value<V>(value, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
        Value<V> rv = this.collectBuffer.put(key, wrappedValue);
        if (rv == null) {
            this.throttleIfNecessary(this.pendingOpsSize.addAndGet(this.sizeOfEngine.sizeOf(key, wrappedValue, null).getCalculated()));
        }
        return rv == null ? null : (rv.isRemove() ? null : rv.getValue());
    }

    private void startThreadIfNecessary() {
        this.flushToServerThread.start();
    }

    private void throttleIfNecessary(long currentPendingSize) {
        while (currentPendingSize > this.throttlePutsByteSize) {
            this.sleepMillis(100L);
            currentPendingSize = this.pendingOpsSize.get();
        }
    }

    private void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Value<V> internalGetFromCollectingMap(K key) {
        return this.collectBuffer.get(key);
    }

    void internalPutInFlushBuffer(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.flushBuffer.put(key, new Value<V>(value, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds));
    }

    void allowFlushBufferWrites() {
        if (this.flushBuffer == EMPTY_MAP) {
            this.flushBuffer = this.newMap();
        }
    }

    public void dispose() {
        this.flushAndStopBuffering();
        this.flushToServerThread.markFinish();
    }

    public void shutdown() {
        this.flushToServerThread.markFinish();
    }

    public void startBuffering() {
        this.startThreadIfNecessary();
        if (this.flushToServerThread.isFinished()) {
            throw new AssertionError((Object)"Start Buffering called when flush thread has already finished");
        }
        this.flushToServerThread.unpause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndStopBuffering() {
        this.flushToServerThread.waitUntilFlushCompleteAndPause();
        this.switchBuffers(this.newMap());
        try {
            this.drainBufferToServer(this.flushBuffer);
        }
        finally {
            this.flushBuffer = EMPTY_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPeriodicFlush(FlushToServerThread thread) {
        Map<K, Value<V>> localMap = this.newMap();
        this.bulkLoadClusteredCache.acquireLocalWriteLock();
        try {
            if (!thread.markFlushInProgress()) {
                return;
            }
            this.switchBuffers(localMap);
        }
        finally {
            this.bulkLoadClusteredCache.releaseLocalWriteLock();
        }
        try {
            this.drainBufferToServer(this.flushBuffer);
        }
        finally {
            this.flushBuffer = EMPTY_MAP;
            thread.markFlushComplete();
        }
    }

    private void switchBuffers(Map<K, Value<V>> newBuffer) {
        this.flushBuffer = this.collectBuffer;
        this.collectBuffer = newBuffer;
        this.pendingOpsSize.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainBufferToServer(Map<K, Value<V>> buffer) {
        this.clearIfNecessary();
        Set<Map.Entry<K, Value<V>>> entrySet = buffer.entrySet();
        if (entrySet.isEmpty()) {
            return;
        }
        Lock lock = this.concurrentTransactionLock;
        lock.lock();
        try {
            for (Map.Entry<K, Value<V>> e : entrySet) {
                Value<V> value = e.getValue();
                K key = e.getKey();
                if (value.isRemove()) {
                    this.backend.unlockedRemoveNoReturn(key);
                    continue;
                }
                this.backend.unlockedPutNoReturn(key, value.getValue(), value.getCreateTimeInSecs(), value.getCustomMaxTTISeconds(), value.getCustomMaxTTLSeconds());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIfNecessary() {
        if (this.clearMap) {
            Lock lock = this.concurrentTransactionLock;
            lock.lock();
            try {
                this.backend.clear();
            }
            finally {
                lock.unlock();
                this.clearMap = false;
            }
        }
    }

    public boolean isKeyBeingRemoved(Object obj) {
        Value<V> v = this.collectBuffer.get(obj);
        return v != null && v.isRemove();
    }

    static class RemoveValue<T>
    extends Value<T> {
        public RemoveValue() {
            super(null, -1, -1, -1);
        }

        @Override
        boolean isRemove() {
            return true;
        }
    }

    static class Value<T> {
        private final T value;
        private final int createTimeInSecs;
        private final int customMaxTTISeconds;
        private final int customMaxTTLSeconds;

        Value(T value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
            this.value = value;
            this.createTimeInSecs = createTimeInSecs;
            this.customMaxTTISeconds = customMaxTTISeconds;
            this.customMaxTTLSeconds = customMaxTTLSeconds;
        }

        T getValue() {
            return this.value;
        }

        boolean isRemove() {
            return false;
        }

        public int getCreateTimeInSecs() {
            return this.createTimeInSecs;
        }

        public int getCustomMaxTTISeconds() {
            return this.customMaxTTISeconds;
        }

        public int getCustomMaxTTLSeconds() {
            return this.customMaxTTLSeconds;
        }
    }

    private static class FlushToServerThread
    extends Thread {
        private final LocalBufferedMap localBufferedMap;
        private State state = State.NOT_STARTED;

        public FlushToServerThread(String name, LocalBufferedMap localBufferedMap) {
            super(name);
            this.localBufferedMap = localBufferedMap;
        }

        public void unpause() {
            this.moveTo(State.PAUSED, State.SLEEP);
        }

        @Override
        public void run() {
            while (!this.isFinished()) {
                this.waitUntilNotPaused();
                if (this.localBufferedMap.pendingOpsSize.get() < (long)this.localBufferedMap.putsBatchByteSize) {
                    this.sleepFor(this.localBufferedMap.batchTimeMillis);
                }
                this.localBufferedMap.doPeriodicFlush(this);
            }
        }

        private void waitUntilNotPaused() {
            this.waitUntilStateChangesFrom(State.PAUSED);
        }

        private synchronized boolean isFinished() {
            return this.state == State.FINISHED;
        }

        public void markFinish() {
            this.moveTo(State.FINISHED);
        }

        public boolean markFlushInProgress() {
            return this.moveTo(State.SLEEP, State.FLUSH);
        }

        public boolean markFlushComplete() {
            return this.moveTo(State.FLUSH, State.SLEEP);
        }

        public synchronized void waitUntilFlushCompleteAndPause() {
            this.waitUntilStateChangesFrom(State.FLUSH);
            this.moveTo(State.SLEEP, State.PAUSED);
        }

        @Override
        public synchronized void start() {
            if (this.moveTo(State.NOT_STARTED, State.PAUSED)) {
                super.start();
            }
        }

        private void sleepFor(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private synchronized void waitUntilStateChangesFrom(State current) {
            while (this.state == current) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private synchronized void moveTo(State newState) {
            this.state = newState;
            this.notifyAll();
        }

        private synchronized boolean moveTo(State oldState, State newState) {
            if (this.state == oldState) {
                this.state = newState;
                this.notifyAll();
                return true;
            }
            return false;
        }

        static enum State {
            NOT_STARTED,
            PAUSED,
            SLEEP,
            FLUSH,
            FINISHED;

        }
    }
}

