/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.StripedReadWriteLock;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.AuthoritativeTier;
import net.sf.ehcache.store.CachingTier;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.StripedReadWriteLockProvider;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import net.sf.ehcache.writer.CacheWriterManager;
import org.terracotta.context.annotations.ContextChild;

public class CacheStore
implements Store {
    private static final int DEFAULT_LOCK_STRIPE_COUNT = 128;
    @ContextChild
    private final CachingTier<Object, Element> cachingTier;
    @ContextChild
    private final AuthoritativeTier authoritativeTier;
    @Deprecated
    private final StripedReadWriteLock masterLocks;
    @Deprecated
    private final CacheConfiguration cacheConfiguration;
    private volatile Status status;

    public CacheStore(CachingTier<Object, Element> cache, AuthoritativeTier authority) {
        this(cache, authority, null);
    }

    @Deprecated
    public CacheStore(CachingTier<Object, Element> cache, final AuthoritativeTier authority, CacheConfiguration cacheConfiguration) {
        if (cache == null || authority == null) {
            throw new NullPointerException();
        }
        this.cachingTier = cache;
        this.cacheConfiguration = cacheConfiguration;
        this.cachingTier.addListener(new CachingTier.Listener<Object, Element>(){

            @Override
            public void evicted(Object key, Element value) {
                authority.flush(value);
            }
        });
        this.authoritativeTier = authority;
        this.masterLocks = authority instanceof StripedReadWriteLockProvider ? ((StripedReadWriteLockProvider)((Object)authority)).createStripedReadWriteLock() : new StripedReadWriteLockSync(128);
        this.status = Status.STATUS_ALIVE;
    }

    @Override
    public void addStoreListener(StoreListener listener) {
        this.authoritativeTier.addStoreListener(listener);
    }

    @Override
    public void removeStoreListener(StoreListener listener) {
        this.authoritativeTier.removeStoreListener(listener);
    }

    @Override
    public boolean put(final Element element) throws CacheException {
        final boolean[] hack = new boolean[1];
        this.cachingTier.remove(element.getObjectKey());
        try {
            if (this.cachingTier.get(element.getObjectKey(), new Callable<Element>(){

                @Override
                public Element call() throws Exception {
                    hack[0] = CacheStore.this.authoritativeTier.putFaulted(element);
                    return element;
                }
            }, false) != element) {
                this.cachingTier.remove(element.getObjectKey());
                return this.authoritativeTier.put(element);
            }
        }
        catch (Throwable e) {
            this.cachingTier.remove(element.getObjectKey());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CacheException(e);
        }
        return hack[0];
    }

    @Override
    public void putAll(Collection<Element> elements) throws CacheException {
        for (Element element : elements) {
            this.put(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        try {
            boolean bl = this.authoritativeTier.putWithWriter(element, writerManager);
            return bl;
        }
        finally {
            this.cachingTier.remove(element.getObjectKey());
        }
    }

    @Override
    public Element get(final Object key) {
        if (key == null) {
            return null;
        }
        return this.cachingTier.get(key, new Callable<Element>(){

            @Override
            public Element call() throws Exception {
                return CacheStore.this.authoritativeTier.fault(key, true);
            }
        }, true);
    }

    @Override
    public Element getQuiet(final Object key) {
        if (key == null) {
            return null;
        }
        return this.cachingTier.get(key, new Callable<Element>(){

            @Override
            public Element call() throws Exception {
                return CacheStore.this.authoritativeTier.fault(key, false);
            }
        }, false);
    }

    @Override
    public List getKeys() {
        return this.authoritativeTier.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        try {
            Element element = this.authoritativeTier.remove(key);
            return element;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    @Override
    public void removeAll(Collection<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        try {
            Element element = this.authoritativeTier.removeWithWriter(key, writerManager);
            return element;
        }
        finally {
            this.cachingTier.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws CacheException {
        try {
            this.authoritativeTier.removeAll();
        }
        finally {
            this.cachingTier.clear();
        }
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        Element previous = this.authoritativeTier.putIfAbsent(element);
        if (previous == null) {
            this.cachingTier.remove(element.getObjectKey());
        }
        return previous;
    }

    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        Element removedElement = this.authoritativeTier.removeElement(element, comparator);
        this.cachingTier.remove(removedElement.getObjectKey());
        return removedElement;
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        boolean replaced = this.authoritativeTier.replace(old, element, comparator);
        if (replaced) {
            this.cachingTier.remove(element.getObjectKey());
        }
        return replaced;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        Element previous = this.authoritativeTier.replace(element);
        if (previous != null) {
            this.cachingTier.remove(previous.getObjectKey());
        }
        return previous;
    }

    @Override
    public synchronized void dispose() {
        if (this.status == Status.STATUS_SHUTDOWN) {
            return;
        }
        if (this.cacheConfiguration != null && this.cacheConfiguration.isClearOnFlush()) {
            this.cachingTier.clear();
        }
        this.authoritativeTier.dispose();
        this.status = Status.STATUS_SHUTDOWN;
    }

    @Override
    public int getSize() {
        return this.authoritativeTier.getSize();
    }

    @Override
    public int getInMemorySize() {
        return this.cachingTier.getInMemorySize() + this.authoritativeTier.getInMemorySize();
    }

    @Override
    public int getOffHeapSize() {
        return this.cachingTier.getOffHeapSize() + this.authoritativeTier.getOffHeapSize();
    }

    @Override
    public int getOnDiskSize() {
        return this.authoritativeTier.getOnDiskSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.cachingTier.getInMemorySizeInBytes() + this.authoritativeTier.getInMemorySizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.cachingTier.getOffHeapSizeInBytes() + this.authoritativeTier.getOffHeapSizeInBytes();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.cachingTier.getOnDiskSizeInBytes() + this.authoritativeTier.getOnDiskSizeInBytes();
    }

    @Override
    public boolean hasAbortedSizeOf() {
        return this.authoritativeTier.hasAbortedSizeOf();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.authoritativeTier.containsKey(key);
    }

    @Override
    @Deprecated
    public boolean containsKeyOnDisk(Object key) {
        return this.authoritativeTier.containsKeyOnDisk(key);
    }

    @Override
    @Deprecated
    public boolean containsKeyOffHeap(Object key) {
        return this.authoritativeTier.containsKeyOffHeap(key);
    }

    @Override
    @Deprecated
    public boolean containsKeyInMemory(Object key) {
        return this.cachingTier.contains(key);
    }

    @Override
    public void expireElements() {
        this.authoritativeTier.expireElements();
    }

    @Override
    public void flush() throws IOException {
        if (this.cacheConfiguration != null && this.cacheConfiguration.isClearOnFlush()) {
            this.cachingTier.clear();
        }
        this.authoritativeTier.flush();
    }

    @Override
    public boolean bufferFull() {
        return this.authoritativeTier.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        throw new UnsupportedOperationException("Someone... i.e. YOU! should think about implementing this someday!");
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        throw new UnsupportedOperationException("Someone... i.e. YOU! should think about implementing this someday!");
    }

    @Override
    @Deprecated
    public Object getInternalContext() {
        return this.masterLocks;
    }

    @Override
    public boolean isCacheCoherent() {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public boolean isClusterCoherent() throws TerracottaNotRunningException {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public boolean isNodeCoherent() throws TerracottaNotRunningException {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException, TerracottaNotRunningException {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException, TerracottaNotRunningException, InterruptedException {
        throw new UnsupportedOperationException("No such thing for non clustered stores!");
    }

    @Override
    public Object getMBean() {
        return this.authoritativeTier.getMBean();
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.authoritativeTier.setAttributeExtractors(extractors);
    }

    @Override
    public Results executeQuery(StoreQuery query) throws SearchException {
        return this.authoritativeTier.executeQuery(query);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        return this.authoritativeTier.getSearchAttribute(attributeName);
    }

    @Override
    public Map<Object, Element> getAllQuiet(Collection<?> keys) {
        HashMap<Object, Element> result = new HashMap<Object, Element>();
        for (Object key : keys) {
            result.put(key, this.getQuiet(key));
        }
        return result;
    }

    @Override
    public Map<Object, Element> getAll(Collection<?> keys) {
        HashMap<Object, Element> result = new HashMap<Object, Element>();
        for (Object key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public void recalculateSize(Object key) {
        this.cachingTier.recalculateSize(key);
    }
}

