/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.extended;

import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.statistics.extended.AbstractStatistic;
import org.terracotta.statistics.SourceStatistic;
import org.terracotta.statistics.derived.EventRateSimpleMovingAverage;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.OperationObserver;

public class RateStatistic<T extends Enum<T>>
extends AbstractStatistic<Double> {
    private final SourceStatistic<OperationObserver<T>> source;
    private final OperationObserver<T> rateObserver;
    private final EventRateSimpleMovingAverage rate;

    public RateStatistic(SourceStatistic<OperationObserver<T>> statistic, Set<T> targets, long averageNanos, ScheduledExecutorService executor, int historySize, long historyNanos) {
        super(executor, historySize, historyNanos);
        this.source = statistic;
        this.rate = new EventRateSimpleMovingAverage(averageNanos, TimeUnit.NANOSECONDS);
        this.rateObserver = new OperationResultFilter<T>(targets, this.rate);
    }

    void setWindow(long averageNanos) {
        this.rate.setWindow(averageNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    void stopStatistic() {
        this.source.removeDerivedStatistic(this.rateObserver);
    }

    @Override
    void startStatistic() {
        this.source.addDerivedStatistic(this.rateObserver);
    }

    @Override
    Double readStatistic() {
        return this.rate.value();
    }
}

