/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolEvictor;
import net.sf.ehcache.pool.PoolParticipant;
import net.sf.ehcache.pool.SizeOfEngine;

public abstract class AbstractPool
implements Pool {
    private volatile long maximumPoolSize;
    private final PoolEvictor evictor;
    private final List<PoolAccessor> poolAccessors;
    private final SizeOfEngine defaultSizeOfEngine;

    public AbstractPool(long maximumPoolSize, PoolEvictor evictor, SizeOfEngine defaultSizeOfEngine) {
        this.maximumPoolSize = maximumPoolSize;
        this.evictor = evictor;
        this.defaultSizeOfEngine = defaultSizeOfEngine;
        this.poolAccessors = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public long getSize() {
        long total = 0L;
        for (PoolAccessor poolAccessor : this.poolAccessors) {
            total += poolAccessor.getSize();
        }
        return total;
    }

    @Override
    public long getMaxSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setMaxSize(long newSize) {
        long oldSize = this.maximumPoolSize;
        this.maximumPoolSize = newSize;
        long sizeToEvict = oldSize - newSize;
        if (sizeToEvict > 0L) {
            this.evictor.freeSpace(this.poolAccessors, sizeToEvict);
        }
    }

    @Override
    public PoolAccessor createPoolAccessor(PoolParticipant participant, int maxDepth, boolean abortWhenMaxDepthExceeded) {
        return this.createPoolAccessor(participant, this.defaultSizeOfEngine.copyWith(maxDepth, abortWhenMaxDepthExceeded));
    }

    @Override
    public void registerPoolAccessor(PoolAccessor accessor) {
        this.poolAccessors.add(accessor);
    }

    @Override
    public void removePoolAccessor(PoolAccessor accessor) {
        Iterator<PoolAccessor> iterator = this.poolAccessors.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != accessor) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public Collection<PoolAccessor> getPoolAccessors() {
        return Collections.unmodifiableList(this.poolAccessors);
    }

    @Override
    public PoolEvictor getEvictor() {
        return this.evictor;
    }
}

