/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

public class FormattingPreferences {
    public static final String IGNORE = "IGNORE";
    public static final String WARN = "WARN";
    public static final String FAIL = "FAIL";
    private int maxLineLength = 120;
    private boolean wrapLongLines = true;
    private boolean tabInsteadOfSpaces = true;
    private int tabWidth = 4;
    private boolean splitMultiAttrs = false;
    private String wellFormedValidation = "WARN";

    public void setMaxLineLength(Integer maxLineLength) {
        if (maxLineLength != null) {
            this.maxLineLength = maxLineLength;
        }
    }

    public void setWrapLongLines(Boolean wrapLongLines) {
        if (wrapLongLines != null) {
            this.wrapLongLines = wrapLongLines;
        }
    }

    public void setTabInsteadOfSpaces(Boolean tabInsteadOfSpaces) {
        if (tabInsteadOfSpaces != null) {
            this.tabInsteadOfSpaces = tabInsteadOfSpaces;
        }
    }

    public String getCanonicalIndent() {
        String canonicalIndent;
        if (this.useTabInsteadOfSpaces()) {
            canonicalIndent = "\t";
        } else {
            String tab = "";
            for (int i = 0; i < this.getTabWidth(); ++i) {
                tab = tab.concat(" ");
            }
            canonicalIndent = tab;
        }
        return canonicalIndent;
    }

    public int getMaximumLineWidth() {
        return this.maxLineLength;
    }

    public boolean wrapLongTags() {
        return this.wrapLongLines;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(Integer tabWidth) {
        if (tabWidth != null) {
            this.tabWidth = tabWidth;
        }
    }

    public boolean useTabInsteadOfSpaces() {
        return this.tabInsteadOfSpaces;
    }

    public boolean isSplitMultiAttrs() {
        return this.splitMultiAttrs;
    }

    public void setSplitMultiAttrs(Boolean setSplitMultiAttrs) {
        if (setSplitMultiAttrs != null) {
            this.splitMultiAttrs = setSplitMultiAttrs;
        }
    }

    public String getWellFormedValidation() {
        return this.wellFormedValidation;
    }

    public void setWellFormedValidation(String wellFormedValidation) {
        if (!(wellFormedValidation.equals(IGNORE) || wellFormedValidation.equals(FAIL) || wellFormedValidation.equals(WARN))) {
            throw new IllegalArgumentException("Invalid configuration value for well formed validation: " + wellFormedValidation);
        }
        this.wellFormedValidation = wellFormedValidation;
    }
}

