/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cluster;

import java.net.URL;
import java.util.Properties;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.cluster.ClusterPolicy;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsClusterPolicy
extends ReceiverAdapter
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(JGroupsClusterPolicy.class);
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private String configXml;
    private JChannel channel;
    private String name;
    private CacheProviderHolder holder;

    public JGroupsClusterPolicy(String name, Properties props) {
        this.name = name;
        if (this.name == null || this.name.trim().equalsIgnoreCase("")) {
            this.name = "j2cache";
        }
        this.configXml = props.getProperty("configXml");
        if (this.configXml == null || this.configXml.trim().length() == 0) {
            this.configXml = "/network.xml";
        }
    }

    @Override
    public boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    @Override
    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    @Override
    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    @Override
    public void connect(Properties props, CacheProviderHolder holder) {
        this.holder = holder;
        try {
            long ct = System.currentTimeMillis();
            URL xml = this.getClass().getResource(this.configXml);
            if (xml == null) {
                xml = this.getClass().getClassLoader().getParent().getResource(this.configXml);
            }
            this.channel = new JChannel(xml);
            this.channel.setReceiver((Receiver)this);
            this.channel.connect(this.name);
            this.publish(Command.join());
            log.info("Connected to jgroups channel:{}, time {}ms.", (Object)this.name, (Object)(System.currentTimeMillis() - ct));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void disconnect() {
        this.publish(Command.quit());
        this.channel.close();
    }

    public void receive(Message msg) {
        if (msg.getSrc().equals(this.channel.getAddress())) {
            return;
        }
        this.handleCommand(Command.parse((String)msg.getObject()));
    }

    public void viewAccepted(View view) {
        log.info("Group Members Changed, LIST: {}", (Object)String.join((CharSequence)",", (CharSequence[])view.getMembers().stream().map(a -> a.toString()).toArray(String[]::new)));
    }

    @Override
    public void publish(Command cmd) {
        try {
            cmd.setSrc(this.LOCAL_COMMAND_ID);
            Message msg = new Message(null, (Object)cmd.json());
            this.channel.send(msg);
        }
        catch (Exception e) {
            log.error("Failed to send message to jgroups -> {}", (Object)cmd, (Object)e);
        }
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

