/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.util.DeserializeException;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Level2Cache
extends Cache {
    public static final Logger log = LoggerFactory.getLogger(Level2Cache.class);

    default public boolean supportTTL() {
        return false;
    }

    public byte[] getBytes(String var1);

    public List<byte[]> getBytes(Collection<String> var1);

    public void setBytes(String var1, byte[] var2);

    public void setBytes(Map<String, byte[]> var1);

    default public void setBytes(String key, byte[] bytes, long timeToLiveInSeconds) {
        this.setBytes(key, bytes);
    }

    default public void setBytes(Map<String, byte[]> bytes, long timeToLiveInSeconds) {
        this.setBytes(bytes);
    }

    @Override
    default public boolean exists(String key) {
        return this.getBytes(key) != null;
    }

    @Override
    public Collection<String> keys();

    @Override
    public void evict(String ... var1);

    @Override
    public void clear();

    @Override
    default public Object get(String key) {
        byte[] bytes = this.getBytes(key);
        try {
            return SerializationUtils.deserialize(bytes);
        }
        catch (DeserializeException e) {
            log.warn("Failed to deserialize object with key:" + key + ",message: " + e.getMessage());
            this.evict(key);
            return null;
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    @Override
    default public Map<String, Object> get(Collection<String> keys) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (keys.size() > 0) {
            List<byte[]> bytes = this.getBytes(keys);
            int i = 0;
            for (String key : keys) {
                try {
                    results.put(key, SerializationUtils.deserialize(bytes.get(i++)));
                }
                catch (DeserializeException e) {
                    log.warn("Failed to deserialize object with key:" + key + ",message: " + e.getMessage());
                    this.evict(key);
                    return null;
                }
                catch (IOException e) {
                    throw new CacheException(e);
                }
            }
        }
        return results;
    }

    @Override
    default public void put(String key, Object value) {
        try {
            this.setBytes(key, SerializationUtils.serialize(value));
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    default public void put(String key, Object value, long timeToLiveInSeconds) {
        try {
            this.setBytes(key, SerializationUtils.serialize(value), timeToLiveInSeconds);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    @Override
    default public void put(Map<String, Object> elements) {
        if (elements.size() > 0) {
            this.setBytes(elements.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> SerializationUtils.serializeWithoutException(p.getValue()))));
        }
    }

    default public void put(Map<String, Object> elements, long timeToLiveInSeconds) {
        if (elements.size() > 0) {
            this.setBytes(elements.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> SerializationUtils.serializeWithoutException(p.getValue()))), timeToLiveInSeconds);
        }
    }
}

