/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.ClusterPolicyFactory;
import net.oschina.j2cache.J2CacheConfig;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2CacheBuilder {
    private static final Logger log = LoggerFactory.getLogger(J2CacheBuilder.class);
    private CacheChannel channel;
    private ClusterPolicy policy;

    private J2CacheBuilder(J2CacheConfig config) {
        this.initFromConfig(config);
        this.channel = new CacheChannel(config){

            @Override
            public void sendClearCmd(String region) {
                J2CacheBuilder.this.policy.sendClearCmd(region);
            }

            @Override
            public void sendEvictCmd(String region, String ... keys) {
                J2CacheBuilder.this.policy.sendEvictCmd(region, keys);
            }

            @Override
            public void close() {
                J2CacheBuilder.this.policy.disconnect();
                CacheProviderHolder.shutdown();
            }
        };
    }

    public static final J2CacheBuilder init(J2CacheConfig config) {
        return new J2CacheBuilder(config);
    }

    public CacheChannel getChannel() {
        return this.channel;
    }

    public void close() {
        this.channel.close();
    }

    private void initFromConfig(J2CacheConfig config) {
        SerializationUtils.init(config.getSerialization());
        CacheProviderHolder.init(config, (region, key) -> {
            Level2Cache level2 = CacheProviderHolder.getLevel2Cache(region);
            level2.evict(key);
            if (!level2.supportTTL()) {
                CacheProviderHolder.getLevel1Cache(region).evict(key);
            }
            log.debug(String.format("Level 1 cache object expired, evict level 2 cache object [%s,%s]", region, key));
            if (this.policy != null) {
                this.policy.sendEvictCmd(region, key);
            }
        });
        this.policy = ClusterPolicyFactory.init(config.getBroadcast(), config.getBroadcastProperties());
        log.info("Using cluster policy : " + this.policy.getClass().getName());
    }
}

