/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;

public class MyBeanUtil
extends BeanUtils {
    private static final String PREFIX_SET = "set";

    public static void copyProperties(Object source, Object target) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = MyBeanUtil.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = MyBeanUtil.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target field name mismatch:" + targetPd.getName(), ex);
            }
        }
    }

    public static void copyProperties(Map<String, Object> map, Object target) {
        Assert.notNull(map, (String)"map must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        if (target instanceof Map) {
            Map targetMap = (Map)target;
            try {
                targetMap.putAll(map);
            }
            catch (Exception e) {
                throw new FatalBeanException("target\u7684key\u7c7b\u578b\u5fc5\u987b\u4e3aString\uff0cvalue\u7c7b\u578b\u4e3aObject");
            }
        } else {
            Set<Map.Entry<String, Object>> entrySet = map.entrySet();
            Class<?> targetClass = target.getClass();
            for (Map.Entry<String, Object> entry : entrySet) {
                Method[] methods;
                String propertyName = entry.getKey();
                Object val = entry.getValue();
                for (Method method : methods = targetClass.getDeclaredMethods()) {
                    boolean canCopy;
                    String methodName = method.getName();
                    Class<?>[] methodParams = method.getParameterTypes();
                    if (!methodName.startsWith(PREFIX_SET)) continue;
                    boolean bl = canCopy = propertyName.equals(MyBeanUtil.buildFieldName(methodName)) && methodParams.length == 1 && methodParams[0].isInstance(val);
                    if (!canCopy) continue;
                    try {
                        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                            method.setAccessible(true);
                        }
                        method.invoke(target, val);
                    }
                    catch (Throwable ex) {
                        throw new FatalBeanException("Could not copy property '" + propertyName + "' from map to target", ex);
                    }
                }
            }
        }
    }

    private static String buildFieldName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }
}

