/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.PageInfo;
import com.gitee.fastmybatis.core.PageResult;
import com.gitee.fastmybatis.core.mapper.SchMapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.param.BaseParam;
import java.util.Collections;
import java.util.List;

public class MapperUtil {
    private static int calcPageCount(long total, int pageSize) {
        return (int)(pageSize == 0 ? 1L : (total + (long)pageSize - 1L) / (long)pageSize);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Object bean) {
        return MapperUtil.query(mapper, Query.build(bean), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, BaseParam searchParam) {
        return MapperUtil.query(mapper, Query.build(searchParam), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Query query) {
        return MapperUtil.query(mapper, query, PageInfo.class);
    }

    public static <Entity, T extends PageResult<Entity>> T query(SchMapper<Entity, ?> mapper, Query query, Class<T> pageResultClass) {
        PageResult result = null;
        try {
            result = (PageResult)pageResultClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            long total = 0L;
            List<Object> list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = mapper.list(query);
                total = list.size();
            } else {
                total = mapper.getCount(query);
                if (total > 0L) {
                    list = mapper.list(query);
                    int start = query.getStart();
                    int pageSize = query.getLimit();
                    int pageIndex = start / pageSize + 1;
                    result.setStart(start);
                    result.setPageIndex(pageIndex);
                    result.setPageSize(pageSize);
                    int pageCount = MapperUtil.calcPageCount(total, pageSize);
                    result.setPageCount(pageCount);
                }
            }
            result.setList(list);
            result.setTotal(total);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }
}

