/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.util.MyBeanUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtil {
    private static final String PREFIX_GET = "get";

    private ClassUtil() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperInterfaceGenricType(Class<?> clazz, int index) {
        Type[] interfacesTypes = clazz.getGenericInterfaces();
        if (interfacesTypes.length == 0) {
            return Object.class;
        }
        Type firstInterface = interfacesTypes[0];
        Type[] params = ((ParameterizedType)firstInterface).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static String getClassSimpleName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public static Map<String, Object> pojoToMap(Object pojo) {
        if (pojo == null) {
            return Collections.emptyMap();
        }
        Method[] methods = pojo.getClass().getDeclaredMethods();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodName.startsWith(PREFIX_GET) || method.getParameterTypes().length != 0) continue;
                String fieldName = ClassUtil.buildFieldName(methodName);
                Object value = method.invoke(pojo, new Object[0]);
                map.put(fieldName, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("pojoToMap\u5931\u8d25", e);
        }
        return map;
    }

    public static <T> List<T> mapListToObjList(List<Map<String, Object>> list, Class<T> pojoClass) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<T> retList = new ArrayList<T>(list.size());
        for (Map<String, Object> map : list) {
            retList.add(ClassUtil.mapToPojo(map, pojoClass));
        }
        return retList;
    }

    public static <T> T mapToPojo(Map<String, Object> map, Class<T> pojoClass) {
        try {
            T target = pojoClass.newInstance();
            MyBeanUtil.copyProperties(map, target);
            return target;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316\u5931\u8d25", e);
        }
    }

    public static boolean isArrayOrCollection(Object value) {
        boolean ret = false;
        if (value.getClass().isArray()) {
            ret = true;
        } else if (value instanceof Collection) {
            ret = true;
        }
        return ret;
    }

    private static String buildFieldName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }
}

