/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.expression.builder;

import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.builder.ExpressionBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;

public class ConditionBuilder {
    private static final String PREFIX_GET = "get";
    private static final String GETCLASS_NAME = "getClass";
    private static ConditionBuilder underlineFieldBuilder = new ConditionBuilder(true);
    private static ConditionBuilder camelFieldBuilder = new ConditionBuilder(false);
    private boolean camel2underline = Boolean.TRUE;

    public ConditionBuilder() {
    }

    public ConditionBuilder(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public static ConditionBuilder getUnderlineFieldBuilder() {
        return underlineFieldBuilder;
    }

    public static ConditionBuilder getCamelFieldBuilder() {
        return camelFieldBuilder;
    }

    public List<Expression> buildExpressions(Object obj) {
        Assert.notNull((Object)obj, (String)"buildExpressions(Object obj) obj can't be null.");
        ArrayList<Expression> expList = new ArrayList<Expression>();
        Method[] methods = obj.getClass().getMethods();
        try {
            for (Method method : methods) {
                Expression expression;
                Object value;
                if (!ConditionBuilder.couldBuildExpression(method) || (value = method.invoke(obj, new Object[0])) == null || (expression = this.buildExpression(method, value)) == null) continue;
                expList.add(expression);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return expList;
    }

    private Expression buildExpression(Method method, Object value) {
        Condition annotation = method.getAnnotation(Condition.class);
        String columnName = this.buildColumnName(method);
        Expression expression = null;
        expression = annotation == null ? (value.getClass().isArray() ? Expressions.in(columnName, (Object[])value) : (value instanceof Collection ? Expressions.in(columnName, (Collection)value) : Expressions.eq(columnName, value))) : ExpressionBuilder.buildExpression(annotation, columnName, value);
        return expression;
    }

    private String buildColumnName(Method method) {
        String getMethodName = method.getName();
        String columnName = getMethodName.substring(3);
        columnName = FieldUtil.lowerFirstLetter(columnName);
        if (this.camel2underline) {
            return FieldUtil.camelToUnderline(columnName);
        }
        return columnName;
    }

    private static boolean couldBuildExpression(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        String methodName = method.getName();
        return !GETCLASS_NAME.equals(methodName) && methodName.startsWith(PREFIX_GET);
    }
}

