/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query;

import com.gitee.fastmybatis.core.query.Queryable;
import com.gitee.fastmybatis.core.query.Sort;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.ExpressionJoinable;
import com.gitee.fastmybatis.core.query.expression.ExpressionListable;
import com.gitee.fastmybatis.core.query.expression.ExpressionSqlable;
import com.gitee.fastmybatis.core.query.expression.ExpressionValueable;
import com.gitee.fastmybatis.core.query.expression.Expressional;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.ValueConvert;
import com.gitee.fastmybatis.core.query.expression.builder.ConditionBuilder;
import com.gitee.fastmybatis.core.query.param.BaseParam;
import com.gitee.fastmybatis.core.query.param.SchPageableParam;
import com.gitee.fastmybatis.core.query.param.SchSortableParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Query
implements Queryable {
    private static final String REG_SQL_INJECT = "([';*--|])+";
    private int start;
    private int limit;
    private LinkedHashSet<String> orderInfo;
    private Map<String, Object> paramMap;
    private boolean forceQuery;
    private List<ExpressionValueable> valueExpressions;
    private List<ExpressionJoinable> joinExpressions;
    private List<ExpressionListable> listExpressions;
    private List<ExpressionSqlable> sqlExpressions;

    public Query eq(String columnName, Object value) {
        this.addExpression(Expressions.eq(columnName, value));
        return this;
    }

    public Query notEq(String columnName, Object value) {
        this.addExpression(Expressions.notEq(columnName, value));
        return this;
    }

    public Query gt(String columnName, Object value) {
        this.addExpression(Expressions.gt(columnName, value));
        return this;
    }

    public Query ge(String columnName, Object value) {
        this.addExpression(Expressions.ge(columnName, value));
        return this;
    }

    public Query lt(String columnName, Object value) {
        this.addExpression(Expressions.lt(columnName, value));
        return this;
    }

    public Query le(String columnName, Object value) {
        this.addExpression(Expressions.le(columnName, value));
        return this;
    }

    public Query like(String columnName, String value) {
        this.addExpression(Expressions.like(columnName, value));
        return this;
    }

    public Query likeLeft(String columnName, String value) {
        this.addExpression(Expressions.likeLeft(columnName, value));
        return this;
    }

    public Query likeRight(String columnName, String value) {
        this.addExpression(Expressions.likeRight(columnName, value));
        return this;
    }

    public Query in(String columnName, Collection<?> value) {
        this.addExpression(Expressions.in(columnName, value));
        return this;
    }

    public <T> Query in(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.in(columnName, value, valueConvert));
        return this;
    }

    public Query in(String columnName, Object[] value) {
        this.addExpression(Expressions.in(columnName, value));
        return this;
    }

    public Query notIn(String columnName, Collection<?> value) {
        this.addExpression(Expressions.notIn(columnName, value));
        return this;
    }

    public <T> Query notIn(String columnName, Collection<T> value, ValueConvert<T> valueConvert) {
        this.addExpression(Expressions.notIn(columnName, value, valueConvert));
        return this;
    }

    public Query notIn(String columnName, Object[] value) {
        this.addExpression(Expressions.notIn(columnName, value));
        return this;
    }

    public Query sql(String sql) {
        this.addExpression(Expressions.sql(sql));
        return this;
    }

    public Query notNull(String column) {
        return this.sql(column + " IS NOT NULL");
    }

    public Query isNull(String column) {
        return this.sql(column + " IS NULL");
    }

    public Query notEmpty(String column) {
        return this.sql(column + " IS NOT NULL AND " + column + " <> '' ");
    }

    public Query isEmpty(String column) {
        return this.sql(column + " IS NULL OR " + column + " = '' ");
    }

    public Query oneEqTwo() {
        return this.sql("1=2");
    }

    public Query join(String joinSql) {
        this.addExpression(Expressions.join(joinSql));
        return this;
    }

    public Query allEq(LinkedHashMap<String, Object> map) {
        Set<String> keys = map.keySet();
        for (String columnName : keys) {
            this.eq(columnName, map.get(columnName));
        }
        return this;
    }

    public Query page(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            throw new IllegalArgumentException("pageIndex\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        int start = (pageIndex - 1) * pageSize;
        int offset = pageSize;
        return this.limit(start, offset);
    }

    public Query limit(int start, int offset) {
        if (offset == 0) {
            this.setQueryAll(true);
            return this;
        }
        if (start < 0) {
            throw new IllegalArgumentException("public Query limit(int start, int offset)\u65b9\u6cd5start\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (offset < 1) {
            throw new IllegalArgumentException("public Query limit(int start, int offset)\u65b9\u6cd5offset\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
        }
        this.start = start;
        this.limit = offset;
        return this;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public Query orderby(String sortname, Sort sort) {
        return this.addSort(sortname, sort);
    }

    public Query addSort(String sortname) {
        return this.addSort(sortname, "ASC");
    }

    public Query addSort(String sortname, Sort sort) {
        return this.addSort(sortname, sort.name());
    }

    private Query addSort(String sortname, String sortorder) {
        if (sortname != null && sortname.length() > 0) {
            if (this.orderInfo == null) {
                this.orderInfo = new LinkedHashSet();
            }
            sortname = sortname.replace(REG_SQL_INJECT, "");
            if (!"DESC".equalsIgnoreCase(sortorder)) {
                sortorder = "ASC";
            }
            this.orderInfo.add(sortname + " " + sortorder);
        }
        return this;
    }

    @Override
    public boolean getOrderable() {
        return this.orderInfo != null;
    }

    @Override
    public String getOrder() {
        if (this.orderInfo == null) {
            throw new NullPointerException("orderInfo\u4e3a\u7a7a,\u5fc5\u987b\u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5.");
        }
        StringBuilder sb = new StringBuilder();
        for (String order : this.orderInfo) {
            sb.append(",").append(order);
        }
        if (sb.length() > 0) {
            return sb.toString().substring(1);
        }
        return "";
    }

    public Query addAnnotionExpression(Object searchEntity) {
        Query.bindExpressionsFromBean(searchEntity, this);
        return this;
    }

    public Query addPaginationInfo(SchPageableParam searchEntity) {
        int start = searchEntity.getStart();
        int limit = searchEntity.getLimit();
        return this.limit(start, limit);
    }

    public Query addSortInfo(SchSortableParam searchEntity) {
        this.addSort(searchEntity.getDBSortname(), searchEntity.getSortorder());
        return this;
    }

    public static Query build(Object searchEntity) {
        if (searchEntity instanceof BaseParam) {
            return ((BaseParam)searchEntity).toQuery();
        }
        return Query.buildFromBean(searchEntity);
    }

    private static Query buildFromBean(Object bean) {
        Query query = new Query();
        Query.bindExpressionsFromBean(bean, query);
        return query;
    }

    private static void bindExpressionsFromBean(Object bean, Query query) {
        List<Expression> expresList = ConditionBuilder.getUnderlineFieldBuilder().buildExpressions(bean);
        for (Expression expression : expresList) {
            query.addExpression(expression);
        }
    }

    public static Query buildFromBeanByProperty(Object bean) {
        Query query = new Query();
        List<Expression> expresList = ConditionBuilder.getCamelFieldBuilder().buildExpressions(bean);
        for (Expression expression : expresList) {
            query.addExpression(expression);
        }
        return query;
    }

    @Override
    public Expressional addExpression(Expression expression) {
        if (expression instanceof ExpressionValueable) {
            if (this.valueExpressions == null) {
                this.valueExpressions = new ArrayList<ExpressionValueable>();
            }
            this.valueExpressions.add((ExpressionValueable)expression);
        } else if (expression instanceof ExpressionListable) {
            if (this.listExpressions == null) {
                this.listExpressions = new ArrayList<ExpressionListable>();
            }
            this.listExpressions.add((ExpressionListable)expression);
        } else if (expression instanceof ExpressionJoinable) {
            if (this.joinExpressions == null) {
                this.joinExpressions = new ArrayList<ExpressionJoinable>();
            }
            this.joinExpressions.add((ExpressionJoinable)expression);
        } else if (expression instanceof ExpressionSqlable) {
            if (this.sqlExpressions == null) {
                this.sqlExpressions = new ArrayList<ExpressionSqlable>();
            }
            this.sqlExpressions.add((ExpressionSqlable)expression);
        }
        return this;
    }

    public void addAll(List<Expression> expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                this.addExpression(expression);
            }
        }
    }

    public Query addParam(String name, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<String, Object>(16);
        }
        this.paramMap.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getParam() {
        return this.paramMap;
    }

    @Override
    public boolean getIsQueryAll() {
        return this.limit == 0;
    }

    public Query setQueryAll(boolean queryAll) {
        if (queryAll) {
            this.limit = 0;
        }
        return this;
    }

    @Override
    public List<ExpressionValueable> getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public List<ExpressionJoinable> getJoinExpressions() {
        return this.joinExpressions;
    }

    @Override
    public List<ExpressionListable> getListExpressions() {
        return this.listExpressions;
    }

    @Override
    public List<ExpressionSqlable> getSqlExpressions() {
        return this.sqlExpressions;
    }

    public boolean getForceQuery() {
        return this.forceQuery;
    }

    public Query enableForceQuery() {
        this.forceQuery = true;
        return this;
    }

    public Query disableForceQuery() {
        this.forceQuery = false;
        return this;
    }
}

