/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;

public abstract class AbstractTypeHandlerAdapter<T>
extends BaseTypeHandler<T> {
    protected abstract T convertValue(Object var1);

    protected abstract Object getFillValue(T var1);

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.convertValue(rs.getObject(columnName));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.convertValue(rs.getObject(columnIndex));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.convertValue(cs.getObject(columnIndex));
    }

    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new TypeException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            try {
                this.setNullParameter(ps, i, parameter, jdbcType);
            }
            catch (SQLException e) {
                throw new TypeException("Error setting null for parameter #" + i + " with JdbcType " + jdbcType + " . " + "Try setting a different JdbcType for this parameter or a different jdbcTypeForNull configuration property. " + "Cause: " + e, (Throwable)e);
            }
        }
        try {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
        catch (Exception e) {
            throw new TypeException("Error setting non null for parameter #" + i + " with JdbcType " + jdbcType + " . " + "Try setting a different JdbcType for this parameter or a different configuration property. " + "Cause: " + e, (Throwable)e);
        }
    }

    protected void setNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        this.setParameterValue(ps, i, parameter, jdbcType);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        this.setParameterValue(ps, i, parameter, jdbcType);
    }

    protected void setParameterValue(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        Object val = this.getFillValue(parameter);
        if (val == null) {
            ps.setNull(i, jdbcType.TYPE_CODE);
        } else if (val instanceof Date) {
            Timestamp date = new Timestamp(((Date)val).getTime());
            ps.setTimestamp(i, date);
        } else {
            ps.setObject(i, val);
        }
    }

    protected void setParameterDefault(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        super.setParameter(ps, i, parameter, jdbcType);
    }
}

