/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.code.generator.ColumnSelector;
import com.gitee.fastmybatis.core.ext.code.generator.TableDefinition;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import javax.persistence.Table;

public class TableSelector {
    private ColumnSelector columnSelector;
    private Class<?> entityClass;
    private FastmybatisConfig config;

    public TableSelector(Class<?> entityClass, FastmybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("FastmybatisConfig\u4e0d\u80fd\u4e3anull");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass\u4e0d\u80fd\u4e3anull");
        }
        this.entityClass = entityClass;
        this.config = config;
        this.columnSelector = new ColumnSelector(entityClass, config);
    }

    public TableDefinition getTableDefinition() {
        TableDefinition tableDefinition = new TableDefinition();
        Table tableAnno = this.entityClass.getAnnotation(Table.class);
        String schema = "";
        String tableName = this.entityClass.getSimpleName();
        if (tableAnno != null) {
            schema = tableAnno.schema();
            tableName = tableAnno.name();
        } else {
            String javaBeanName = this.entityClass.getSimpleName();
            if (this.config.isCamel2underline()) {
                tableName = FieldUtil.camelToUnderline(javaBeanName);
            }
        }
        tableDefinition.setSchema(schema);
        tableDefinition.setTableName(tableName);
        tableDefinition.setColumnDefinitions(this.columnSelector.getColumnDefinitions());
        return tableDefinition;
    }
}

