/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.client;

import com.gitee.fastmybatis.core.ext.code.NotEntityException;
import com.gitee.fastmybatis.core.ext.code.client.ClientParam;
import com.gitee.fastmybatis.core.ext.code.generator.SQLContext;
import com.gitee.fastmybatis.core.ext.code.generator.TableDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.TableSelector;
import com.gitee.fastmybatis.core.ext.code.util.VelocityUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class Generator {
    private static final Charset UTF8 = Charsets.toCharset((String)"UTF-8");

    public String generateCode(ClientParam clientParam) throws FileNotFoundException, NotEntityException {
        InputStream templateInputStream = this.buildTemplateInputStream(clientParam);
        SQLContext sqlContext = this.buildClientSQLContextList(clientParam);
        VelocityContext context = new VelocityContext();
        TableDefinition tableDefinition = sqlContext.getTableDefinition();
        context.put("context", (Object)sqlContext);
        context.put("table", (Object)tableDefinition);
        context.put("pk", (Object)tableDefinition.getPkColumn());
        context.put("columns", tableDefinition.getTableColumns());
        context.put("allColumns", tableDefinition.getAllColumns());
        context.put("countExpression", (Object)clientParam.getCountExpression());
        return VelocityUtil.generate(context, templateInputStream);
    }

    private InputStream buildTemplateInputStream(ClientParam clientParam) throws FileNotFoundException {
        DefaultResourceLoader templateLoader = new DefaultResourceLoader();
        Resource vmResource = templateLoader.getResource(clientParam.getTemplateLocation());
        try {
            if (StringUtils.isNotBlank((String)clientParam.getGlobalVmLocation())) {
                DefaultResourceLoader globalVmResourceLoader = new DefaultResourceLoader();
                Resource globalVmResource = globalVmResourceLoader.getResource(clientParam.getGlobalVmLocation());
                return this.mergeGlobalVm(vmResource, globalVmResource, clientParam.getGlobalVmPlaceholder());
            }
            return vmResource.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private InputStream mergeGlobalVm(Resource vmResource, Resource globalVmResource, String placeholder) throws IOException {
        String vmContent = IOUtils.toString((InputStream)vmResource.getInputStream(), (Charset)UTF8);
        String globalVmContent = IOUtils.toString((InputStream)globalVmResource.getInputStream(), (Charset)UTF8);
        String finalContent = vmContent.replace(placeholder, globalVmContent);
        return IOUtils.toInputStream((String)finalContent, (Charset)UTF8);
    }

    private SQLContext buildClientSQLContextList(ClientParam clientParam) throws NotEntityException {
        Class<?> entityClass = clientParam.getEntityClass();
        if (entityClass == Object.class || entityClass == Void.class) {
            throw new NotEntityException();
        }
        TableSelector tableSelector = new TableSelector(entityClass, clientParam.getConfig());
        TableDefinition tableDefinition = tableSelector.getTableDefinition();
        SQLContext context = new SQLContext(tableDefinition);
        String namespace = this.buildNamespace(clientParam.getMapperClass());
        context.setClassName(entityClass.getName());
        context.setClassSimpleName(entityClass.getSimpleName());
        context.setPackageName(entityClass.getPackage().getName());
        context.setNamespace(namespace);
        return context;
    }

    private String buildNamespace(Class<?> mapperClass) {
        return mapperClass.getName();
    }
}

