/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.client;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.code.NotEntityException;
import com.gitee.fastmybatis.core.ext.code.client.ClientParam;
import com.gitee.fastmybatis.core.ext.code.client.Generator;
import java.io.FileNotFoundException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ClassClient {
    private static Log logger = LogFactory.getLog(ClassClient.class);
    private static String EMPTY_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\"><mapper namespace=\"%s\">  <!--_ext_mapper_-->  <!--_global_vm_--> </mapper>";
    private Generator generator = new Generator();
    private FastmybatisConfig config;

    public ClassClient(FastmybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config\u4e0d\u80fd\u4e3anull");
        }
        this.config = config;
    }

    public String genMybatisXml(Class<?> mapperClass, String templateLocation, String globalVmLocation) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u751f\u6210" + mapperClass.getName() + "\u5bf9\u5e94\u7684Mapper");
        }
        ClientParam param = new ClientParam();
        param.setTemplateLocation(templateLocation);
        param.setGlobalVmLocation(globalVmLocation);
        param.setMapperClass(mapperClass);
        param.setConfig(this.config);
        try {
            return this.generator.generateCode(param);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NotEntityException e) {
            return String.format(EMPTY_XML, mapperClass.getName());
        }
    }
}

