/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.MapperLocationsBuilder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SqlSessionFactoryBeanExt
extends SqlSessionFactoryBean {
    private static Log LOGGER = LogFactory.getLog(SqlSessionFactoryBeanExt.class);
    private MapperLocationsBuilder mapperLocationsBuilder = new MapperLocationsBuilder();
    private String basePackage;

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        String dbName = SqlSessionFactoryBeanExt.buildDbName(dataSource);
        this.mapperLocationsBuilder.setDbName(dbName);
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocationsBuilder.storeMapperFile(mapperLocations);
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        Assert.notNull((Object)this.basePackage, (String)"\u5c5e\u6027 'basePackage' \u5fc5\u586b");
        Resource[] allMapperLocations = this.mapperLocationsBuilder.build(this.basePackage);
        super.setMapperLocations(allMapperLocations);
        return super.buildSqlSessionFactory();
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setConfig(FastmybatisConfig fastmybatisConfig) {
        this.mapperLocationsBuilder.setConfig(fastmybatisConfig);
    }

    private static String buildDbName(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource \u4e0d\u80fd\u4e3anull");
        }
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            LOGGER.info((Object)("\u6570\u636e\u5e93\u540d\u79f0\uff1a" + dbName));
            String string = dbName;
            return string;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

