/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.ClassScanner;
import com.gitee.fastmybatis.core.ext.code.client.ClassClient;
import com.gitee.fastmybatis.core.mapper.Mapper;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class MapperLocationsBuilder {
    private static Log LOGGER = LogFactory.getLog(MapperLocationsBuilder.class);
    private static final String ENCODE = "UTF-8";
    private static final String XML_SUFFIX = ".xml";
    private static final String NODE_MAPPER = "mapper";
    private static final String MAPPER_START = "<mapper>";
    private static final String MAPPER_END = "</mapper>";
    private static final String MAPPER_EMPTY = "<mapper/>";
    private static final String EXT_MAPPER_PLACEHOLDER = "<!--_ext_mapper_-->";
    private static final String TEMPLATE_SUFFIX = ".vm";
    private static final String DEFAULT_CLASS_PATH = "/fastmybatis/tpl/";
    private Map<String, MapperResourceDefinition> mapperResourceStore = new HashMap<String, MapperResourceDefinition>();
    private FastmybatisConfig config = new FastmybatisConfig();
    private Attribute namespace;
    private String dbName;

    public Resource[] build(String basePackage) {
        this.init();
        try {
            Resource[] mapperLocations;
            String[] basePackages = StringUtils.tokenizeToStringArray((String)basePackage, (String)",; \t\n");
            ClassScanner classScanner = new ClassScanner(basePackages, Mapper.class);
            Set<Class<?>> clazzsSet = classScanner.getClassSet();
            Resource[] resourceArray = mapperLocations = this.buildMapperLocations(clazzsSet);
            return resourceArray;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6784\u5efamapper\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.distroy();
        }
    }

    private void init() {
        this.namespace = new DOMAttribute(new QName("namespace"));
    }

    private void distroy() {
        this.namespace = null;
        this.mapperResourceStore.clear();
    }

    public void storeMapperFile(Resource[] mapperLocations) {
        for (Resource mapperLocation : mapperLocations) {
            String filename = mapperLocation.getFilename();
            this.mapperResourceStore.put(filename, new MapperResourceDefinition(mapperLocation));
        }
    }

    private MapperResourceDefinition getMapperFile(String mapperFileName) {
        return this.mapperResourceStore.get(mapperFileName);
    }

    private Resource[] buildMapperLocations(Set<Class<?>> clazzsSet) {
        List<Resource> mapperLocations = this.buildMapperResource(clazzsSet);
        this.addUnmergedResource(mapperLocations);
        this.addCommonSqlClasspathMapper(mapperLocations);
        return mapperLocations.toArray(new Resource[mapperLocations.size()]);
    }

    private List<Resource> buildMapperResource(Set<Class<?>> clazzsSet) {
        int classCount = clazzsSet.size();
        if (classCount == 0) {
            return new ArrayList<Resource>();
        }
        final String templateLocation = this.buildTemplateLocation(this.getDbName());
        final String globalVmLocation = this.config.getGlobalVmLocation();
        LOGGER.info((Object)("\u4f7f\u7528\u6a21\u677f:" + templateLocation));
        final ClassClient codeClient = new ClassClient(this.config);
        final List<Resource> mapperLocations = Collections.synchronizedList(new ArrayList(classCount));
        ExecutorService executorPool = this.buildExecutorService(classCount);
        long startTime = System.currentTimeMillis();
        try {
            Iterator<Class<?>> i$ = clazzsSet.iterator();
            while (i$.hasNext()) {
                Class<?> mapperClass;
                final Class<?> daoClass = mapperClass = i$.next();
                executorPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String xml = codeClient.genMybatisXml(daoClass, templateLocation, globalVmLocation);
                            xml = MapperLocationsBuilder.this.mergeExtMapperFile(daoClass, xml);
                            mapperLocations.add(new MapperResource(xml, daoClass));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            executorPool.shutdown();
            executorPool.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)("\u751f\u6210Mapper\u5185\u5bb9\u603b\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2"));
            this.saveMapper(this.config.getMapperSaveDir(), mapperLocations);
            return mapperLocations;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private ExecutorService buildExecutorService(int classSize) {
        int poolSize = this.config.getMapperExecutorPoolSize();
        int nThreads = poolSize > classSize ? classSize : poolSize;
        return Executors.newFixedThreadPool(nThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setUncaughtExceptionHandler(new ThreadPoolUncaughtExceptionHandler());
                return t;
            }
        });
    }

    private void saveMapper(String saveDir, List<Resource> mapperLocations) {
        if (StringUtils.hasText((String)saveDir)) {
            try {
                LOGGER.info((Object)("\u4fdd\u5b58mapper\u6587\u4ef6\u5230" + saveDir));
                for (Resource resource : mapperLocations) {
                    FileOutputStream out = new FileOutputStream(saveDir + "/" + resource.getFilename());
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private String buildTemplateLocation(String dbName) {
        String templateClasspath = this.config.getTemplateClasspath();
        if (StringUtils.isEmpty((Object)templateClasspath)) {
            templateClasspath = DEFAULT_CLASS_PATH;
        }
        return templateClasspath + this.buildTemplateFileName(dbName);
    }

    private String buildTemplateFileName(String dbName) {
        dbName = dbName.replaceAll("\\s", "").toLowerCase();
        return dbName + TEMPLATE_SUFFIX;
    }

    private void addCommonSqlClasspathMapper(List<Resource> mapperLocations) {
        String commonSqlClasspath = this.config.getCommonSqlClasspath();
        ClassPathResource res = new ClassPathResource(commonSqlClasspath);
        mapperLocations.add((Resource)res);
    }

    private void addUnmergedResource(List<Resource> mapperLocations) {
        Collection<MapperResourceDefinition> mapperResourceDefinitions = this.mapperResourceStore.values();
        for (MapperResourceDefinition mapperResourceDefinition : mapperResourceDefinitions) {
            if (mapperResourceDefinition.isMerged()) continue;
            LOGGER.info((Object)("\u52a0\u8f7d\u672a\u5408\u5e76Mapper\uff1a" + mapperResourceDefinition.getFilename()));
            mapperLocations.add(mapperResourceDefinition.getResource());
        }
    }

    private String mergeExtMapperFile(Class<?> mapperClass, String xml) {
        String mapperFileName = mapperClass.getSimpleName() + XML_SUFFIX;
        MapperResourceDefinition mapperResourceDefinition = this.getMapperFile(mapperFileName);
        if (mapperResourceDefinition != null) {
            String extFileContent = this.getExtFileContent(mapperResourceDefinition.getResource());
            xml = xml.replace(EXT_MAPPER_PLACEHOLDER, extFileContent);
            mapperResourceDefinition.setMerged(true);
        }
        return xml;
    }

    private String getExtFileContent(Resource mapperLocation) {
        try {
            InputStream in = mapperLocation.getInputStream();
            Document document = this.buildSAXReader().read(in);
            Element mapperNode = document.getRootElement();
            String rootNodeName = mapperNode.getName();
            if (!NODE_MAPPER.equals(rootNodeName)) {
                throw new Exception("mapper\u6587\u4ef6\u5fc5\u987b\u542b\u6709<mapper>\u8282\u70b9,\u662f\u5426\u7f3a\u5c11<mapper></mapper>?");
            }
            mapperNode.remove(this.namespace);
            String rootXml = mapperNode.asXML();
            String empty = "";
            rootXml = rootXml.replace(MAPPER_START, empty).replace(MAPPER_END, empty).replace(MAPPER_EMPTY, empty);
            return rootXml;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u52a0\u8f7d\u8d44\u6e90\u6587\u4ef6\u51fa\u9519,[" + mapperLocation.getFilename() + "]," + e.getMessage());
        }
    }

    private SAXReader buildSAXReader() {
        SAXReader reader = new SAXReader();
        reader.setEncoding(ENCODE);
        return reader;
    }

    public void setConfig(FastmybatisConfig config) {
        this.config = config;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setMapperExecutorPoolSize(int poolSize) {
        this.config.setMapperExecutorPoolSize(poolSize);
    }

    private static class ThreadPoolUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ThreadPoolUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOGGER.error((Object)e.getMessage(), e);
            System.exit(0);
        }
    }

    private static class MapperResource
    extends ByteArrayResource {
        private Class<?> mapperClass;

        public MapperResource(String xml, Class<?> mapperClass) throws UnsupportedEncodingException {
            super(xml.getBytes(MapperLocationsBuilder.ENCODE), mapperClass.getName());
            this.mapperClass = mapperClass;
        }

        public String getFilename() {
            return this.mapperClass.getSimpleName() + MapperLocationsBuilder.XML_SUFFIX;
        }
    }

    private static class MapperResourceDefinition {
        private boolean merged;
        private Resource resource;

        public MapperResourceDefinition(Resource resource) {
            this.resource = resource;
        }

        public String getFilename() {
            return this.resource.getFilename();
        }

        public boolean isMerged() {
            return this.merged;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

