/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core;

import com.gitee.fastmybatis.core.handler.BaseFill;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FastmybatisConfig {
    public static String COUNT_EXPRESSION = "count(*)";
    private static final String GLOBAL_VM_PLACEHOLDER = "<!--_global_vm_-->";
    private boolean camel2underline = Boolean.TRUE;
    private int mapperExecutorPoolSize = 5;
    private String templateClasspath;
    private String commonSqlClasspath = "fastmybatis/commonSql.xml";
    private String mapperSaveDir;
    private String countExpression = COUNT_EXPRESSION;
    private String globalVmLocation;
    private String logicNotDeleteValue = "0";
    private String logicDeleteValue = "1";
    private List<BaseFill<?>> fillList = new ArrayList(8);

    public String getGlobalVmPlaceholder() {
        return GLOBAL_VM_PLACEHOLDER;
    }

    public void setCamel2underline(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public boolean isCamel2underline() {
        return this.camel2underline;
    }

    public int getMapperExecutorPoolSize() {
        return this.mapperExecutorPoolSize;
    }

    public void setMapperExecutorPoolSize(int mapperExecutorPoolSize) {
        if (mapperExecutorPoolSize <= 0) {
            throw new IllegalArgumentException("mapperExecutorPoolSize\u5fc5\u987b\u5927\u4e8e0");
        }
        this.mapperExecutorPoolSize = mapperExecutorPoolSize;
    }

    public String getTemplateClasspath() {
        return this.templateClasspath;
    }

    public void setTemplateClasspath(String templateClasspath) {
        this.templateClasspath = templateClasspath;
    }

    public String getCommonSqlClasspath() {
        return this.commonSqlClasspath;
    }

    public void setCommonSqlClasspath(String commonSqlClasspath) {
        this.commonSqlClasspath = commonSqlClasspath;
    }

    public String getMapperSaveDir() {
        return this.mapperSaveDir;
    }

    public void setMapperSaveDir(String mapperSaveDir) {
        File dir = new File(mapperSaveDir);
        boolean selfMake = false;
        if (!dir.exists()) {
            dir.mkdirs();
            selfMake = true;
        }
        if (!dir.isDirectory()) {
            if (selfMake) {
                dir.delete();
            }
            throw new IllegalArgumentException("mapperSaveDir\u5fc5\u987b\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\u8def\u5f84\uff0cmapperSaveDir\uff1a" + mapperSaveDir);
        }
        this.mapperSaveDir = mapperSaveDir;
    }

    public <T extends BaseFill<?>> void setFills(List<T> fills) {
        for (BaseFill fill : fills) {
            this.fillList.add(fill);
        }
        Collections.sort(this.fillList, new Comparator<BaseFill<?>>(){

            @Override
            public int compare(BaseFill<?> o1, BaseFill<?> o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
    }

    public BaseFill<?> getFill(Class<?> entityClass, Field field, String columnName) {
        for (BaseFill<?> fillHandler : this.fillList) {
            if (!fillHandler.match(entityClass, field, columnName)) continue;
            return fillHandler;
        }
        return null;
    }

    public void setCountExpression(String countExpression) {
        this.countExpression = countExpression;
    }

    public String getCountExpression() {
        return this.countExpression;
    }

    public String getGlobalVmLocation() {
        return this.globalVmLocation;
    }

    public void setGlobalVmLocation(String globalVmLocation) {
        this.globalVmLocation = globalVmLocation;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }
}

