/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public abstract class AbstractExtractFileTask<T>
extends AsyncZipTask<T> {
    private ZipModel zipModel;
    private byte[] buff = new byte[4096];

    public AbstractExtractFileTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel) {
        super(progressMonitor, runInThread);
        this.zipModel = zipModel;
    }

    protected void extractFile(ZipInputStream zipInputStream, FileHeader fileHeader, String outputPath, String newFileName, ProgressMonitor progressMonitor) throws IOException {
        if (!outputPath.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
            outputPath = outputPath + InternalZipConstants.FILE_SEPARATOR;
        }
        File outputFile = this.determineOutputFile(fileHeader, outputPath, newFileName);
        progressMonitor.setFileName(outputFile.getAbsolutePath());
        if (!outputFile.getCanonicalPath().startsWith(new File(outputPath).getCanonicalPath())) {
            throw new ZipException("illegal file name that breaks out of the target directory: " + fileHeader.getFileName());
        }
        this.verifyNextEntry(zipInputStream, fileHeader);
        if (fileHeader.isDirectory()) {
            if (!outputFile.exists() && !outputFile.mkdirs()) {
                throw new ZipException("Could not create directory: " + outputFile);
            }
        } else {
            this.checkOutputDirectoryStructure(outputFile);
            this.unzipFile(zipInputStream, fileHeader, outputFile, progressMonitor);
        }
    }

    private void unzipFile(ZipInputStream inputStream, FileHeader fileHeader, File outputFile, ProgressMonitor progressMonitor) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int readLength;
            while ((readLength = inputStream.read(this.buff)) != -1) {
                ((OutputStream)outputStream).write(this.buff, 0, readLength);
                progressMonitor.updateWorkCompleted(readLength);
                this.verifyIfTaskIsCancelled();
            }
        }
        catch (Exception e) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            throw e;
        }
        UnzipUtil.applyFileAttributes(fileHeader, outputFile);
    }

    private void verifyNextEntry(ZipInputStream zipInputStream, FileHeader fileHeader) throws IOException {
        LocalFileHeader localFileHeader = zipInputStream.getNextEntry(fileHeader);
        if (localFileHeader == null) {
            throw new ZipException("Could not read corresponding local file header for file header: " + fileHeader.getFileName());
        }
        if (!fileHeader.getFileName().equals(localFileHeader.getFileName())) {
            throw new ZipException("File header and local file header mismatch");
        }
    }

    private void checkOutputDirectoryStructure(File outputFile) throws ZipException {
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new ZipException("Unable to create parent directories: " + outputFile.getParentFile());
        }
    }

    private File determineOutputFile(FileHeader fileHeader, String outputPath, String newFileName) {
        String outputFileName = Zip4jUtil.isStringNotNullAndNotEmpty(newFileName) ? newFileName : this.getFileNameWithSystemFileSeparators(fileHeader.getFileName());
        return new File(outputPath + InternalZipConstants.FILE_SEPARATOR + outputFileName);
    }

    private String getFileNameWithSystemFileSeparators(String fileNameToReplace) {
        return fileNameToReplace.replaceAll("[/\\\\]", Matcher.quoteReplacement(InternalZipConstants.FILE_SEPARATOR));
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.EXTRACT_ENTRY;
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }
}

