/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public interface Node {
    public static final Node MISSING_NODE = new Node(){

        public boolean isArray() {
            return false;
        }

        @Override
        public Node element(int index) {
            return MISSING_NODE;
        }

        @Override
        public Iterator<KeyValue> fields() {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }

        @Override
        public Node get(String key) {
            return this;
        }

        @Override
        public boolean isMissingNode() {
            return true;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeType getNodeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ___do_not_implement_this_interface_seriously() {
        }
    };

    public Node element(int var1);

    public Iterator<KeyValue> fields();

    public Node get(String var1);

    public boolean isMissingNode();

    public boolean isNull();

    public Iterator<Node> arrayElements();

    public int size();

    public String asText();

    public NodeType getNodeType();

    public BigDecimal decimalValue();

    public Boolean asBoolean();

    public Object getValue();

    public void ___do_not_implement_this_interface_seriously();

    public static class JsonMap
    extends LinkedHashMap<String, Object>
    implements Node {
        private final Node wrappedNode;

        JsonMap(Node node) {
            this.wrappedNode = node;
            Iterator<KeyValue> fields = node.fields();
            while (fields.hasNext()) {
                KeyValue keyValue = fields.next();
                this.put(keyValue.getKey(), keyValue.getValue().getValue());
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            Iterator entries = this.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                builder.append('\"').append((String)entry.getKey()).append('\"').append(":").append(this.quoteString(entry.getValue()));
                if (!entries.hasNext()) continue;
                builder.append(", ");
            }
            builder.append("}");
            return builder.toString();
        }

        private Object quoteString(Object value) {
            return value instanceof String ? "\"" + value + "\"" : value;
        }

        @Override
        public Node element(int index) {
            return this.wrappedNode.element(index);
        }

        @Override
        public Iterator<KeyValue> fields() {
            return this.wrappedNode.fields();
        }

        @Override
        public Node get(String key) {
            return this.wrappedNode.get(key);
        }

        @Override
        public boolean isMissingNode() {
            return this.wrappedNode.isMissingNode();
        }

        @Override
        public boolean isNull() {
            return this.wrappedNode.isNull();
        }

        @Override
        public Iterator<Node> arrayElements() {
            return this.wrappedNode.arrayElements();
        }

        @Override
        public String asText() {
            return this.wrappedNode.asText();
        }

        @Override
        public NodeType getNodeType() {
            return this.wrappedNode.getNodeType();
        }

        @Override
        public BigDecimal decimalValue() {
            return this.wrappedNode.decimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.wrappedNode.asBoolean();
        }

        @Override
        public Object getValue() {
            return this.wrappedNode.getValue();
        }

        @Override
        public void ___do_not_implement_this_interface_seriously() {
            this.wrappedNode.___do_not_implement_this_interface_seriously();
        }
    }

    public static interface ValueExtractor {
        public Object getValue(Node var1);
    }

    public static class KeyValue {
        private final String key;
        private final Node value;

        KeyValue(String key, Node value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Node getValue() {
            return this.value;
        }
    }

    public static enum NodeType implements ValueExtractor
    {
        OBJECT("object"){

            @Override
            public Object getValue(Node node) {
                return new JsonMap(node);
            }
        }
        ,
        ARRAY("array"){

            @Override
            public Object getValue(Node node) {
                Iterator<Node> nodeIterator = node.arrayElements();
                LinkedList<Object> result = new LinkedList<Object>();
                while (nodeIterator.hasNext()) {
                    Node arrayNode = nodeIterator.next();
                    result.add(arrayNode.getValue());
                }
                return Collections.unmodifiableList(result);
            }
        }
        ,
        STRING("string"){

            @Override
            public Object getValue(Node node) {
                return node.asText();
            }
        }
        ,
        NUMBER("number"){

            @Override
            public Object getValue(Node node) {
                return node.decimalValue();
            }
        }
        ,
        BOOLEAN("boolean"){

            @Override
            public Object getValue(Node node) {
                return node.asBoolean();
            }
        }
        ,
        NULL("null"){

            @Override
            public Object getValue(Node node) {
                return null;
            }
        };

        private final String description;

        private NodeType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

