/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.model.IncompatibleTypeIdentifierException;
import net.corda.serialization.internal.model.ReconstitutedParameterizedType;
import net.corda.serialization.internal.model.TypeIdentifierKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\t\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0006\u001b\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "()V", "erased", "getErased", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "name", "", "getName", "()Ljava/lang/String;", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "prettyPrint", "simplifyClassNames", "", "simplifyClassNameIfRequired", "ArrayOf", "Companion", "Erased", "Parameterised", "ReconstitutedGenericArrayType", "TopType", "UnboundedWildcardType", "UnknownType", "Unparameterised", "Lnet/corda/serialization/internal/model/TypeIdentifier$TopType;", "Lnet/corda/serialization/internal/model/TypeIdentifier$UnknownType;", "Lnet/corda/serialization/internal/model/TypeIdentifier$Unparameterised;", "Lnet/corda/serialization/internal/model/TypeIdentifier$Erased;", "Lnet/corda/serialization/internal/model/TypeIdentifier$ArrayOf;", "Lnet/corda/serialization/internal/model/TypeIdentifier$Parameterised;", "serialization"})
public abstract class TypeIdentifier {
    private static final ClassLoader systemClassLoader;
    public static final Companion Companion;

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Type getLocalType(@NotNull ClassLoader var1);

    @NotNull
    public static /* bridge */ /* synthetic */ Type getLocalType$default(TypeIdentifier typeIdentifier, ClassLoader classLoader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocalType");
        }
        if ((n & 1) != 0) {
            classLoader = systemClassLoader;
        }
        return typeIdentifier.getLocalType(classLoader);
    }

    @NotNull
    public TypeIdentifier getErased() {
        return this;
    }

    @NotNull
    public final String prettyPrint(boolean simplifyClassNames) {
        String string;
        TypeIdentifier typeIdentifier = this;
        if (typeIdentifier instanceof UnknownType) {
            string = "?";
        } else if (typeIdentifier instanceof TopType) {
            string = "*";
        } else if (typeIdentifier instanceof Unparameterised) {
            string = this.simplifyClassNameIfRequired(this.getName(), simplifyClassNames);
        } else if (typeIdentifier instanceof Erased) {
            string = this.simplifyClassNameIfRequired(this.getName(), simplifyClassNames) + " (erased)";
        } else if (typeIdentifier instanceof ArrayOf) {
            string = ((ArrayOf)this).getComponentType().prettyPrint(simplifyClassNames) + "[]";
        } else if (typeIdentifier instanceof Parameterised) {
            string = this.simplifyClassNameIfRequired(this.getName(), simplifyClassNames) + CollectionsKt.joinToString$default((Iterable)((Parameterised)this).getParameters(), (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<TypeIdentifier, String>(simplifyClassNames){
                final /* synthetic */ boolean $simplifyClassNames;

                @NotNull
                public final String invoke(@NotNull TypeIdentifier it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.prettyPrint(this.$simplifyClassNames);
                }
                {
                    this.$simplifyClassNames = bl;
                    super(1);
                }
            }), (int)24, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String prettyPrint$default(TypeIdentifier typeIdentifier, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prettyPrint");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return typeIdentifier.prettyPrint(bl);
    }

    private final String simplifyClassNameIfRequired(@NotNull String $receiver, boolean simplifyClassNames) {
        return simplifyClassNames ? (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$receiver, (String[])new String[]{".", "$"}, (boolean)false, (int)0, (int)6, null)) : $receiver;
    }

    private TypeIdentifier() {
    }

    static {
        Companion = new Companion(null);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"ClassLoader.getSystemClassLoader()");
        systemClassLoader = classLoader;
    }

    public /* synthetic */ TypeIdentifier(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$TopType;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "()V", "name", "", "getName", "()Ljava/lang/String;", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "toString", "serialization"})
    public static final class TopType
    extends TypeIdentifier {
        public static final TopType INSTANCE;

        @Override
        @NotNull
        public String getName() {
            return "*";
        }

        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            return (Type)((Object)Object.class);
        }

        @NotNull
        public String toString() {
            return "TopType";
        }

        private TopType() {
            super(null);
        }

        static {
            TopType topType;
            INSTANCE = topType = new TopType();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$UnboundedWildcardType;", "Ljava/lang/reflect/WildcardType;", "()V", "getLowerBounds", "", "Ljava/lang/reflect/Type;", "()[Ljava/lang/reflect/Type;", "getUpperBounds", "toString", "", "serialization"})
    private static final class UnboundedWildcardType
    implements WildcardType {
        public static final UnboundedWildcardType INSTANCE;

        @Override
        @NotNull
        public Type[] getLowerBounds() {
            return new Type[0];
        }

        @Override
        @NotNull
        public Type[] getUpperBounds() {
            return new Type[]{(Type)((Object)Object.class)};
        }

        @NotNull
        public String toString() {
            return "?";
        }

        private UnboundedWildcardType() {
        }

        static {
            UnboundedWildcardType unboundedWildcardType;
            INSTANCE = unboundedWildcardType = new UnboundedWildcardType();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$UnknownType;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "()V", "name", "", "getName", "()Ljava/lang/String;", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "toString", "serialization"})
    public static final class UnknownType
    extends TypeIdentifier {
        public static final UnknownType INSTANCE;

        @Override
        @NotNull
        public String getName() {
            return "?";
        }

        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            return UnboundedWildcardType.INSTANCE;
        }

        @NotNull
        public String toString() {
            return "UnknownType";
        }

        private UnknownType() {
            super(null);
        }

        static {
            UnknownType unknownType;
            INSTANCE = unknownType = new UnknownType();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$Unparameterised;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "name", "", "(Ljava/lang/String;)V", "isPrimitive", "", "()Z", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "hashCode", "", "toString", "Companion", "serialization"})
    public static final class Unparameterised
    extends TypeIdentifier {
        @NotNull
        private final String name;
        private static final Map<String, Class<? extends Object>> primitives;
        public static final Companion Companion;

        @NotNull
        public String toString() {
            return "Unparameterised(" + this.getName() + ')';
        }

        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Type type;
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            Class<? extends Object> clazz = primitives.get(this.getName());
            if (clazz != null) {
                type = clazz;
            } else {
                Class<?> clazz2 = classLoader.loadClass(this.getName());
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"classLoader.loadClass(name)");
                type = clazz2;
            }
            return type;
        }

        public final boolean isPrimitive() {
            Map<String, Class<? extends Object>> map = primitives;
            String string = this.getName();
            Map<String, Class<? extends Object>> map2 = map;
            return map2.containsKey(string);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public Unparameterised(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super(null);
            this.name = name;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $receiver$iv$iv;
            Companion = new Companion(null);
            Iterable $receiver$iv = CollectionsKt.listOf((Object[])new KClass[]{Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE)});
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterable iterable = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Map map = destination$iv$iv;
                KClass it = (KClass)element$iv$iv;
                Class clazz = JvmClassMappingKt.getJavaPrimitiveType((KClass)it);
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                Pair pair = TuplesKt.to((Object)clazz.getName(), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)it));
                map.put(pair.getFirst(), pair.getSecond());
            }
            primitives = var3_3;
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        @NotNull
        public final Unparameterised copy(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Unparameterised(name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Unparameterised copy$default(Unparameterised unparameterised, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = unparameterised.getName();
            }
            return unparameterised.copy(string);
        }

        public int hashCode() {
            String string = this.getName();
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Unparameterised)) break block3;
                    Unparameterised unparameterised = (Unparameterised)object;
                    if (!Intrinsics.areEqual((Object)this.getName(), (Object)unparameterised.getName())) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0003\u001a \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$Unparameterised$Companion;", "", "()V", "primitives", "", "", "kotlin.jvm.PlatformType", "Ljava/lang/Class;", "serialization"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\u0014\u0010\u0017\u001a\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$Erased;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "name", "", "erasedParameterCount", "", "(Ljava/lang/String;I)V", "getErasedParameterCount", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "hashCode", "toParameterized", "parameters", "", "toString", "serialization"})
    public static final class Erased
    extends TypeIdentifier {
        @NotNull
        private final String name;
        private final int erasedParameterCount;

        @NotNull
        public final TypeIdentifier toParameterized(@NotNull List<? extends TypeIdentifier> parameters) {
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            if (parameters.size() != this.erasedParameterCount) {
                throw (Throwable)new IncompatibleTypeIdentifierException("Erased type " + this.getName() + " takes " + this.erasedParameterCount + " parameters, but " + parameters.size() + " supplied");
            }
            return new Parameterised(this.getName(), null, parameters);
        }

        @NotNull
        public String toString() {
            return "Erased(" + this.getName() + ')';
        }

        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            Class<?> clazz = classLoader.loadClass(this.getName());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"classLoader.loadClass(name)");
            return clazz;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public final int getErasedParameterCount() {
            return this.erasedParameterCount;
        }

        public Erased(@NotNull String name, int erasedParameterCount) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super(null);
            this.name = name;
            this.erasedParameterCount = erasedParameterCount;
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        public final int component2() {
            return this.erasedParameterCount;
        }

        @NotNull
        public final Erased copy(@NotNull String name, int erasedParameterCount) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Erased(name, erasedParameterCount);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Erased copy$default(Erased erased, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = erased.getName();
            }
            if ((n2 & 2) != 0) {
                n = erased.erasedParameterCount;
            }
            return erased.copy(string, n);
        }

        public int hashCode() {
            String string = this.getName();
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.erasedParameterCount);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Erased)) break block3;
                    Erased erased = (Erased)object;
                    if (!Intrinsics.areEqual((Object)this.getName(), (Object)erased.getName()) || !(this.erasedParameterCount == erased.erasedParameterCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$ReconstitutedGenericArrayType;", "Ljava/lang/reflect/GenericArrayType;", "componentType", "Ljava/lang/reflect/Type;", "(Ljava/lang/reflect/Type;)V", "equals", "", "other", "", "getGenericComponentType", "hashCode", "", "toString", "", "serialization"})
    private static final class ReconstitutedGenericArrayType
    implements GenericArrayType {
        private final Type componentType;

        @Override
        @NotNull
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @NotNull
        public String toString() {
            return this.componentType + "[]";
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof GenericArrayType && Intrinsics.areEqual((Object)this.componentType, (Object)((GenericArrayType)other).getGenericComponentType());
        }

        public int hashCode() {
            return Objects.hashCode(this.componentType);
        }

        public ReconstitutedGenericArrayType(@NotNull Type componentType) {
            Intrinsics.checkParameterIsNotNull((Object)componentType, (String)"componentType");
            this.componentType = componentType;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\n\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$ArrayOf;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "componentType", "(Lnet/corda/serialization/internal/model/TypeIdentifier;)V", "getComponentType", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "name", "", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "hashCode", "", "toString", "serialization"})
    public static final class ArrayOf
    extends TypeIdentifier {
        @NotNull
        private final TypeIdentifier componentType;

        @Override
        @NotNull
        public String getName() {
            return this.componentType.getName() + "[]";
        }

        @NotNull
        public String toString() {
            return "ArrayOf(" + TypeIdentifier.prettyPrint$default(this.componentType, false, 1, null) + ')';
        }

        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            Type component = this.componentType.getLocalType(classLoader);
            TypeIdentifier typeIdentifier = this.componentType;
            return typeIdentifier instanceof Parameterised ? (Type)new ReconstitutedGenericArrayType(component) : (Type)Array.newInstance(SerializationHelperKt.asClass(component), 0).getClass();
        }

        @NotNull
        public final TypeIdentifier getComponentType() {
            return this.componentType;
        }

        public ArrayOf(@NotNull TypeIdentifier componentType) {
            Intrinsics.checkParameterIsNotNull((Object)componentType, (String)"componentType");
            super(null);
            this.componentType = componentType;
        }

        @NotNull
        public final TypeIdentifier component1() {
            return this.componentType;
        }

        @NotNull
        public final ArrayOf copy(@NotNull TypeIdentifier componentType) {
            Intrinsics.checkParameterIsNotNull((Object)componentType, (String)"componentType");
            return new ArrayOf(componentType);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArrayOf copy$default(ArrayOf arrayOf, TypeIdentifier typeIdentifier, int n, Object object) {
            if ((n & 1) != 0) {
                typeIdentifier = arrayOf.componentType;
            }
            return arrayOf.copy(typeIdentifier);
        }

        public int hashCode() {
            TypeIdentifier typeIdentifier = this.componentType;
            return typeIdentifier != null ? typeIdentifier.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArrayOf)) break block3;
                    ArrayOf arrayOf = (ArrayOf)object;
                    if (!Intrinsics.areEqual((Object)this.componentType, (Object)arrayOf.componentType)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$Parameterised;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "name", "", "owner", "parameters", "", "(Ljava/lang/String;Lnet/corda/serialization/internal/model/TypeIdentifier;Ljava/util/List;)V", "erased", "getErased", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "getName", "()Ljava/lang/String;", "getOwner", "getParameters", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getLocalType", "Ljava/lang/reflect/Type;", "classLoader", "Ljava/lang/ClassLoader;", "hashCode", "", "toString", "serialization"})
    public static final class Parameterised
    extends TypeIdentifier {
        @NotNull
        private final String name;
        @Nullable
        private final TypeIdentifier owner;
        @NotNull
        private final List<TypeIdentifier> parameters;

        @Override
        @NotNull
        public TypeIdentifier getErased() {
            return new Erased(this.getName(), this.parameters.size());
        }

        @NotNull
        public String toString() {
            return "Parameterised(" + TypeIdentifier.prettyPrint$default(this, false, 1, null) + ')';
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Type getLocalType(@NotNull ClassLoader classLoader) {
            Collection<Type> collection;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            ReconstitutedParameterizedType reconstitutedParameterizedType;
            Class<?> rawType;
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            Class<?> clazz = rawType = classLoader.loadClass(this.getName());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"rawType");
            if (clazz.getTypeParameters().length != this.parameters.size()) {
                throw (Throwable)new IncompatibleTypeIdentifierException("Class " + rawType + " expects " + rawType.getTypeParameters().length + " type arguments, " + "but type " + this.prettyPrint(false) + " has " + this.parameters.size());
            }
            TypeIdentifier typeIdentifier = this.owner;
            Iterable iterable = this.parameters;
            Type type = typeIdentifier != null ? typeIdentifier.getLocalType(classLoader) : null;
            Type type2 = rawType;
            ReconstitutedParameterizedType reconstitutedParameterizedType2 = reconstitutedParameterizedType;
            ReconstitutedParameterizedType reconstitutedParameterizedType3 = reconstitutedParameterizedType;
            void var4_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeIdentifier typeIdentifier2 = (TypeIdentifier)item$iv$iv;
                collection = destination$iv$iv;
                Type type3 = it.getLocalType(classLoader);
                collection.add(type3);
            }
            collection = (List)destination$iv$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)collection;
            Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
            if (typeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            collection = typeArray;
            reconstitutedParameterizedType2(type2, type, (Type[])collection);
            return reconstitutedParameterizedType3;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public final TypeIdentifier getOwner() {
            return this.owner;
        }

        @NotNull
        public final List<TypeIdentifier> getParameters() {
            return this.parameters;
        }

        public Parameterised(@NotNull String name, @Nullable TypeIdentifier owner, @NotNull List<? extends TypeIdentifier> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            super(null);
            this.name = name;
            this.owner = owner;
            this.parameters = parameters;
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        @Nullable
        public final TypeIdentifier component2() {
            return this.owner;
        }

        @NotNull
        public final List<TypeIdentifier> component3() {
            return this.parameters;
        }

        @NotNull
        public final Parameterised copy(@NotNull String name, @Nullable TypeIdentifier owner, @NotNull List<? extends TypeIdentifier> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            return new Parameterised(name, owner, parameters);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Parameterised copy$default(Parameterised parameterised, String string, TypeIdentifier typeIdentifier, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameterised.getName();
            }
            if ((n & 2) != 0) {
                typeIdentifier = parameterised.owner;
            }
            if ((n & 4) != 0) {
                list = parameterised.parameters;
            }
            return parameterised.copy(string, typeIdentifier, list);
        }

        public int hashCode() {
            String string = this.getName();
            TypeIdentifier typeIdentifier = this.owner;
            List<TypeIdentifier> list = this.parameters;
            return ((string != null ? string.hashCode() : 0) * 31 + (typeIdentifier != null ? typeIdentifier.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameterised)) break block3;
                    Parameterised parameterised = (Parameterised)object;
                    if (!Intrinsics.areEqual((Object)this.getName(), (Object)parameterised.getName()) || !Intrinsics.areEqual((Object)this.owner, (Object)parameterised.owner) || !Intrinsics.areEqual(this.parameters, parameterised.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/TypeIdentifier$Companion;", "", "()V", "systemClassLoader", "Ljava/lang/ClassLoader;", "forClass", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "type", "Ljava/lang/Class;", "forGenericType", "Ljava/lang/reflect/Type;", "resolutionContext", "serialization"})
    public static final class Companion {
        @NotNull
        public final TypeIdentifier forClass(@NotNull Class<?> type) {
            TypeIdentifier typeIdentifier;
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            if (Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Object")) {
                typeIdentifier = TopType.INSTANCE;
            } else if (type.isArray()) {
                Class<?> clazz = type.getComponentType();
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
                typeIdentifier = new ArrayOf(this.forClass(clazz));
            } else {
                TypeVariable<Class<?>>[] typeVariableArray = type.getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"type.typeParameters");
                TypeVariable<Class<?>>[] typeVariableArray2 = typeVariableArray;
                if (typeVariableArray2.length == 0) {
                    String string = type.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.name");
                    typeIdentifier = new Unparameterised(string);
                } else {
                    String string = type.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.name");
                    typeIdentifier = new Erased(string, type.getTypeParameters().length);
                }
            }
            return typeIdentifier;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TypeIdentifier forGenericType(@NotNull Type type, @NotNull Type resolutionContext) {
            TypeIdentifier typeIdentifier;
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)resolutionContext, (String)"resolutionContext");
            Type type2 = type;
            if (type2 instanceof ParameterizedType) {
                Collection<TypeIdentifier> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                TypeIdentifier typeIdentifier2;
                TypeIdentifier typeIdentifier3;
                Type[] it;
                Parameterised parameterised;
                Parameterised parameterised2;
                String string;
                Type[] typeArray;
                Parameterised parameterised3;
                Parameterised parameterised4 = parameterised3;
                Parameterised parameterised5 = parameterised3;
                Type type3 = ((ParameterizedType)type).getRawType();
                if (type3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                String string2 = ((Class)type3).getName();
                String string3 = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(type.rawType as Class<*>).name");
                Type[] typeArray2 = ((ParameterizedType)type).getOwnerType();
                if (typeArray2 != null) {
                    typeArray = typeArray2;
                    string = string3;
                    parameterised2 = parameterised4;
                    parameterised = parameterised5;
                    it = typeArray;
                    typeIdentifier3 = net.corda.serialization.internal.model.TypeIdentifier$Companion.forGenericType$default(Companion, (Type)it, null, 2, null);
                    parameterised5 = parameterised;
                    parameterised4 = parameterised2;
                    string3 = string;
                    typeIdentifier2 = typeIdentifier3;
                } else {
                    typeIdentifier2 = null;
                }
                Type[] typeArray3 = ((ParameterizedType)type).getActualTypeArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeArray3, (String)"type.actualTypeArguments");
                typeArray = typeArray3;
                typeIdentifier3 = typeIdentifier2;
                string = string3;
                parameterised2 = parameterised4;
                parameterised = parameterised5;
                it = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                int n = ((void)$receiver$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it2;
                    void item$iv$iv;
                    void var10_16 = item$iv$iv = $receiver$iv$iv[i];
                    collection = destination$iv$iv;
                    void v9 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                    Type resolved = TypeIdentifierKt.resolveAgainst((Type)v9, resolutionContext);
                    TypeIdentifier typeIdentifier4 = Intrinsics.areEqual((Object)resolved, (Object)type) ? (TypeIdentifier)UnknownType.INSTANCE : net.corda.serialization.internal.model.TypeIdentifier$Companion.forGenericType$default(Companion, resolved, null, 2, null);
                    collection.add(typeIdentifier4);
                }
                collection = (List)destination$iv$iv;
                parameterised2(string, typeIdentifier3, (List<? extends TypeIdentifier>)collection);
                typeIdentifier = parameterised;
            } else if (type2 instanceof Class) {
                typeIdentifier = this.forClass((Class)type);
            } else if (type2 instanceof GenericArrayType) {
                Type type4 = ((GenericArrayType)type).getGenericComponentType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"type.genericComponentType");
                typeIdentifier = new ArrayOf(net.corda.serialization.internal.model.TypeIdentifier$Companion.forGenericType$default(this, TypeIdentifierKt.resolveAgainst(type4, resolutionContext), null, 2, null));
            } else {
                Type type5;
                Type it;
                typeIdentifier = type2 instanceof WildcardType ? (Intrinsics.areEqual((Object)(it = (type5 = TypeIdentifierKt.access$getUpperBound$p(type))), (Object)type) ? (TypeIdentifier)UnknownType.INSTANCE : net.corda.serialization.internal.model.TypeIdentifier$Companion.forGenericType$default(Companion, it, null, 2, null)) : (TypeIdentifier)UnknownType.INSTANCE;
            }
            return typeIdentifier;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TypeIdentifier forGenericType$default(Companion companion, Type type, Type type2, int n, Object object) {
            if ((n & 2) != 0) {
                type2 = type;
            }
            return companion.forGenericType(type, type2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

