/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.carpenter.CarpenterSchemaFactory;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterException;
import net.corda.serialization.internal.carpenter.ClassField;
import net.corda.serialization.internal.carpenter.EnumField;
import net.corda.serialization.internal.carpenter.EnumSchema;
import net.corda.serialization.internal.carpenter.FieldFactory;
import net.corda.serialization.internal.carpenter.Schema;
import net.corda.serialization.internal.carpenter.UncarpentableException;
import net.corda.serialization.internal.model.RemotePropertyInformation;
import net.corda.serialization.internal.model.RemoteTypeCarpenter;
import net.corda.serialization.internal.model.RemoteTypeInformation;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J8\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u00132\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\u00180\u0012H\u0002J(\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001a2\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u001d*\u00020 H\u0002J\f\u0010!\u001a\u00020\u001d*\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lnet/corda/serialization/internal/model/SchemaBuildingRemoteTypeCarpenter;", "Lnet/corda/serialization/internal/model/RemoteTypeCarpenter;", "carpenter", "Lnet/corda/serialization/internal/carpenter/ClassCarpenter;", "(Lnet/corda/serialization/internal/carpenter/ClassCarpenter;)V", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "erasedLocalClass", "Ljava/lang/Class;", "Lnet/corda/serialization/internal/model/RemoteTypeInformation;", "getErasedLocalClass", "(Lnet/corda/serialization/internal/model/RemoteTypeInformation;)Ljava/lang/Class;", "carpent", "Ljava/lang/reflect/Type;", "typeInformation", "getFields", "", "", "Lnet/corda/serialization/internal/model/PropertyName;", "Lnet/corda/serialization/internal/carpenter/ClassField;", "ownerName", "properties", "Lnet/corda/serialization/internal/model/RemotePropertyInformation;", "getInterfaces", "", "interfaces", "carpentComposable", "", "Lnet/corda/serialization/internal/model/RemoteTypeInformation$Composable;", "carpentEnum", "Lnet/corda/serialization/internal/model/RemoteTypeInformation$AnEnum;", "carpentInterface", "Lnet/corda/serialization/internal/model/RemoteTypeInformation$AnInterface;", "serialization"})
public final class SchemaBuildingRemoteTypeCarpenter
implements RemoteTypeCarpenter {
    private final ClassCarpenter carpenter;

    private final ClassLoader getClassLoader() {
        return this.carpenter.getClassloader();
    }

    @Override
    @NotNull
    public Type carpent(@NotNull RemoteTypeInformation typeInformation) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)typeInformation, (String)"typeInformation");
        try {
            object = typeInformation;
            if (object instanceof RemoteTypeInformation.AnInterface) {
                this.carpentInterface((RemoteTypeInformation.AnInterface)typeInformation);
            } else if (object instanceof RemoteTypeInformation.Composable) {
                if (!(typeInformation.getTypeIdentifier() instanceof TypeIdentifier.Parameterised)) {
                    this.carpentComposable((RemoteTypeInformation.Composable)typeInformation);
                }
            } else if (object instanceof RemoteTypeInformation.AnEnum) {
                this.carpentEnum((RemoteTypeInformation.AnEnum)typeInformation);
            }
        }
        catch (ClassCarpenterException e) {
            throw (Throwable)new NotSerializableException(typeInformation.getTypeIdentifier().getName() + ": " + e.getMessage());
        }
        try {
            object = typeInformation.getTypeIdentifier().getLocalType(this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw (Throwable)new NotSerializableException("Could not carpent " + typeInformation.getTypeIdentifier().prettyPrint(false));
        }
        return object;
    }

    private final Class<?> getErasedLocalClass(@NotNull RemoteTypeInformation $receiver) {
        return SerializationHelperKt.asClass($receiver.getTypeIdentifier().getLocalType(this.getClassLoader()));
    }

    private final void carpentInterface(@NotNull RemoteTypeInformation.AnInterface $receiver) {
        Map<String, ClassField> fields = this.getFields($receiver.getTypeIdentifier().getName(), $receiver.getProperties());
        Schema schema = CarpenterSchemaFactory.INSTANCE.newInstance($receiver.getTypeIdentifier().getName(), fields, this.getInterfaces($receiver.getTypeIdentifier().getName(), $receiver.getInterfaces()), true);
        this.carpenter.build(schema);
    }

    private final void carpentComposable(@NotNull RemoteTypeInformation.Composable $receiver) {
        Map<String, ClassField> fields = this.getFields($receiver.getTypeIdentifier().getName(), $receiver.getProperties());
        Schema schema = CarpenterSchemaFactory.INSTANCE.newInstance($receiver.getTypeIdentifier().getName(), fields, this.getInterfaces($receiver.getTypeIdentifier().getName(), $receiver.getInterfaces()), false);
        this.carpenter.build(schema);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ClassField> getFields(String ownerName, Map<String, RemotePropertyInformation> properties2) {
        void $receiver$iv$iv;
        Map<String, RemotePropertyInformation> $receiver$iv;
        Map<String, RemotePropertyInformation> map = $receiver$iv = properties2;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $name_property;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            ClassField classField = $name_property;
            String name = (String)classField.getKey();
            classField = $name_property;
            RemotePropertyInformation property = (RemotePropertyInformation)classField.getValue();
            try {
                classField = FieldFactory.INSTANCE.newInstance(property.isMandatory(), name, this.getErasedLocalClass(property.getType()));
            }
            catch (ClassNotFoundException e) {
                throw (Throwable)((Object)new UncarpentableException(ownerName, name, property.getType().getTypeIdentifier().getName()));
            }
            ClassField classField2 = classField;
            map3.put(k2, classField2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Class<?>> getInterfaces(String ownerName, List<? extends RemoteTypeInformation> interfaces) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)interfaces;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Class<?> clazz;
            void it;
            RemoteTypeInformation remoteTypeInformation = (RemoteTypeInformation)item$iv$iv;
            Collection collection = destination$iv$iv;
            try {
                clazz = this.getErasedLocalClass((RemoteTypeInformation)it);
            }
            catch (ClassNotFoundException e) {
                throw (Throwable)((Object)new UncarpentableException(ownerName, "[interface]", it.getTypeIdentifier().getName()));
            }
            Class<?> clazz2 = clazz;
            collection.add(clazz2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void carpentEnum(@NotNull RemoteTypeInformation.AnEnum $receiver) {
        void $receiver$iv$iv;
        void $receiver$iv;
        EnumSchema enumSchema;
        Iterable iterable = $receiver.getMembers();
        String string = $receiver.getTypeIdentifier().getName();
        EnumSchema enumSchema2 = enumSchema;
        EnumSchema enumSchema3 = enumSchema;
        ClassCarpenter classCarpenter = this.carpenter;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var4_8 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)new EnumField());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        enumSchema2(string, map);
        classCarpenter.build(enumSchema3);
    }

    public SchemaBuildingRemoteTypeCarpenter(@NotNull ClassCarpenter carpenter) {
        Intrinsics.checkParameterIsNotNull((Object)carpenter, (String)"carpenter");
        this.carpenter = carpenter;
    }
}

