/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.utilities.EncodingUtils;
import net.corda.core.utilities.KotlinUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/corda/serialization/internal/model/FingerprintWriter;", "", "debugEnabled", "", "(Z)V", "debugBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fingerprint", "", "getFingerprint", "()Ljava/lang/String;", "fingerprint$delegate", "Lkotlin/Lazy;", "hasher", "Lcom/google/common/hash/Hasher;", "kotlin.jvm.PlatformType", "append", "chars", "", "write", "words", "", "writeAlreadySeen", "writeArray", "writeEnum", "writeNotNullable", "writeNullable", "writeTop", "writeUnknown", "Companion", "serialization"})
public final class FingerprintWriter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final StringBuilder debugBuffer;
    private Hasher hasher;
    @NotNull
    private final Lazy fingerprint$delegate;
    private static final String ARRAY_HASH = "Array = true";
    private static final String ENUM_HASH = "Enum = true";
    private static final String ALREADY_SEEN_HASH = "Already seen = true";
    private static final String NULLABLE_HASH = "Nullable = true";
    private static final String NOT_NULLABLE_HASH = "Nullable = false";
    private static final String ANY_TYPE_HASH = "Any type = true";
    private static final Logger logger;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FingerprintWriter.class), "fingerprint", "getFingerprint()Ljava/lang/String;"))};
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public final FingerprintWriter write(@NotNull CharSequence chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return this.append(chars);
    }

    @NotNull
    public final FingerprintWriter write(@NotNull List<? extends CharSequence> words) {
        Intrinsics.checkParameterIsNotNull(words, (String)"words");
        return this.append(CollectionsKt.joinToString$default((Iterable)words, null, null, null, (int)0, null, null, (int)63, null));
    }

    @NotNull
    public final FingerprintWriter writeAlreadySeen() {
        return this.append(ALREADY_SEEN_HASH);
    }

    @NotNull
    public final FingerprintWriter writeEnum() {
        return this.append(ENUM_HASH);
    }

    @NotNull
    public final FingerprintWriter writeArray() {
        return this.append(ARRAY_HASH);
    }

    @NotNull
    public final FingerprintWriter writeNullable() {
        return this.append(NULLABLE_HASH);
    }

    @NotNull
    public final FingerprintWriter writeNotNullable() {
        return this.append(NOT_NULLABLE_HASH);
    }

    @NotNull
    public final FingerprintWriter writeUnknown() {
        return this.append(ANY_TYPE_HASH);
    }

    @NotNull
    public final FingerprintWriter writeTop() {
        String string = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Any::class.java.name");
        return this.append(string);
    }

    private final FingerprintWriter append(CharSequence chars) {
        FingerprintWriter fingerprintWriter;
        FingerprintWriter $receiver = fingerprintWriter = this;
        StringBuilder stringBuilder = $receiver.debugBuffer;
        if (stringBuilder != null) {
            stringBuilder.append(chars);
        }
        $receiver.hasher = $receiver.hasher.putUnencodedChars(chars);
        return fingerprintWriter;
    }

    @NotNull
    public final String getFingerprint() {
        Lazy lazy = this.fingerprint$delegate;
        FingerprintWriter fingerprintWriter = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    public FingerprintWriter(boolean debugEnabled) {
        this.debugBuffer = debugEnabled ? new StringBuilder() : null;
        this.hasher = Hashing.murmur3_128().newHasher();
        this.fingerprint$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ FingerprintWriter this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void var1_1;
                byte[] byArray = FingerprintWriter.access$getHasher$p(this.this$0).hash().asBytes();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"hasher.hash().asBytes()");
                String fingerprint2 = EncodingUtils.toBase64((byte[])byArray);
                if (FingerprintWriter.access$getDebugBuffer$p(this.this$0) != null) {
                    FingerprintWriter.access$getLogger$cp().info(fingerprint2 + " from " + FingerprintWriter.access$getDebugBuffer$p(this.this$0));
                }
                return var1_1;
            }
            {
                this.this$0 = fingerprintWriter;
                super(0);
            }
        }));
    }

    public /* synthetic */ FingerprintWriter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public FingerprintWriter() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Hasher access$getHasher$p(FingerprintWriter $this) {
        return $this.hasher;
    }

    public static final /* synthetic */ void access$setHasher$p(FingerprintWriter $this, Hasher hasher) {
        $this.hasher = hasher;
    }

    @Nullable
    public static final /* synthetic */ StringBuilder access$getDebugBuffer$p(FingerprintWriter $this) {
        return $this.debugBuffer;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/model/FingerprintWriter$Companion;", "", "()V", "ALREADY_SEEN_HASH", "", "ANY_TYPE_HASH", "ARRAY_HASH", "ENUM_HASH", "NOT_NULLABLE_HASH", "NULLABLE_HASH", "logger", "Lorg/slf4j/Logger;", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

