/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.carpenter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.DeleteForDJVM;
import net.corda.serialization.internal.carpenter.ClassField;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lnet/corda/serialization/internal/carpenter/NonNullableField;", "Lnet/corda/serialization/internal/carpenter/ClassField;", "name", "", "field", "Ljava/lang/Class;", "", "(Ljava/lang/String;Ljava/lang/Class;)V", "(Ljava/lang/Class;)V", "nullabilityAnnotation", "getNullabilityAnnotation", "()Ljava/lang/String;", "nullTest", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "slot", "", "serialization"})
@DeleteForDJVM
public class NonNullableField
extends ClassField {
    @NotNull
    private final String nullabilityAnnotation = "Ljavax/annotation/Nonnull;";

    @Override
    @NotNull
    public String getNullabilityAnnotation() {
        return this.nullabilityAnnotation;
    }

    @Override
    public void nullTest(@NotNull MethodVisitor mv, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)mv, (String)"mv");
        boolean bl = Intrinsics.areEqual((Object)this.getName(), (Object)"Unset") ^ true;
        if (!bl) {
            String string = "Property this.name cannot be Unset";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (!this.getField().isPrimitive()) {
            MethodVisitor $receiver = mv;
            $receiver.visitVarInsn(25, 0);
            $receiver.visitVarInsn(25, slot);
            $receiver.visitLdcInsn((Object)("param \"" + this.getName() + "\" cannot be null"));
            $receiver.visitMethodInsn(184, "java/util/Objects", "requireNonNull", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
            $receiver.visitInsn(87);
        }
    }

    public NonNullableField(@NotNull Class<? extends Object> field) {
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        super(field);
        this.nullabilityAnnotation = "Ljavax/annotation/Nonnull;";
    }

    public NonNullableField(@NotNull String name, @NotNull Class<? extends Object> field) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        this(field);
        this.setName(name);
    }
}

