/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.carpenter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.DeleteForDJVM;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.serialization.internal.carpenter.CarpenterClassLoader;
import net.corda.serialization.internal.carpenter.ClassCarpenter;
import net.corda.serialization.internal.carpenter.ClassCarpenterImpl;
import net.corda.serialization.internal.carpenter.ClassCarpenterKt;
import net.corda.serialization.internal.carpenter.ClassField;
import net.corda.serialization.internal.carpenter.ClassSchema;
import net.corda.serialization.internal.carpenter.DuplicateNameException;
import net.corda.serialization.internal.carpenter.EnumSchema;
import net.corda.serialization.internal.carpenter.Field;
import net.corda.serialization.internal.carpenter.InterfaceMismatchMissingAMQPFieldException;
import net.corda.serialization.internal.carpenter.InterfaceMismatchNonGetterException;
import net.corda.serialization.internal.carpenter.InterfaceSchema;
import net.corda.serialization.internal.carpenter.Schema;
import net.corda.serialization.internal.carpenter.SchemaKt;
import net.corda.serialization.internal.carpenter.SimpleFieldAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J.\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u0014\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010$\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010&\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010'\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010(\u001a\u00020\u001e*\u00020\u001dH\u0002J\u0014\u0010)\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010*\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010+\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010,\u001a\u00020\u001e*\u00020\u001dH\u0002J\u0014\u0010-\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010.\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010/\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u00100\u001a\u000201*\u0002022\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lnet/corda/serialization/internal/carpenter/ClassCarpenterImpl;", "Lnet/corda/serialization/internal/carpenter/ClassCarpenter;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "cl", "Ljava/lang/ClassLoader;", "lenient", "", "(Lnet/corda/core/serialization/ClassWhitelist;Ljava/lang/ClassLoader;Z)V", "_loaded", "Ljava/util/HashMap;", "", "Ljava/lang/Class;", "classloader", "Lnet/corda/serialization/internal/carpenter/CarpenterClassLoader;", "getClassloader", "()Lnet/corda/serialization/internal/carpenter/CarpenterClassLoader;", "loaded", "", "getLoaded", "()Ljava/util/Map;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "build", "schema", "Lnet/corda/serialization/internal/carpenter/Schema;", "generate", "generator", "Lkotlin/Function2;", "Lorg/objectweb/asm/ClassWriter;", "", "generateClass", "classSchema", "generateEnum", "enumSchema", "generateInterface", "interfaceSchema", "validateSchema", "generateAbstractGetters", "generateClassConstructor", "generateEnumConstructor", "generateEnumValueOf", "generateEnumValues", "generateFields", "generateGetMethod", "generateGetters", "generateStaticEnumConstructor", "generateToString", "load", "", "Lorg/objectweb/asm/MethodVisitor;", "slot", "type", "Lnet/corda/serialization/internal/carpenter/Field;", "Companion", "serialization"})
@DeleteForDJVM
public final class ClassCarpenterImpl
implements ClassCarpenter {
    @NotNull
    private final CarpenterClassLoader classloader;
    private final HashMap<String, Class<?>> _loaded;
    @NotNull
    private final Map<String, Class<?>> loaded;
    @NotNull
    private final ClassWhitelist whitelist;
    private final boolean lenient;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public CarpenterClassLoader getClassloader() {
        return this.classloader;
    }

    @NotNull
    public final Map<String, Class<?>> getLoaded() {
        return this.loaded;
    }

    @Override
    @NotNull
    public Class<?> build(@NotNull Schema schema) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.validateSchema(schema);
        ArrayList hierarchy = new ArrayList();
        Collection collection = hierarchy;
        collection.add(schema);
        for (Schema cursor = schema.getSuperclass(); cursor != null && !(object3 = (object2 = (Map)this._loaded)).containsKey(object = cursor.getName()); cursor = cursor.getSuperclass()) {
            object2 = hierarchy;
            object2.add(cursor);
        }
        Iterable $receiver$iv = CollectionsKt.reversed((Iterable)hierarchy);
        for (Object element$iv : $receiver$iv) {
            Schema it = (Schema)element$iv;
            Schema schema2 = it;
            if (schema2 instanceof InterfaceSchema) {
                this.generateInterface(it);
                continue;
            }
            if (schema2 instanceof ClassSchema) {
                this.generateClass(it);
                continue;
            }
            if (!(schema2 instanceof EnumSchema)) continue;
            this.generateEnum(it);
        }
        object2 = this._loaded;
        object3 = object2;
        object = schema.getName();
        if (!object3.containsKey(object)) {
            throw (Throwable)new ClassNotFoundException(schema.getName());
        }
        Class<?> clazz = this._loaded.get(schema.getName());
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        return clazz;
    }

    private final Class<?> generateEnum(Schema enumSchema) {
        return this.generate(enumSchema, (Function2<? super ClassWriter, ? super Schema, Unit>)((Function2)new Function2<ClassWriter, Schema, Unit>(this){
            final /* synthetic */ ClassCarpenterImpl this$0;

            public final void invoke(@NotNull ClassWriter cw, @NotNull Schema schema) {
                ClassWriter classWriter;
                Intrinsics.checkParameterIsNotNull((Object)cw, (String)"cw");
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                ClassWriter $receiver = classWriter = cw;
                $receiver.visit(52, 16433, schema.getJvmName(), 'L' + ClassCarpenterKt.access$getJlEnum$p() + "<L" + schema.getJvmName() + ";>;", ClassCarpenterKt.access$getJlEnum$p(), null);
                if (SchemaKt.cordaSerializable(schema.getFlags())) {
                    $receiver.visitAnnotation(Type.getDescriptor(CordaSerializable.class), true).visitEnd();
                }
                ClassCarpenterImpl.access$generateFields(this.this$0, $receiver, schema);
                ClassCarpenterImpl.access$generateStaticEnumConstructor(this.this$0, $receiver, schema);
                ClassCarpenterImpl.access$generateEnumConstructor(this.this$0, $receiver);
                ClassCarpenterImpl.access$generateEnumValues(this.this$0, $receiver, schema);
                ClassCarpenterImpl.access$generateEnumValueOf(this.this$0, $receiver, schema);
                classWriter.visitEnd();
            }
            {
                this.this$0 = classCarpenterImpl;
                super(2);
            }
        }));
    }

    private final Class<?> generateInterface(Schema interfaceSchema) {
        return this.generate(interfaceSchema, (Function2<? super ClassWriter, ? super Schema, Unit>)((Function2)new Function2<ClassWriter, Schema, Unit>(this){
            final /* synthetic */ ClassCarpenterImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassWriter cw, @NotNull Schema schema) {
                ClassWriter classWriter;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)cw, (String)"cw");
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                Iterable iterable = $receiver$iv = (Iterable)schema.getInterfaces();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Class clazz = (Class)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = Type.getInternalName((Class)it);
                    collection.add(string);
                }
                $receiver$iv = (List)destination$iv$iv;
                Iterable thisCollection$iv = $receiver$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] interfaces = stringArray;
                ClassWriter $receiver = classWriter = cw;
                $receiver.visit(52, 1537, schema.getJvmName(), null, ClassCarpenterKt.access$getJlObject$p(), interfaces);
                if (SchemaKt.cordaSerializable(schema.getFlags())) {
                    $receiver.visitAnnotation(Type.getDescriptor(CordaSerializable.class), true).visitEnd();
                }
                ClassCarpenterImpl.access$generateAbstractGetters(this.this$0, $receiver, schema);
                classWriter.visitEnd();
            }
            {
                this.this$0 = classCarpenterImpl;
                super(2);
            }
        }));
    }

    private final Class<?> generateClass(Schema classSchema) {
        return this.generate(classSchema, (Function2<? super ClassWriter, ? super Schema, Unit>)((Function2)new Function2<ClassWriter, Schema, Unit>(this){
            final /* synthetic */ ClassCarpenterImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassWriter cw, @NotNull Schema schema) {
                void $receiver$iv;
                ClassWriter classWriter;
                Object object;
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)cw, (String)"cw");
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                Object object2 = schema.getSuperclass();
                if (object2 == null || (object2 = ((Schema)object2).getJvmName()) == null) {
                    object2 = ClassCarpenterKt.access$getJlObject$p();
                }
                Object superName = object2;
                Iterable iterable = $receiver$iv2 = (Iterable)schema.getInterfaces();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    object = (Class)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = Type.getInternalName((Class)it);
                    collection.add(string);
                }
                List interfaces = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (!schema.getInterfaces().contains(SimpleFieldAccess.class) && SchemaKt.cordaSerializable(schema.getFlags()) && SchemaKt.simpleFieldAccess(schema.getFlags())) {
                    interfaces.add(Type.getInternalName(SimpleFieldAccess.class));
                }
                ClassWriter $receiver = classWriter = cw;
                destination$iv$iv = interfaces;
                Object object3 = superName;
                String string = null;
                object = schema.getJvmName();
                int n = 33;
                int n2 = 52;
                ClassWriter classWriter2 = $receiver;
                void v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v1;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                classWriter2.visit(n2, n, (String)object, string, (String)object3, stringArray2);
                if (SchemaKt.cordaSerializable(schema.getFlags())) {
                    $receiver.visitAnnotation(Type.getDescriptor(CordaSerializable.class), true).visitEnd();
                }
                ClassCarpenterImpl.access$generateFields(this.this$0, $receiver, schema);
                ClassCarpenterImpl.access$generateClassConstructor(this.this$0, $receiver, schema);
                ClassCarpenterImpl.access$generateGetters(this.this$0, $receiver, schema);
                if (schema.getSuperclass() == null) {
                    ClassCarpenterImpl.access$generateGetMethod(this.this$0, $receiver);
                }
                ClassCarpenterImpl.access$generateToString(this.this$0, $receiver, schema);
                classWriter.visitEnd();
            }
            {
                this.this$0 = classCarpenterImpl;
                super(2);
            }
        }));
    }

    private final Class<?> generate(Schema schema, Function2<? super ClassWriter, ? super Schema, Unit> generator) {
        ClassWriter cw = new ClassWriter(3);
        generator.invoke((Object)cw, (Object)schema);
        CarpenterClassLoader carpenterClassLoader = this.getClassloader();
        String string = schema.getName();
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        Class<?> clazz = carpenterClassLoader.load(string, byArray);
        Map map = this._loaded;
        String string2 = schema.getName();
        Class<?> clazz2 = clazz;
        map.put(string2, clazz2);
        return clazz;
    }

    private final void generateFields(@NotNull ClassWriter $receiver, Schema schema) {
        schema.generateFields($receiver);
    }

    private final void generateToString(@NotNull ClassWriter $receiver, Schema schema) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(1, "toString", "()L" + ClassCarpenterKt.access$getJlString$p() + ';', null, null);
        $receiver2.visitCode();
        $receiver2.visitLdcInsn(CollectionsKt.last((List)StringsKt.split$default((CharSequence)schema.getName(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)));
        $receiver2.visitMethodInsn(184, ClassCarpenterKt.access$getMoreObjects$p(), "toStringHelper", "(L" + ClassCarpenterKt.access$getJlString$p() + ";)L" + ClassCarpenterKt.access$getToStringHelper$p() + ';', false);
        Iterator<Map.Entry<String, Field>> iterator = schema.fieldsIncludingSuperclasses().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Field> entry;
            Map.Entry<String, Field> entry2 = entry = iterator.next();
            String name = entry2.getKey();
            entry2 = entry;
            Field field = entry2.getValue();
            $receiver2.visitLdcInsn((Object)name);
            $receiver2.visitVarInsn(25, 0);
            $receiver2.visitFieldInsn(180, schema.getJvmName(), name, schema.descriptorsIncludingSuperclasses().get(name));
            $receiver2.visitMethodInsn(182, ClassCarpenterKt.access$getToStringHelper$p(), "add", "(L" + ClassCarpenterKt.access$getJlString$p() + ';' + field.getType() + ")L" + ClassCarpenterKt.access$getToStringHelper$p() + ';', false);
        }
        $receiver2.visitMethodInsn(182, ClassCarpenterKt.access$getToStringHelper$p(), "toString", "()L" + ClassCarpenterKt.access$getJlString$p() + ';', false);
        $receiver2.visitInsn(176);
        $receiver2.visitMaxs(0, 0);
        $receiver2.visitEnd();
    }

    private final void generateGetMethod(@NotNull ClassWriter $receiver) {
        MethodVisitor methodVisitor;
        String ourJvmName = Type.getInternalName(ClassCarpenterImpl.class);
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(1, "get", "(L" + ClassCarpenterKt.access$getJlString$p() + ";)L" + ClassCarpenterKt.access$getJlObject$p() + ';', null, null);
        $receiver2.visitCode();
        $receiver2.visitVarInsn(25, 0);
        $receiver2.visitVarInsn(25, 1);
        $receiver2.visitMethodInsn(184, ourJvmName, "getField", "(L" + ClassCarpenterKt.access$getJlObject$p() + ";L" + ClassCarpenterKt.access$getJlString$p() + ";)L" + ClassCarpenterKt.access$getJlObject$p() + ';', false);
        $receiver2.visitInsn(176);
        $receiver2.visitMaxs(0, 0);
        $receiver2.visitEnd();
    }

    private final void generateGetters(@NotNull ClassWriter $receiver, Schema schema) {
        Map<String, Field> map = schema.getFields();
        Iterator<Map.Entry<String, Field>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodVisitor methodVisitor;
            MethodVisitor methodVisitor2 = methodVisitor = iterator.next();
            String name = methodVisitor2.getKey();
            methodVisitor2 = methodVisitor;
            Field type = methodVisitor2.getValue();
            MethodVisitor $receiver2 = methodVisitor2 = $receiver.visitMethod(1, "get" + StringsKt.capitalize((String)name), "()" + type.getDescriptor(), null, null);
            Field field = type;
            if (field == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.ClassField");
            }
            ClassField classField = (ClassField)field;
            MethodVisitor methodVisitor3 = $receiver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor3, (String)"this");
            classField.addNullabilityAnnotation(methodVisitor3);
            $receiver2.visitCode();
            $receiver2.visitVarInsn(25, 0);
            $receiver2.visitFieldInsn(180, schema.getJvmName(), name, type.getDescriptor());
            Class<? extends Object> clazz = type.getField();
            if (Intrinsics.areEqual(clazz, Boolean.TYPE) || Intrinsics.areEqual(clazz, Integer.TYPE) || Intrinsics.areEqual(clazz, Short.TYPE) || Intrinsics.areEqual(clazz, Byte.TYPE) || Intrinsics.areEqual(clazz, Character.TYPE)) {
                $receiver2.visitInsn(172);
            } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                $receiver2.visitInsn(173);
            } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
                $receiver2.visitInsn(175);
            } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                $receiver2.visitInsn(174);
            } else {
                $receiver2.visitInsn(176);
            }
            $receiver2.visitMaxs(0, 0);
            methodVisitor2.visitEnd();
        }
    }

    private final void generateAbstractGetters(@NotNull ClassWriter $receiver, Schema schema) {
        Map<String, Field> map = schema.getFields();
        Iterator<Map.Entry<String, Field>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Field> entry;
            Map.Entry<String, Field> entry2 = entry = iterator.next();
            String name = entry2.getKey();
            entry2 = entry;
            Field field = entry2.getValue();
            int opcodes = 1025;
            $receiver.visitMethod(opcodes, "get" + StringsKt.capitalize((String)name), "()" + field.getDescriptor(), null, null).visitEnd();
        }
    }

    private final void generateStaticEnumConstructor(@NotNull ClassWriter $receiver, Schema schema) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(8, "<clinit>", "()V", null, null);
        $receiver2.visitCode();
        $receiver2.visitIntInsn(16, schema.getFields().size());
        $receiver2.visitTypeInsn(189, schema.getJvmName());
        $receiver2.visitInsn(89);
        int idx = 0;
        Iterable $receiver$iv = schema.getFields().keySet();
        for (Object element$iv : $receiver$iv) {
            String key = (String)element$iv;
            $receiver2.visitInsn(89);
            $receiver2.visitIntInsn(16, idx);
            $receiver2.visitTypeInsn(187, schema.getJvmName());
            $receiver2.visitInsn(89);
            $receiver2.visitLdcInsn((Object)key);
            int n = idx;
            idx = n + 1;
            $receiver2.visitIntInsn(16, n);
            $receiver2.visitMethodInsn(183, schema.getJvmName(), "<init>", "(L" + ClassCarpenterKt.access$getJlString$p() + ";I)V", false);
            $receiver2.visitInsn(89);
            $receiver2.visitFieldInsn(179, schema.getJvmName(), key, 'L' + schema.getJvmName() + ';');
            $receiver2.visitInsn(83);
        }
        $receiver2.visitFieldInsn(179, schema.getJvmName(), "$VALUES", schema.getAsArray());
        $receiver2.visitInsn(177);
        $receiver2.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private final void generateEnumValues(@NotNull ClassWriter $receiver, Schema schema) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(9, "values", "()" + schema.getAsArray(), null, null);
        $receiver2.visitCode();
        $receiver2.visitFieldInsn(178, schema.getJvmName(), "$VALUES", schema.getAsArray());
        $receiver2.visitMethodInsn(182, schema.getAsArray(), "clone", "()L" + ClassCarpenterKt.access$getJlObject$p() + ';', false);
        $receiver2.visitTypeInsn(192, schema.getAsArray());
        $receiver2.visitInsn(176);
        $receiver2.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private final void generateEnumValueOf(@NotNull ClassWriter $receiver, Schema schema) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(9, "valueOf", "(L" + ClassCarpenterKt.access$getJlString$p() + ";)L" + schema.getJvmName() + ';', null, null);
        $receiver2.visitCode();
        $receiver2.visitLdcInsn((Object)Type.getType((String)('L' + schema.getJvmName() + ';')));
        $receiver2.visitVarInsn(25, 0);
        $receiver2.visitMethodInsn(184, ClassCarpenterKt.access$getJlEnum$p(), "valueOf", "(L" + ClassCarpenterKt.access$getJlClass$p() + ";L" + ClassCarpenterKt.access$getJlString$p() + ";)L" + ClassCarpenterKt.access$getJlEnum$p() + ';', false);
        $receiver2.visitTypeInsn(192, schema.getJvmName());
        $receiver2.visitInsn(176);
        $receiver2.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private final void generateEnumConstructor(@NotNull ClassWriter $receiver) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(4, "<init>", "(L" + ClassCarpenterKt.access$getJlString$p() + ";I)V", "()V", null);
        $receiver2.visitParameter("$enum$name", 4096);
        $receiver2.visitParameter("$enum$ordinal", 4096);
        $receiver2.visitCode();
        $receiver2.visitVarInsn(25, 0);
        $receiver2.visitVarInsn(25, 1);
        $receiver2.visitVarInsn(21, 2);
        $receiver2.visitMethodInsn(183, ClassCarpenterKt.access$getJlEnum$p(), "<init>", "(L" + ClassCarpenterKt.access$getJlString$p() + ";I)V", false);
        $receiver2.visitInsn(177);
        $receiver2.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateClassConstructor(@NotNull ClassWriter $receiver, Schema schema) {
        MethodVisitor methodVisitor;
        MethodVisitor $receiver2 = methodVisitor = $receiver.visitMethod(1, "<init>", "(" + CollectionsKt.joinToString$default((Iterable)schema.descriptorsIncludingSuperclasses().values(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + ")V", null, null);
        int idx = 0;
        Iterable $receiver$iv = schema.getFields().values();
        for (Object element$iv : $receiver$iv) {
            Field it = (Field)element$iv;
            MethodVisitor methodVisitor2 = $receiver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor2, (String)"this");
            int n = idx;
            idx = n + 1;
            it.visitParameter(methodVisitor2, n);
        }
        $receiver2.visitCode();
        $receiver2.visitVarInsn(25, 0);
        Schema sc = schema.getSuperclass();
        int slot = 1;
        if (sc == null) {
            $receiver2.visitMethodInsn(183, ClassCarpenterKt.access$getJlObject$p(), "<init>", "()V", false);
        } else {
            void $receiver$iv2;
            int initial$iv;
            Object element$iv;
            element$iv = sc.fieldsIncludingSuperclasses().values();
            int accumulator$iv = initial$iv = slot;
            for (Object element$iv2 : $receiver$iv2) {
                void field;
                Field field2 = (Field)element$iv2;
                int acc = accumulator$iv;
                accumulator$iv = acc + this.load($receiver2, acc, (Field)field);
            }
            slot = accumulator$iv;
            String superDesc = CollectionsKt.joinToString$default((Iterable)sc.descriptorsIncludingSuperclasses().values(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            $receiver2.visitMethodInsn(183, sc.getJvmName(), "<init>", '(' + superDesc + ")V", false);
        }
        Map<String, Field> accumulator$iv = schema.getFields();
        Iterator<Map.Entry<String, Field>> iterator = accumulator$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Field field;
            Map.Entry<String, Field> entry;
            Map.Entry<String, Field> entry2 = entry = iterator.next();
            String name = entry2.getKey();
            entry2 = entry;
            Field field3 = field = entry2.getValue();
            if (field3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.serialization.internal.carpenter.ClassField");
            }
            ClassField classField = (ClassField)field3;
            MethodVisitor methodVisitor3 = $receiver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor3, (String)"this");
            classField.nullTest(methodVisitor3, slot);
            $receiver2.visitVarInsn(25, 0);
            slot += this.load($receiver2, slot, field);
            $receiver2.visitFieldInsn(181, schema.getJvmName(), name, field.getDescriptor());
        }
        $receiver2.visitInsn(177);
        $receiver2.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private final int load(@NotNull MethodVisitor $receiver, int slot, Field type) {
        Class<? extends Object> clazz = type.getField();
        if (Intrinsics.areEqual(clazz, Boolean.TYPE) || Intrinsics.areEqual(clazz, Integer.TYPE) || Intrinsics.areEqual(clazz, Short.TYPE) || Intrinsics.areEqual(clazz, Byte.TYPE) || Intrinsics.areEqual(clazz, Character.TYPE)) {
            $receiver.visitVarInsn(21, slot);
        } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            $receiver.visitVarInsn(22, slot);
        } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            $receiver.visitVarInsn(24, slot);
        } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            $receiver.visitVarInsn(23, slot);
        } else {
            $receiver.visitVarInsn(25, slot);
        }
        clazz = type.getField();
        return Intrinsics.areEqual(clazz, Long.TYPE) || Intrinsics.areEqual(clazz, Double.TYPE) ? 2 : 1;
    }

    private final void validateSchema(Schema schema) {
        Map<String, Field> $receiver$iv;
        Map map = this._loaded;
        Map map2 = map;
        String string = schema.getName();
        if (map2.containsKey(string)) {
            throw (Throwable)((Object)new DuplicateNameException(schema.getName()));
        }
        validateSchema.1 isJavaName$ = validateSchema.1.INSTANCE;
        boolean bl = isJavaName$.invoke((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)schema.getName(), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null)));
        if (!bl) {
            String string2 = "Not a valid Java name: " + schema.getName();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Map<String, Field> map3 = $receiver$iv = schema.getFields();
        for (Map.Entry<String, Field> element$iv : map3.entrySet()) {
            Map.Entry<String, Field> it = element$iv;
            boolean bl2 = validateSchema.1.INSTANCE.invoke(it.getKey());
            if (bl2) continue;
            String string3 = "Not a valid Java name: " + it;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        Map<String, Field> allFields = schema.fieldsIncludingSuperclasses();
        for (Class clazz : schema.getInterfaces()) {
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Object $receiver$iv2;
                String string4;
                int $i$f$forEach;
                Method method;
                Method method2 = method = methodArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                String string5 = method2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"method.name");
                if (StringsKt.startsWith$default((String)string5, (String)"get", (boolean)false, (int)2, null)) {
                    String $i$a$3$forEach;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method.getName(), (String)"method.name");
                    $i$f$forEach = 3;
                    string4 = $i$a$3$forEach;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                } else {
                    if (this.lenient) {
                        $receiver$iv2 = logger;
                        if (!$receiver$iv2.isDebugEnabled()) continue;
                        Logger logger = $receiver$iv2;
                        String string6 = "Ignoring interface " + method + " which is not a getter";
                        logger.debug(string6);
                        continue;
                    }
                    throw (Throwable)((Object)new InterfaceMismatchNonGetterException(clazz, method));
                }
                String string7 = string4.substring($i$f$forEach);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                String fieldNameFromItf = StringsKt.decapitalize((String)string7);
                $receiver$iv2 = fieldNameFromItf;
                if ($receiver$iv2.length() == 0 && schema.getInterfaces().contains(SimpleFieldAccess.class)) continue;
                boolean bl3 = schema instanceof ClassSchema;
                $receiver$iv2 = allFields;
                Object $i$a$1$debug = $receiver$iv2;
                boolean bl4 = $i$a$1$debug.containsKey(fieldNameFromItf);
                if (!(bl3 & !bl4)) continue;
                if (this.lenient) {
                    Logger $receiver$iv3 = logger;
                    if (!$receiver$iv3.isDebugEnabled()) continue;
                    Logger logger = $receiver$iv3;
                    String string8 = "Ignoring interface " + method + " which is not backed by an AMQP field";
                    logger.debug(string8);
                    continue;
                }
                throw (Throwable)((Object)new InterfaceMismatchMissingAMQPFieldException(clazz, fieldNameFromItf));
            }
        }
    }

    @Override
    @NotNull
    public ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    @JvmOverloads
    public ClassCarpenterImpl(@NotNull ClassWhitelist whitelist, @NotNull ClassLoader cl, boolean lenient) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)cl, (String)"cl");
        this.whitelist = whitelist;
        this.lenient = lenient;
        this.classloader = new CarpenterClassLoader(cl);
        this._loaded = new HashMap();
        this.loaded = new HashMap(this._loaded);
    }

    @JvmOverloads
    public /* synthetic */ ClassCarpenterImpl(ClassWhitelist classWhitelist, ClassLoader classLoader, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            ClassLoader classLoader2 = thread.getContextClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"Thread.currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(classWhitelist, classLoader, bl);
    }

    @JvmOverloads
    public ClassCarpenterImpl(@NotNull ClassWhitelist whitelist, @NotNull ClassLoader cl) {
        this(whitelist, cl, false, 4, null);
    }

    @JvmOverloads
    public ClassCarpenterImpl(@NotNull ClassWhitelist whitelist) {
        this(whitelist, null, false, 6, null);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ void access$generateFields(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateFields($receiver, schema);
    }

    public static final /* synthetic */ void access$generateStaticEnumConstructor(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateStaticEnumConstructor($receiver, schema);
    }

    public static final /* synthetic */ void access$generateEnumConstructor(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver) {
        $this.generateEnumConstructor($receiver);
    }

    public static final /* synthetic */ void access$generateEnumValues(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateEnumValues($receiver, schema);
    }

    public static final /* synthetic */ void access$generateEnumValueOf(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateEnumValueOf($receiver, schema);
    }

    public static final /* synthetic */ void access$generateAbstractGetters(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateAbstractGetters($receiver, schema);
    }

    public static final /* synthetic */ void access$generateClassConstructor(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateClassConstructor($receiver, schema);
    }

    public static final /* synthetic */ void access$generateGetters(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateGetters($receiver, schema);
    }

    public static final /* synthetic */ void access$generateGetMethod(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver) {
        $this.generateGetMethod($receiver);
    }

    public static final /* synthetic */ void access$generateToString(ClassCarpenterImpl $this, @NotNull ClassWriter $receiver, @NotNull Schema schema) {
        $this.generateToString($receiver, schema);
    }

    @JvmStatic
    @Nullable
    public static final Object getField(@NotNull Object obj, @NotNull String name) {
        return Companion.getField(obj, name);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/corda/serialization/internal/carpenter/ClassCarpenterImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getField", "obj", "name", "", "serialization"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Object getField(@NotNull Object obj, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return obj.getClass().getMethod("get" + StringsKt.capitalize((String)name), new Class[0]).invoke(obj, new Object[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

