/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.LocalDateTimeSerializer;
import net.corda.serialization.internal.amqp.custom.ZoneIdSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 \u00112\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/custom/ZonedDateTimeSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/time/ZonedDateTime;", "Lnet/corda/serialization/internal/amqp/custom/ZonedDateTimeSerializer$ZonedDateTimeProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "additionalSerializers", "", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "", "getAdditionalSerializers", "()Ljava/lang/Iterable;", "fromProxy", "proxy", "toProxy", "obj", "Companion", "ZonedDateTimeProxy", "serialization"})
public final class ZonedDateTimeSerializer
extends CustomSerializer.Proxy<ZonedDateTime, ZonedDateTimeProxy> {
    @NotNull
    private final Iterable<CustomSerializer<? extends Object>> additionalSerializers;
    @NotNull
    private static final Method ofLenient;
    public static final Companion Companion;

    @Override
    @NotNull
    public Iterable<CustomSerializer<? extends Object>> getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    @Override
    @NotNull
    protected ZonedDateTimeProxy toProxy(@NotNull ZonedDateTime obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        LocalDateTime localDateTime = obj.toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"obj.toLocalDateTime()");
        ZoneOffset zoneOffset = obj.getOffset();
        Intrinsics.checkExpressionValueIsNotNull((Object)zoneOffset, (String)"obj.offset");
        ZoneId zoneId = obj.getZone();
        Intrinsics.checkExpressionValueIsNotNull((Object)zoneId, (String)"obj.zone");
        return new ZonedDateTimeProxy(localDateTime, zoneOffset, zoneId);
    }

    @Override
    @NotNull
    protected ZonedDateTime fromProxy(@NotNull ZonedDateTimeProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Object object = ofLenient.invoke(null, proxy.getDateTime(), proxy.getOffset(), proxy.getZone());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.time.ZonedDateTime");
        }
        return (ZonedDateTime)object;
    }

    public ZonedDateTimeSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(ZonedDateTime.class, ZonedDateTimeProxy.class, factory, false, 8, null);
        this.additionalSerializers = CollectionsKt.listOf((Object[])new CustomSerializer.Proxy[]{new LocalDateTimeSerializer(factory), new ZoneIdSerializer(factory)});
    }

    static {
        Companion = new Companion(null);
        Method method = ZonedDateTime.class.getDeclaredMethod("ofLenient", LocalDateTime.class, ZoneOffset.class, ZoneId.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"ZonedDateTime::class.jav\u2026eId::class.java\n        )");
        ofLenient = method;
        ofLenient.setAccessible(true);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/custom/ZonedDateTimeSerializer$ZonedDateTimeProxy;", "", "dateTime", "Ljava/time/LocalDateTime;", "offset", "Ljava/time/ZoneOffset;", "zone", "Ljava/time/ZoneId;", "(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V", "getDateTime", "()Ljava/time/LocalDateTime;", "getOffset", "()Ljava/time/ZoneOffset;", "getZone", "()Ljava/time/ZoneId;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "serialization"})
    @KeepForDJVM
    public static final class ZonedDateTimeProxy {
        @NotNull
        private final LocalDateTime dateTime;
        @NotNull
        private final ZoneOffset offset;
        @NotNull
        private final ZoneId zone;

        @NotNull
        public final LocalDateTime getDateTime() {
            return this.dateTime;
        }

        @NotNull
        public final ZoneOffset getOffset() {
            return this.offset;
        }

        @NotNull
        public final ZoneId getZone() {
            return this.zone;
        }

        public ZonedDateTimeProxy(@NotNull LocalDateTime dateTime, @NotNull ZoneOffset offset, @NotNull ZoneId zone) {
            Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
            Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
            Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
            this.dateTime = dateTime;
            this.offset = offset;
            this.zone = zone;
        }

        @NotNull
        public final LocalDateTime component1() {
            return this.dateTime;
        }

        @NotNull
        public final ZoneOffset component2() {
            return this.offset;
        }

        @NotNull
        public final ZoneId component3() {
            return this.zone;
        }

        @NotNull
        public final ZonedDateTimeProxy copy(@NotNull LocalDateTime dateTime, @NotNull ZoneOffset offset, @NotNull ZoneId zone) {
            Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
            Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
            Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
            return new ZonedDateTimeProxy(dateTime, offset, zone);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ZonedDateTimeProxy copy$default(ZonedDateTimeProxy zonedDateTimeProxy, LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId, int n, Object object) {
            if ((n & 1) != 0) {
                localDateTime = zonedDateTimeProxy.dateTime;
            }
            if ((n & 2) != 0) {
                zoneOffset = zonedDateTimeProxy.offset;
            }
            if ((n & 4) != 0) {
                zoneId = zonedDateTimeProxy.zone;
            }
            return zonedDateTimeProxy.copy(localDateTime, zoneOffset, zoneId);
        }

        @NotNull
        public String toString() {
            return "ZonedDateTimeProxy(dateTime=" + this.dateTime + ", offset=" + this.offset + ", zone=" + this.zone + ")";
        }

        public int hashCode() {
            LocalDateTime localDateTime = this.dateTime;
            ZoneOffset zoneOffset = this.offset;
            ZoneId zoneId = this.zone;
            return ((localDateTime != null ? ((Object)localDateTime).hashCode() : 0) * 31 + (zoneOffset != null ? ((Object)zoneOffset).hashCode() : 0)) * 31 + (zoneId != null ? ((Object)zoneId).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ZonedDateTimeProxy)) break block3;
                    ZonedDateTimeProxy zonedDateTimeProxy = (ZonedDateTimeProxy)object;
                    if (!Intrinsics.areEqual((Object)this.dateTime, (Object)zonedDateTimeProxy.dateTime) || !Intrinsics.areEqual((Object)this.offset, (Object)zonedDateTimeProxy.offset) || !Intrinsics.areEqual((Object)this.zone, (Object)zonedDateTimeProxy.zone)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/serialization/internal/amqp/custom/ZonedDateTimeSerializer$Companion;", "", "()V", "ofLenient", "Ljava/lang/reflect/Method;", "getOfLenient", "()Ljava/lang/reflect/Method;", "serialization"})
    public static final class Companion {
        @NotNull
        public final Method getOfLenient() {
            return ofLenient;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

